package com.gradle.develocity.agent.gradle.test;

import com.gradle.junit.xml.streaming.parser.ParserDialect;
import com.gradle.obfuscation.KeepMethods;
import com.gradle.obfuscation.KeepName;

/**
 * Supported JUnit XML report file dialects
 *
 * @since 3.17
 */
@KeepName
@KeepMethods
public enum JUnitXmlDialect {

    /**
     * Produced by the Gradle Android Plugin instrumentation tests
     */
    ANDROID_CONNECTED(ParserDialect.ANDROID_CONNECTED),

    /**
     * Produced by the Firebase Test Lab using (fladle/flank)
     */
    ANDROID_FIREBASE(ParserDialect.ANDROID_FIREBASE),

    /**
     * Dialect used for JUnit XML reports where no specific dialect is available.
     * It may be that the parser is not able to parse the given JUnit XML report due to
     * variances in the format. Therefore, it's required to ensure the correctness of the
     * data shown in the Build Scan by comparing it with the raw JUnit XML.
     * <p>
     * The following testing frameworks have been verified for correctness with this dialect:
     *
     * <ul>
     *     <li>Cypress (https://cypress.io) with default junit reporter</li>
     *     <li>Jest (https://jestjs.io) with default jest-junit reporter</li>
     * </ul>
     */
    GENERIC(ParserDialect.GENERIC);

    private final ParserDialect parserDialect;

    JUnitXmlDialect(ParserDialect parserDialect) {
        this.parserDialect = parserDialect;
    }

    ParserDialect toParserDialect() {
        return parserDialect;
    }
}
