package com.gradle.scan.plugin;

import com.gradle.obfuscation.Keep;

/**
 * Allows configuring what data will be captured as part of the build scan.
 *
 * @see BuildScanExtension#getCapture()
 * @since 3.7
 * @deprecated since 3.17, replaced by {@link com.gradle.develocity.agent.gradle.scan.BuildScanCaptureConfiguration}
 */
@Keep
@Deprecated
public interface BuildScanCaptureSettings {

    /**
     * Specifies whether to capture information about each file used as an input to a task.
     * <p>
     * Defaults to {@code false}.
     * <p>
     * Enabling this feature may increase the size of the build scan data.
     * This requires more time to transmit to the server, and more storage space at the server.
     * Most builds will not incur a noticeable difference when this feature is enabled.
     * Large builds may increase the build scan data by a handful of megabytes.
     * For most builds, the increase will be negligible.
     * <p>
     * If using Gradle Enterprise with a good connection to the server this capture should be enabled,
     * as it allows comparing task inputs at a file level when comparing builds.
     * <p>
     * This property may also be set by the {@code "scan.capture-task-input-files"} system property.
     * If this is set to any value other than {@code "false"}, the capture will be enabled.
     * If this is set to {@code "false"}, the capture will be disabled.
     * If the capture is enabled or disabled via system property, calling this method has no effect.
     * That is, the system property takes precedence over the value set via this method.
     * <p>
     * This method cannot be called after the root project has finished configuring.
     * Doing so will produce a build time error.
     *
     * @param capture whether to capture information about each file use as an input to a task
     */
    void setTaskInputFiles(boolean capture);

    /**
     * See {@link #setTaskInputFiles(boolean)}.
     *
     * @return whether information about each file used as an input to a task will be captured
     */
    boolean isTaskInputFiles();

    /**
     * Specifies whether to capture build logging output.
     * <p>
     * Defaults to {@code true}.
     * <p>
     * This method cannot be called after the root project has finished configuring.
     * Doing so will produce a build time error.
     *
     * @param capture whether to capture build logging output
     */
    void setBuildLogging(boolean capture);

    /**
     * See {@link #setBuildLogging(boolean)}.
     *
     * @return whether build logging output will be captured
     */
    boolean isBuildLogging();

    /**
     * Specifies whether to capture test logging output.
     * <p>
     * Defaults to {@code true}.
     * <p>
     * This method cannot be called after the root project has finished configuring.
     * Doing so will produce a build time error.
     *
     * @param capture whether to capture test logging output
     */
    void setTestLogging(boolean capture);

    /**
     * See {@link #setTestLogging(boolean)}.
     *
     * @return whether test logging output will be captured
     */
    boolean isTestLogging();

}
