/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.datatype.jdk8;

import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonGenerator;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.BeanProperty;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.JavaType;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.JsonMappingException;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.JsonSerializer;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.MapperFeature;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.SerializerProvider;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.datatype.jdk8.WrappedIOException;
import java.io.IOException;
import java.util.stream.Stream;

public class StreamSerializer
extends StdSerializer<Stream<?>>
implements ContextualSerializer {
    private final JavaType elemType;
    private final transient JsonSerializer<Object> elemSerializer;

    public StreamSerializer(JavaType javaType, JavaType javaType2) {
        this(javaType, javaType2, null);
    }

    public StreamSerializer(JavaType javaType, JavaType javaType2, JsonSerializer<Object> jsonSerializer) {
        super(javaType);
        this.elemType = javaType2;
        this.elemSerializer = jsonSerializer;
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider serializerProvider, BeanProperty beanProperty) throws JsonMappingException {
        if (!this.elemType.hasRawClass(Object.class) && (serializerProvider.isEnabled(MapperFeature.USE_STATIC_TYPING) || this.elemType.isFinal())) {
            return new StreamSerializer(serializerProvider.getTypeFactory().constructParametricType(Stream.class, this.elemType), this.elemType, serializerProvider.findPrimaryPropertySerializer(this.elemType, beanProperty));
        }
        return this;
    }

    @Override
    public void serialize(Stream<?> stream, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        try (Stream<?> stream2 = stream;){
            jsonGenerator.writeStartArray();
            stream2.forEachOrdered(object -> {
                try {
                    if (this.elemSerializer == null) {
                        serializerProvider.defaultSerializeValue(object, jsonGenerator);
                    } else {
                        this.elemSerializer.serialize(object, jsonGenerator, serializerProvider);
                    }
                }
                catch (IOException iOException) {
                    throw new WrappedIOException(iOException);
                }
            });
            jsonGenerator.writeEndArray();
        }
        catch (WrappedIOException wrappedIOException) {
            throw wrappedIOException.getCause();
        }
    }
}

