/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http;

import com.gradle.scan.plugin.internal.dep.io.netty.buffer.ByteBuf;
import com.gradle.scan.plugin.internal.dep.io.netty.buffer.Unpooled;
import com.gradle.scan.plugin.internal.dep.io.netty.channel.ChannelHandlerContext;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.ByteToMessageDecoder;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.DecoderResult;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.PrematureChannelClosureException;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.TooLongFrameException;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.DefaultHttpContent;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.DefaultHttpHeadersFactory;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.DefaultLastHttpContent;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.HttpContent;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.HttpDecoderConfig;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.HttpExpectationFailedEvent;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.HttpHeaderNames;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.HttpHeaderValues;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.HttpHeaders;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.HttpHeadersFactory;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.HttpMessage;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.HttpMessageDecoderResult;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.HttpResponse;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.HttpResponseStatus;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.HttpStatusClass;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.HttpUtil;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.HttpVersion;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.LastHttpContent;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.TooLongHttpHeaderException;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.TooLongHttpLineException;
import com.gradle.scan.plugin.internal.dep.io.netty.util.AsciiString;
import com.gradle.scan.plugin.internal.dep.io.netty.util.ByteProcessor;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.ObjectUtil;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.StringUtil;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class HttpObjectDecoder
extends ByteToMessageDecoder {
    private final int maxChunkSize;
    private final boolean chunkedSupported;
    private final boolean allowPartialChunks;
    @Deprecated
    protected final boolean validateHeaders;
    protected final HttpHeadersFactory headersFactory;
    protected final HttpHeadersFactory trailersFactory;
    private final boolean allowDuplicateContentLengths;
    private final ByteBuf parserScratchBuffer;
    private final HeaderParser headerParser;
    private final LineParser lineParser;
    private HttpMessage message;
    private long chunkSize;
    private long contentLength = Long.MIN_VALUE;
    private final AtomicBoolean resetRequested = new AtomicBoolean();
    private AsciiString name;
    private String value;
    private LastHttpContent trailer;
    private State currentState = State.SKIP_CONTROL_CHARS;
    private static final boolean[] SP_LENIENT_BYTES;
    private static final boolean[] LATIN_WHITESPACE;
    private static final boolean[] ISO_CONTROL_OR_WHITESPACE;
    private static final ByteProcessor SKIP_CONTROL_CHARS_BYTES;

    @Override
    protected void handlerRemoved0(ChannelHandlerContext channelHandlerContext) throws Exception {
        try {
            this.parserScratchBuffer.release();
        }
        finally {
            super.handlerRemoved0(channelHandlerContext);
        }
    }

    protected HttpObjectDecoder() {
        this(new HttpDecoderConfig());
    }

    protected HttpObjectDecoder(HttpDecoderConfig httpDecoderConfig) {
        ObjectUtil.checkNotNull(httpDecoderConfig, "config");
        this.parserScratchBuffer = Unpooled.buffer(httpDecoderConfig.getInitialBufferSize());
        this.lineParser = new LineParser(this.parserScratchBuffer, httpDecoderConfig.getMaxInitialLineLength());
        this.headerParser = new HeaderParser(this.parserScratchBuffer, httpDecoderConfig.getMaxHeaderSize());
        this.maxChunkSize = httpDecoderConfig.getMaxChunkSize();
        this.chunkedSupported = httpDecoderConfig.isChunkedSupported();
        this.headersFactory = httpDecoderConfig.getHeadersFactory();
        this.trailersFactory = httpDecoderConfig.getTrailersFactory();
        this.validateHeaders = this.isValidating(this.headersFactory);
        this.allowDuplicateContentLengths = httpDecoderConfig.isAllowDuplicateContentLengths();
        this.allowPartialChunks = httpDecoderConfig.isAllowPartialChunks();
    }

    protected boolean isValidating(HttpHeadersFactory httpHeadersFactory) {
        if (httpHeadersFactory instanceof DefaultHttpHeadersFactory) {
            DefaultHttpHeadersFactory defaultHttpHeadersFactory = (DefaultHttpHeadersFactory)httpHeadersFactory;
            return defaultHttpHeadersFactory.isValidatingHeaderNames() || defaultHttpHeadersFactory.isValidatingHeaderValues();
        }
        return true;
    }

    @Override
    protected void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) throws Exception {
        if (this.resetRequested.get()) {
            this.resetNow();
        }
        switch (this.currentState) {
            case SKIP_CONTROL_CHARS: 
            case READ_INITIAL: {
                Object object;
                try {
                    object = this.lineParser.parse(byteBuf);
                    if (object == null) {
                        return;
                    }
                    String[] stringArray = this.splitInitialLine((ByteBuf)object);
                    assert (stringArray.length == 3) : "initialLine::length must be 3";
                    this.message = this.createMessage(stringArray);
                    this.currentState = State.READ_HEADER;
                }
                catch (Exception exception) {
                    list.add(this.invalidMessage(byteBuf, exception));
                    return;
                }
            }
            case READ_HEADER: {
                Object object;
                try {
                    object = this.readHeaders(byteBuf);
                    if (object == null) {
                        return;
                    }
                    this.currentState = object;
                    switch (2.$SwitchMap$io$netty$handler$codec$http$HttpObjectDecoder$State[((Enum)object).ordinal()]) {
                        case 1: {
                            list.add(this.message);
                            list.add(LastHttpContent.EMPTY_LAST_CONTENT);
                            this.resetNow();
                            return;
                        }
                        case 2: {
                            if (!this.chunkedSupported) {
                                throw new IllegalArgumentException("Chunked messages not supported");
                            }
                            list.add(this.message);
                            return;
                        }
                    }
                    long l2 = this.contentLength();
                    if (l2 == 0L || l2 == -1L && this.isDecodingRequest()) {
                        list.add(this.message);
                        list.add(LastHttpContent.EMPTY_LAST_CONTENT);
                        this.resetNow();
                        return;
                    }
                    assert (object == State.READ_FIXED_LENGTH_CONTENT || object == State.READ_VARIABLE_LENGTH_CONTENT);
                    list.add(this.message);
                    if (object == State.READ_FIXED_LENGTH_CONTENT) {
                        this.chunkSize = l2;
                    }
                    return;
                }
                catch (Exception exception) {
                    list.add(this.invalidMessage(byteBuf, exception));
                    return;
                }
            }
            case READ_VARIABLE_LENGTH_CONTENT: {
                int n2 = Math.min(byteBuf.readableBytes(), this.maxChunkSize);
                if (n2 > 0) {
                    ByteBuf byteBuf2 = byteBuf.readRetainedSlice(n2);
                    list.add(new DefaultHttpContent(byteBuf2));
                }
                return;
            }
            case READ_FIXED_LENGTH_CONTENT: {
                int n3 = byteBuf.readableBytes();
                if (n3 == 0) {
                    return;
                }
                int n4 = Math.min(n3, this.maxChunkSize);
                if ((long)n4 > this.chunkSize) {
                    n4 = (int)this.chunkSize;
                }
                ByteBuf byteBuf3 = byteBuf.readRetainedSlice(n4);
                this.chunkSize -= (long)n4;
                if (this.chunkSize == 0L) {
                    list.add(new DefaultLastHttpContent(byteBuf3, this.trailersFactory));
                    this.resetNow();
                } else {
                    list.add(new DefaultHttpContent(byteBuf3));
                }
                return;
            }
            case READ_CHUNK_SIZE: {
                try {
                    ByteBuf byteBuf4 = this.lineParser.parse(byteBuf);
                    if (byteBuf4 == null) {
                        return;
                    }
                    int n5 = HttpObjectDecoder.getChunkSize(byteBuf4.array(), byteBuf4.arrayOffset() + byteBuf4.readerIndex(), byteBuf4.readableBytes());
                    this.chunkSize = n5;
                    if (n5 == 0) {
                        this.currentState = State.READ_CHUNK_FOOTER;
                        return;
                    }
                    this.currentState = State.READ_CHUNKED_CONTENT;
                }
                catch (Exception exception) {
                    list.add(this.invalidChunk(byteBuf, exception));
                    return;
                }
            }
            case READ_CHUNKED_CONTENT: {
                assert (this.chunkSize <= Integer.MAX_VALUE);
                int n6 = Math.min((int)this.chunkSize, this.maxChunkSize);
                if (!this.allowPartialChunks && byteBuf.readableBytes() < n6) {
                    return;
                }
                if ((n6 = Math.min(n6, byteBuf.readableBytes())) == 0) {
                    return;
                }
                DefaultHttpContent defaultHttpContent = new DefaultHttpContent(byteBuf.readRetainedSlice(n6));
                this.chunkSize -= (long)n6;
                list.add(defaultHttpContent);
                if (this.chunkSize != 0L) {
                    return;
                }
                this.currentState = State.READ_CHUNK_DELIMITER;
            }
            case READ_CHUNK_DELIMITER: {
                int n6 = byteBuf.writerIndex();
                int n7 = byteBuf.readerIndex();
                while (n6 > n7) {
                    byte by2;
                    if ((by2 = byteBuf.getByte(n7++)) != 10) continue;
                    this.currentState = State.READ_CHUNK_SIZE;
                    break;
                }
                byteBuf.readerIndex(n7);
                return;
            }
            case READ_CHUNK_FOOTER: {
                try {
                    LastHttpContent lastHttpContent = this.readTrailingHeaders(byteBuf);
                    if (lastHttpContent == null) {
                        return;
                    }
                    list.add(lastHttpContent);
                    this.resetNow();
                    return;
                }
                catch (Exception exception) {
                    list.add(this.invalidChunk(byteBuf, exception));
                    return;
                }
            }
            case BAD_MESSAGE: {
                byteBuf.skipBytes(byteBuf.readableBytes());
                break;
            }
            case UPGRADED: {
                int n8 = byteBuf.readableBytes();
                if (n8 <= 0) break;
                list.add(byteBuf.readBytes(n8));
                break;
            }
        }
    }

    @Override
    protected void decodeLast(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) throws Exception {
        super.decodeLast(channelHandlerContext, byteBuf, list);
        if (this.resetRequested.get()) {
            this.resetNow();
        }
        if (this.message != null) {
            boolean bl2;
            boolean bl3 = HttpUtil.isTransferEncodingChunked(this.message);
            if (this.currentState == State.READ_VARIABLE_LENGTH_CONTENT && !byteBuf.isReadable() && !bl3) {
                list.add(LastHttpContent.EMPTY_LAST_CONTENT);
                this.resetNow();
                return;
            }
            if (this.currentState == State.READ_HEADER) {
                list.add(this.invalidMessage(Unpooled.EMPTY_BUFFER, new PrematureChannelClosureException("Connection closed before received headers")));
                this.resetNow();
                return;
            }
            if (this.isDecodingRequest() || bl3) {
                bl2 = true;
            } else {
                boolean bl4 = bl2 = this.contentLength() > 0L;
            }
            if (!bl2) {
                list.add(LastHttpContent.EMPTY_LAST_CONTENT);
            }
            this.resetNow();
        }
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext channelHandlerContext, Object object) throws Exception {
        if (object instanceof HttpExpectationFailedEvent) {
            switch (this.currentState) {
                case READ_CHUNK_SIZE: 
                case READ_VARIABLE_LENGTH_CONTENT: 
                case READ_FIXED_LENGTH_CONTENT: {
                    this.reset();
                    break;
                }
            }
        }
        super.userEventTriggered(channelHandlerContext, object);
    }

    protected boolean isContentAlwaysEmpty(HttpMessage httpMessage) {
        if (httpMessage instanceof HttpResponse) {
            HttpResponse httpResponse = (HttpResponse)httpMessage;
            HttpResponseStatus httpResponseStatus = httpResponse.status();
            int n2 = httpResponseStatus.code();
            HttpStatusClass httpStatusClass = httpResponseStatus.codeClass();
            if (httpStatusClass == HttpStatusClass.INFORMATIONAL) {
                return n2 != 101 || httpResponse.headers().contains(HttpHeaderNames.SEC_WEBSOCKET_ACCEPT) || !httpResponse.headers().contains(HttpHeaderNames.UPGRADE, HttpHeaderValues.WEBSOCKET, true);
            }
            switch (n2) {
                case 204: 
                case 304: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    protected boolean isSwitchingToNonHttp1Protocol(HttpResponse httpResponse) {
        if (httpResponse.status().code() != HttpResponseStatus.SWITCHING_PROTOCOLS.code()) {
            return false;
        }
        String string = httpResponse.headers().get(HttpHeaderNames.UPGRADE);
        return string == null || !string.contains(HttpVersion.HTTP_1_0.text()) && !string.contains(HttpVersion.HTTP_1_1.text());
    }

    public void reset() {
        this.resetRequested.lazySet(true);
    }

    private void resetNow() {
        HttpResponse httpResponse;
        HttpMessage httpMessage = this.message;
        this.message = null;
        this.name = null;
        this.value = null;
        this.contentLength = Long.MIN_VALUE;
        this.lineParser.reset();
        this.headerParser.reset();
        this.trailer = null;
        if (!this.isDecodingRequest() && (httpResponse = (HttpResponse)httpMessage) != null && this.isSwitchingToNonHttp1Protocol(httpResponse)) {
            this.currentState = State.UPGRADED;
            return;
        }
        this.resetRequested.lazySet(false);
        this.currentState = State.SKIP_CONTROL_CHARS;
    }

    private HttpMessage invalidMessage(ByteBuf byteBuf, Exception exception) {
        this.currentState = State.BAD_MESSAGE;
        byteBuf.skipBytes(byteBuf.readableBytes());
        if (this.message == null) {
            this.message = this.createInvalidMessage();
        }
        this.message.setDecoderResult(DecoderResult.failure(exception));
        HttpMessage httpMessage = this.message;
        this.message = null;
        return httpMessage;
    }

    private HttpContent invalidChunk(ByteBuf byteBuf, Exception exception) {
        this.currentState = State.BAD_MESSAGE;
        byteBuf.skipBytes(byteBuf.readableBytes());
        DefaultLastHttpContent defaultLastHttpContent = new DefaultLastHttpContent(Unpooled.EMPTY_BUFFER);
        defaultLastHttpContent.setDecoderResult(DecoderResult.failure(exception));
        this.message = null;
        this.trailer = null;
        return defaultLastHttpContent;
    }

    private State readHeaders(ByteBuf byteBuf) {
        String string;
        Object object;
        HttpMessage httpMessage = this.message;
        HttpHeaders httpHeaders = httpMessage.headers();
        HeaderParser headerParser = this.headerParser;
        ByteBuf byteBuf2 = headerParser.parse(byteBuf);
        if (byteBuf2 == null) {
            return null;
        }
        int n2 = byteBuf2.readableBytes();
        while (n2 > 0) {
            object = byteBuf2.array();
            int n3 = byteBuf2.arrayOffset() + byteBuf2.readerIndex();
            byte by2 = object[n3];
            if (this.name != null && (by2 == 32 || by2 == 9)) {
                String string2 = HttpObjectDecoder.langAsciiString(object, n3, n2).trim();
                string = this.value;
                this.value = string + ' ' + string2;
            } else {
                if (this.name != null) {
                    httpHeaders.add(this.name, (Object)this.value);
                }
                this.splitHeader((byte[])object, n3, n2);
            }
            byteBuf2 = headerParser.parse(byteBuf);
            if (byteBuf2 == null) {
                return null;
            }
            n2 = byteBuf2.readableBytes();
        }
        if (this.name != null) {
            httpHeaders.add(this.name, (Object)this.value);
        }
        this.name = null;
        this.value = null;
        object = new HttpMessageDecoderResult(this.lineParser.size, headerParser.size);
        httpMessage.setDecoderResult((DecoderResult)object);
        List<String> list = httpHeaders.getAll(HttpHeaderNames.CONTENT_LENGTH);
        if (!list.isEmpty()) {
            HttpVersion httpVersion = httpMessage.protocolVersion();
            boolean bl2 = httpVersion.majorVersion() < 1 || httpVersion.majorVersion() == 1 && httpVersion.minorVersion() == 0;
            this.contentLength = HttpUtil.normalizeAndGetContentLength(list, bl2, this.allowDuplicateContentLengths);
            if (this.contentLength != -1L) {
                string = list.get(0).trim();
                if (list.size() > 1 || !string.equals(Long.toString(this.contentLength))) {
                    httpHeaders.set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)this.contentLength);
                }
            }
        }
        if (this.isContentAlwaysEmpty(httpMessage)) {
            HttpUtil.setTransferEncodingChunked(httpMessage, false);
            return State.SKIP_CONTROL_CHARS;
        }
        if (HttpUtil.isTransferEncodingChunked(httpMessage)) {
            if (!list.isEmpty() && httpMessage.protocolVersion() == HttpVersion.HTTP_1_1) {
                this.handleTransferEncodingChunkedWithContentLength(httpMessage);
            }
            return State.READ_CHUNK_SIZE;
        }
        if (this.contentLength() >= 0L) {
            return State.READ_FIXED_LENGTH_CONTENT;
        }
        return State.READ_VARIABLE_LENGTH_CONTENT;
    }

    protected void handleTransferEncodingChunkedWithContentLength(HttpMessage httpMessage) {
        httpMessage.headers().remove(HttpHeaderNames.CONTENT_LENGTH);
        this.contentLength = Long.MIN_VALUE;
    }

    private long contentLength() {
        if (this.contentLength == Long.MIN_VALUE) {
            this.contentLength = HttpUtil.getContentLength(this.message, -1L);
        }
        return this.contentLength;
    }

    private LastHttpContent readTrailingHeaders(ByteBuf byteBuf) {
        HeaderParser headerParser = this.headerParser;
        ByteBuf byteBuf2 = headerParser.parse(byteBuf);
        if (byteBuf2 == null) {
            return null;
        }
        LastHttpContent lastHttpContent = this.trailer;
        int n2 = byteBuf2.readableBytes();
        if (n2 == 0 && lastHttpContent == null) {
            return LastHttpContent.EMPTY_LAST_CONTENT;
        }
        AsciiString asciiString = null;
        if (lastHttpContent == null) {
            lastHttpContent = this.trailer = new DefaultLastHttpContent(Unpooled.EMPTY_BUFFER, this.trailersFactory);
        }
        while (n2 > 0) {
            List<String> list;
            byte[] byArray = byteBuf2.array();
            int n3 = byteBuf2.arrayOffset() + byteBuf2.readerIndex();
            byte by2 = byArray[n3];
            if (asciiString != null && (by2 == 32 || by2 == 9)) {
                list = lastHttpContent.trailingHeaders().getAll(asciiString);
                if (!list.isEmpty()) {
                    int n4 = list.size() - 1;
                    String string = HttpObjectDecoder.langAsciiString(byArray, n3, byteBuf2.readableBytes()).trim();
                    String string2 = (String)list.get(n4);
                    list.set(n4, string2 + string);
                }
            } else {
                this.splitHeader(byArray, n3, n2);
                list = this.name;
                if (!(HttpHeaderNames.CONTENT_LENGTH.contentEqualsIgnoreCase((CharSequence)((Object)list)) || HttpHeaderNames.TRANSFER_ENCODING.contentEqualsIgnoreCase((CharSequence)((Object)list)) || HttpHeaderNames.TRAILER.contentEqualsIgnoreCase((CharSequence)((Object)list)))) {
                    lastHttpContent.trailingHeaders().add((CharSequence)((Object)list), (Object)this.value);
                }
                asciiString = this.name;
                this.name = null;
                this.value = null;
            }
            byteBuf2 = headerParser.parse(byteBuf);
            if (byteBuf2 == null) {
                return null;
            }
            n2 = byteBuf2.readableBytes();
        }
        this.trailer = null;
        return lastHttpContent;
    }

    protected abstract boolean isDecodingRequest();

    protected abstract HttpMessage createMessage(String[] var1) throws Exception;

    protected abstract HttpMessage createInvalidMessage();

    private static int skipWhiteSpaces(byte[] byArray, int n2, int n3) {
        for (int i2 = 0; i2 < n3; ++i2) {
            if (HttpObjectDecoder.isWhitespace(byArray[n2 + i2])) continue;
            return i2;
        }
        return n3;
    }

    private static int getChunkSize(byte[] byArray, int n2, int n3) {
        int n4 = HttpObjectDecoder.skipWhiteSpaces(byArray, n2, n3);
        if (n4 == n3) {
            throw new NumberFormatException();
        }
        n2 += n4;
        n3 -= n4;
        int n5 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n6 = StringUtil.decodeHexNibble(byArray[n2 + i2]);
            if (n6 == -1) {
                byte by2 = byArray[n2 + i2];
                if (by2 == 59 || HttpObjectDecoder.isControlOrWhitespaceAsciiChar(by2)) {
                    if (i2 == 0) {
                        throw new NumberFormatException();
                    }
                    return n5;
                }
                throw new NumberFormatException();
            }
            n5 *= 16;
            n5 += n6;
        }
        return n5;
    }

    private String[] splitInitialLine(ByteBuf byteBuf) {
        byte[] byArray = byteBuf.array();
        int n2 = byteBuf.arrayOffset();
        int n3 = n2 + byteBuf.readerIndex();
        int n4 = n3 + byteBuf.readableBytes();
        int n5 = HttpObjectDecoder.findNonSPLenient(byArray, n3, n4);
        int n6 = HttpObjectDecoder.findSPLenient(byArray, n5, n4);
        int n7 = HttpObjectDecoder.findNonSPLenient(byArray, n6, n4);
        int n8 = HttpObjectDecoder.findSPLenient(byArray, n7, n4);
        int n9 = HttpObjectDecoder.findNonSPLenient(byArray, n8, n4);
        int n10 = HttpObjectDecoder.findEndOfString(byArray, Math.max(n9 - 1, n3), n4);
        return new String[]{this.splitFirstWordInitialLine(byArray, n5, n6 - n5), this.splitSecondWordInitialLine(byArray, n7, n8 - n7), n9 < n10 ? this.splitThirdWordInitialLine(byArray, n9, n10 - n9) : ""};
    }

    protected String splitFirstWordInitialLine(byte[] byArray, int n2, int n3) {
        return HttpObjectDecoder.langAsciiString(byArray, n2, n3);
    }

    protected String splitSecondWordInitialLine(byte[] byArray, int n2, int n3) {
        return HttpObjectDecoder.langAsciiString(byArray, n2, n3);
    }

    protected String splitThirdWordInitialLine(byte[] byArray, int n2, int n3) {
        return HttpObjectDecoder.langAsciiString(byArray, n2, n3);
    }

    private static String langAsciiString(byte[] byArray, int n2, int n3) {
        if (n3 == 0) {
            return "";
        }
        if (n2 == 0) {
            if (n3 == byArray.length) {
                return new String(byArray, 0, 0, byArray.length);
            }
            return new String(byArray, 0, 0, n3);
        }
        return new String(byArray, 0, n2, n3);
    }

    private void splitHeader(byte[] byArray, int n2, int n3) {
        int n4;
        int n5;
        int n6 = n2 + n3;
        int n7 = HttpObjectDecoder.findNonWhitespace(byArray, n2, n6);
        boolean bl2 = this.isDecodingRequest();
        for (n5 = n7; n5 < n6 && (n4 = byArray[n5]) != 58 && (bl2 || !HttpObjectDecoder.isOWS((byte)n4)); ++n5) {
        }
        if (n5 == n6) {
            throw new IllegalArgumentException("No colon found");
        }
        for (n4 = n5; n4 < n6; ++n4) {
            if (byArray[n4] != 58) continue;
            ++n4;
            break;
        }
        this.name = this.splitHeaderName(byArray, n7, n5 - n7);
        int n8 = HttpObjectDecoder.findNonWhitespace(byArray, n4, n6);
        if (n8 == n6) {
            this.value = "";
        } else {
            int n9 = HttpObjectDecoder.findEndOfString(byArray, n2, n6);
            this.value = HttpObjectDecoder.langAsciiString(byArray, n8, n9 - n8);
        }
    }

    protected AsciiString splitHeaderName(byte[] byArray, int n2, int n3) {
        return new AsciiString(byArray, n2, n3, true);
    }

    private static int findNonSPLenient(byte[] byArray, int n2, int n3) {
        for (int i2 = n2; i2 < n3; ++i2) {
            byte by2 = byArray[i2];
            if (HttpObjectDecoder.isSPLenient(by2)) continue;
            if (HttpObjectDecoder.isWhitespace(by2)) {
                throw new IllegalArgumentException("Invalid separator");
            }
            return i2;
        }
        return n3;
    }

    private static int findSPLenient(byte[] byArray, int n2, int n3) {
        for (int i2 = n2; i2 < n3; ++i2) {
            if (!HttpObjectDecoder.isSPLenient(byArray[i2])) continue;
            return i2;
        }
        return n3;
    }

    private static boolean isSPLenient(byte by2) {
        return SP_LENIENT_BYTES[by2 + 128];
    }

    private static boolean isWhitespace(byte by2) {
        return LATIN_WHITESPACE[by2 + 128];
    }

    private static int findNonWhitespace(byte[] byArray, int n2, int n3) {
        for (int i2 = n2; i2 < n3; ++i2) {
            byte by2 = byArray[i2];
            if (!HttpObjectDecoder.isWhitespace(by2)) {
                return i2;
            }
            if (HttpObjectDecoder.isOWS(by2)) continue;
            throw new IllegalArgumentException("Invalid separator, only a single space or horizontal tab allowed, but received a '" + by2 + "' (0x" + Integer.toHexString(by2) + ")");
        }
        return n3;
    }

    private static int findEndOfString(byte[] byArray, int n2, int n3) {
        for (int i2 = n3 - 1; i2 > n2; --i2) {
            if (HttpObjectDecoder.isWhitespace(byArray[i2])) continue;
            return i2 + 1;
        }
        return 0;
    }

    private static boolean isOWS(byte by2) {
        return by2 == 32 || by2 == 9;
    }

    private static boolean isControlOrWhitespaceAsciiChar(byte by2) {
        return ISO_CONTROL_OR_WHITESPACE[128 + by2];
    }

    static {
        byte by2;
        SP_LENIENT_BYTES = new boolean[256];
        HttpObjectDecoder.SP_LENIENT_BYTES[160] = true;
        HttpObjectDecoder.SP_LENIENT_BYTES[137] = true;
        HttpObjectDecoder.SP_LENIENT_BYTES[139] = true;
        HttpObjectDecoder.SP_LENIENT_BYTES[140] = true;
        HttpObjectDecoder.SP_LENIENT_BYTES[141] = true;
        LATIN_WHITESPACE = new boolean[256];
        for (by2 = -128; by2 < 127; by2 = (byte)((byte)(by2 + 1))) {
            HttpObjectDecoder.LATIN_WHITESPACE[128 + by2] = Character.isWhitespace(by2);
        }
        ISO_CONTROL_OR_WHITESPACE = new boolean[256];
        for (by2 = -128; by2 < 127; by2 = (byte)(by2 + 1)) {
            HttpObjectDecoder.ISO_CONTROL_OR_WHITESPACE[128 + by2] = Character.isISOControl(by2) || HttpObjectDecoder.isWhitespace(by2);
        }
        SKIP_CONTROL_CHARS_BYTES = new ByteProcessor(){

            @Override
            public boolean process(byte by2) {
                return ISO_CONTROL_OR_WHITESPACE[128 + by2];
            }
        };
    }

    private final class LineParser
    extends HeaderParser {
        LineParser(ByteBuf byteBuf, int n2) {
            super(byteBuf, n2);
        }

        @Override
        public ByteBuf parse(ByteBuf byteBuf) {
            this.reset();
            int n2 = byteBuf.readableBytes();
            if (n2 == 0) {
                return null;
            }
            int n3 = byteBuf.readerIndex();
            if (HttpObjectDecoder.this.currentState == State.SKIP_CONTROL_CHARS && this.skipControlChars(byteBuf, n2, n3)) {
                return null;
            }
            return super.parse(byteBuf);
        }

        private boolean skipControlChars(ByteBuf byteBuf, int n2, int n3) {
            assert (HttpObjectDecoder.this.currentState == State.SKIP_CONTROL_CHARS);
            int n4 = Math.min(this.maxLength, n2);
            int n5 = byteBuf.forEachByte(n3, n4, SKIP_CONTROL_CHARS_BYTES);
            if (n5 == -1) {
                byteBuf.skipBytes(n4);
                if (n2 > this.maxLength) {
                    throw this.newException(this.maxLength);
                }
                return true;
            }
            byteBuf.readerIndex(n5);
            HttpObjectDecoder.this.currentState = State.READ_INITIAL;
            return false;
        }

        @Override
        protected TooLongFrameException newException(int n2) {
            return new TooLongHttpLineException("An HTTP line is larger than " + n2 + " bytes.");
        }
    }

    private static class HeaderParser {
        protected final ByteBuf seq;
        protected final int maxLength;
        int size;

        HeaderParser(ByteBuf byteBuf, int n2) {
            this.seq = byteBuf;
            this.maxLength = n2;
        }

        public ByteBuf parse(ByteBuf byteBuf) {
            int n2 = byteBuf.readableBytes();
            int n3 = byteBuf.readerIndex();
            int n4 = this.maxLength - this.size;
            assert (n4 >= 0);
            long l2 = (long)n4 + 2L;
            int n5 = (int)Math.min(l2, (long)n2);
            int n6 = n3 + n5;
            assert (n6 >= n3);
            int n7 = byteBuf.indexOf(n3, n6, (byte)10);
            if (n7 == -1) {
                if (n2 > n4) {
                    throw this.newException(this.maxLength);
                }
                return null;
            }
            int n8 = n7 > n3 && byteBuf.getByte(n7 - 1) == 13 ? n7 - 1 : n7;
            int n9 = n8 - n3;
            if (n9 == 0) {
                this.seq.clear();
                byteBuf.readerIndex(n7 + 1);
                return this.seq;
            }
            int n10 = this.size + n9;
            if (n10 > this.maxLength) {
                throw this.newException(this.maxLength);
            }
            this.size = n10;
            this.seq.clear();
            this.seq.writeBytes(byteBuf, n3, n9);
            byteBuf.readerIndex(n7 + 1);
            return this.seq;
        }

        public void reset() {
            this.size = 0;
        }

        protected TooLongFrameException newException(int n2) {
            return new TooLongHttpHeaderException("HTTP header is larger than " + n2 + " bytes.");
        }
    }

    private static enum State {
        SKIP_CONTROL_CHARS,
        READ_INITIAL,
        READ_HEADER,
        READ_VARIABLE_LENGTH_CONTENT,
        READ_FIXED_LENGTH_CONTENT,
        READ_CHUNK_SIZE,
        READ_CHUNKED_CONTENT,
        READ_CHUNK_DELIMITER,
        READ_CHUNK_FOOTER,
        BAD_MESSAGE,
        UPGRADED;

    }
}

