/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.io.netty.util;

import com.gradle.scan.plugin.internal.dep.io.netty.util.ReferenceCounted;
import com.gradle.scan.plugin.internal.dep.io.netty.util.ResourceLeakDetector;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.logging.InternalLogger;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.logging.InternalLoggerFactory;

public final class ReferenceCountUtil {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ReferenceCountUtil.class);

    public static <T> T retain(T t2) {
        if (t2 instanceof ReferenceCounted) {
            return (T)((ReferenceCounted)t2).retain();
        }
        return t2;
    }

    public static <T> T touch(T t2, Object object) {
        if (t2 instanceof ReferenceCounted) {
            return (T)((ReferenceCounted)t2).touch(object);
        }
        return t2;
    }

    public static boolean release(Object object) {
        if (object instanceof ReferenceCounted) {
            return ((ReferenceCounted)object).release();
        }
        return false;
    }

    public static void safeRelease(Object object) {
        try {
            ReferenceCountUtil.release(object);
        }
        catch (Throwable throwable) {
            logger.warn("Failed to release a message: {}", object, (Object)throwable);
        }
    }

    private ReferenceCountUtil() {
    }

    static {
        ResourceLeakDetector.addExclusions(ReferenceCountUtil.class, "touch");
    }
}

