/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.apache.http.protocol;

import com.gradle.scan.plugin.internal.dep.org.apache.http.HttpException;
import com.gradle.scan.plugin.internal.dep.org.apache.http.HttpRequest;
import com.gradle.scan.plugin.internal.dep.org.apache.http.HttpRequestInterceptor;
import com.gradle.scan.plugin.internal.dep.org.apache.http.params.HttpParams;
import com.gradle.scan.plugin.internal.dep.org.apache.http.protocol.HttpContext;
import com.gradle.scan.plugin.internal.dep.org.apache.http.util.Args;
import java.io.IOException;

public class RequestUserAgent
implements HttpRequestInterceptor {
    private final String userAgent;

    public RequestUserAgent(String string) {
        this.userAgent = string;
    }

    public RequestUserAgent() {
        this(null);
    }

    @Override
    public void process(HttpRequest httpRequest, HttpContext httpContext) throws HttpException, IOException {
        Args.notNull(httpRequest, "HTTP request");
        if (!httpRequest.containsHeader("User-Agent")) {
            String string = null;
            HttpParams httpParams = httpRequest.getParams();
            if (httpParams != null) {
                string = (String)httpParams.getParameter("http.useragent");
            }
            if (string == null) {
                string = this.userAgent;
            }
            if (string != null) {
                httpRequest.addHeader("User-Agent", string);
            }
        }
    }
}

