/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.io.netty.buffer;

import com.gradle.scan.plugin.internal.dep.io.netty.buffer.AbstractByteBuf;
import com.gradle.scan.plugin.internal.dep.io.netty.buffer.AbstractByteBufAllocator;
import com.gradle.scan.plugin.internal.dep.io.netty.buffer.AdaptiveByteBufAllocator;
import com.gradle.scan.plugin.internal.dep.io.netty.buffer.ByteBuf;
import com.gradle.scan.plugin.internal.dep.io.netty.buffer.ByteBufAllocator;
import com.gradle.scan.plugin.internal.dep.io.netty.buffer.PooledByteBufAllocator;
import com.gradle.scan.plugin.internal.dep.io.netty.buffer.UnpooledByteBufAllocator;
import com.gradle.scan.plugin.internal.dep.io.netty.buffer.UnpooledDirectByteBuf;
import com.gradle.scan.plugin.internal.dep.io.netty.buffer.UnpooledUnsafeDirectByteBuf;
import com.gradle.scan.plugin.internal.dep.io.netty.buffer.WrappedByteBuf;
import com.gradle.scan.plugin.internal.dep.io.netty.buffer.WrappedCompositeByteBuf;
import com.gradle.scan.plugin.internal.dep.io.netty.util.AsciiString;
import com.gradle.scan.plugin.internal.dep.io.netty.util.ByteProcessor;
import com.gradle.scan.plugin.internal.dep.io.netty.util.CharsetUtil;
import com.gradle.scan.plugin.internal.dep.io.netty.util.IllegalReferenceCountException;
import com.gradle.scan.plugin.internal.dep.io.netty.util.Recycler;
import com.gradle.scan.plugin.internal.dep.io.netty.util.concurrent.FastThreadLocal;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.MathUtil;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.ObjectPool;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.ObjectUtil;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.PlatformDependent;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.SWARUtil;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.StringUtil;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.SystemPropertyUtil;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.logging.InternalLogger;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.logging.InternalLoggerFactory;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.util.Arrays;

public final class ByteBufUtil {
    private static final InternalLogger logger;
    private static final FastThreadLocal<byte[]> BYTE_ARRAYS;
    private static final int MAX_CHAR_BUFFER_SIZE;
    private static final int THREAD_LOCAL_BUFFER_SIZE;
    private static final int MAX_BYTES_PER_CHAR_UTF8;
    static final ByteBufAllocator DEFAULT_ALLOCATOR;
    private static final ByteProcessor FIND_NON_ASCII;

    static byte[] threadLocalTempArray(int n2) {
        return n2 <= 1024 ? BYTE_ARRAYS.get() : PlatformDependent.allocateUninitializedArray(n2);
    }

    public static boolean isAccessible(ByteBuf byteBuf) {
        return byteBuf.isAccessible();
    }

    public static ByteBuf ensureAccessible(ByteBuf byteBuf) {
        if (!byteBuf.isAccessible()) {
            throw new IllegalReferenceCountException(byteBuf.refCnt());
        }
        return byteBuf;
    }

    public static String hexDump(ByteBuf byteBuf) {
        return ByteBufUtil.hexDump(byteBuf, byteBuf.readerIndex(), byteBuf.readableBytes());
    }

    public static String hexDump(ByteBuf byteBuf, int n2, int n3) {
        return HexUtil.hexDump(byteBuf, n2, n3);
    }

    public static String hexDump(byte[] byArray, int n2, int n3) {
        return HexUtil.hexDump(byArray, n2, n3);
    }

    public static boolean ensureWritableSuccess(int n2) {
        return n2 == 0 || n2 == 2;
    }

    public static int hashCode(ByteBuf byteBuf) {
        int n2;
        int n3 = byteBuf.readableBytes();
        int n4 = n3 >>> 2;
        int n5 = n3 & 3;
        int n6 = 1;
        int n7 = byteBuf.readerIndex();
        if (byteBuf.order() == ByteOrder.BIG_ENDIAN) {
            for (n2 = n4; n2 > 0; --n2) {
                n6 = 31 * n6 + byteBuf.getInt(n7);
                n7 += 4;
            }
        } else {
            for (n2 = n4; n2 > 0; --n2) {
                n6 = 31 * n6 + ByteBufUtil.swapInt(byteBuf.getInt(n7));
                n7 += 4;
            }
        }
        for (n2 = n5; n2 > 0; --n2) {
            n6 = 31 * n6 + byteBuf.getByte(n7++);
        }
        if (n6 == 0) {
            n6 = 1;
        }
        return n6;
    }

    public static boolean equals(ByteBuf byteBuf, int n2, ByteBuf byteBuf2, int n3, int n4) {
        int n5;
        ObjectUtil.checkNotNull(byteBuf, "a");
        ObjectUtil.checkNotNull(byteBuf2, "b");
        ObjectUtil.checkPositiveOrZero(n2, "aStartIndex");
        ObjectUtil.checkPositiveOrZero(n3, "bStartIndex");
        ObjectUtil.checkPositiveOrZero(n4, "length");
        if (byteBuf.writerIndex() - n4 < n2 || byteBuf2.writerIndex() - n4 < n3) {
            return false;
        }
        int n6 = n4 >>> 3;
        int n7 = n4 & 7;
        if (byteBuf.order() == byteBuf2.order()) {
            for (n5 = n6; n5 > 0; --n5) {
                if (byteBuf.getLong(n2) != byteBuf2.getLong(n3)) {
                    return false;
                }
                n2 += 8;
                n3 += 8;
            }
        } else {
            for (n5 = n6; n5 > 0; --n5) {
                if (byteBuf.getLong(n2) != ByteBufUtil.swapLong(byteBuf2.getLong(n3))) {
                    return false;
                }
                n2 += 8;
                n3 += 8;
            }
        }
        for (n5 = n7; n5 > 0; --n5) {
            if (byteBuf.getByte(n2) != byteBuf2.getByte(n3)) {
                return false;
            }
            ++n2;
            ++n3;
        }
        return true;
    }

    public static boolean equals(ByteBuf byteBuf, ByteBuf byteBuf2) {
        if (byteBuf == byteBuf2) {
            return true;
        }
        int n2 = byteBuf.readableBytes();
        if (n2 != byteBuf2.readableBytes()) {
            return false;
        }
        return ByteBufUtil.equals(byteBuf, byteBuf.readerIndex(), byteBuf2, byteBuf2.readerIndex(), n2);
    }

    public static int compare(ByteBuf byteBuf, ByteBuf byteBuf2) {
        int n2;
        if (byteBuf == byteBuf2) {
            return 0;
        }
        int n3 = byteBuf.readableBytes();
        int n4 = byteBuf2.readableBytes();
        int n5 = Math.min(n3, n4);
        int n6 = n5 >>> 2;
        int n7 = n5 & 3;
        int n8 = byteBuf.readerIndex();
        int n9 = byteBuf2.readerIndex();
        if (n6 > 0) {
            long l2;
            n2 = byteBuf.order() == ByteOrder.BIG_ENDIAN ? 1 : 0;
            int n10 = n6 << 2;
            if (byteBuf.order() == byteBuf2.order()) {
                l2 = n2 != 0 ? ByteBufUtil.compareUintBigEndian(byteBuf, byteBuf2, n8, n9, n10) : ByteBufUtil.compareUintLittleEndian(byteBuf, byteBuf2, n8, n9, n10);
            } else {
                long l3 = l2 = n2 != 0 ? ByteBufUtil.compareUintBigEndianA(byteBuf, byteBuf2, n8, n9, n10) : ByteBufUtil.compareUintBigEndianB(byteBuf, byteBuf2, n8, n9, n10);
            }
            if (l2 != 0L) {
                return (int)Math.min(Integer.MAX_VALUE, Math.max(Integer.MIN_VALUE, l2));
            }
            n8 += n10;
            n9 += n10;
        }
        n2 = n8 + n7;
        while (n8 < n2) {
            int n11 = byteBuf.getUnsignedByte(n8) - byteBuf2.getUnsignedByte(n9);
            if (n11 != 0) {
                return n11;
            }
            ++n8;
            ++n9;
        }
        return n3 - n4;
    }

    private static long compareUintBigEndian(ByteBuf byteBuf, ByteBuf byteBuf2, int n2, int n3, int n4) {
        int n5 = n2 + n4;
        while (n2 < n5) {
            long l2 = byteBuf.getUnsignedInt(n2) - byteBuf2.getUnsignedInt(n3);
            if (l2 != 0L) {
                return l2;
            }
            n2 += 4;
            n3 += 4;
        }
        return 0L;
    }

    private static long compareUintLittleEndian(ByteBuf byteBuf, ByteBuf byteBuf2, int n2, int n3, int n4) {
        int n5 = n2 + n4;
        while (n2 < n5) {
            long l2 = ByteBufUtil.uintFromLE(byteBuf.getUnsignedIntLE(n2)) - ByteBufUtil.uintFromLE(byteBuf2.getUnsignedIntLE(n3));
            if (l2 != 0L) {
                return l2;
            }
            n2 += 4;
            n3 += 4;
        }
        return 0L;
    }

    private static long compareUintBigEndianA(ByteBuf byteBuf, ByteBuf byteBuf2, int n2, int n3, int n4) {
        int n5 = n2 + n4;
        while (n2 < n5) {
            long l2;
            long l3 = byteBuf.getUnsignedInt(n2);
            long l4 = l3 - (l2 = ByteBufUtil.uintFromLE(byteBuf2.getUnsignedIntLE(n3)));
            if (l4 != 0L) {
                return l4;
            }
            n2 += 4;
            n3 += 4;
        }
        return 0L;
    }

    private static long compareUintBigEndianB(ByteBuf byteBuf, ByteBuf byteBuf2, int n2, int n3, int n4) {
        int n5 = n2 + n4;
        while (n2 < n5) {
            long l2;
            long l3 = ByteBufUtil.uintFromLE(byteBuf.getUnsignedIntLE(n2));
            long l4 = l3 - (l2 = byteBuf2.getUnsignedInt(n3));
            if (l4 != 0L) {
                return l4;
            }
            n2 += 4;
            n3 += 4;
        }
        return 0L;
    }

    private static long uintFromLE(long l2) {
        return Long.reverseBytes(l2) >>> 32;
    }

    private static int unrolledFirstIndexOf(AbstractByteBuf abstractByteBuf, int n2, int n3, byte by2) {
        assert (n3 > 0 && n3 < 8);
        if (abstractByteBuf._getByte(n2) == by2) {
            return n2;
        }
        if (n3 == 1) {
            return -1;
        }
        if (abstractByteBuf._getByte(n2 + 1) == by2) {
            return n2 + 1;
        }
        if (n3 == 2) {
            return -1;
        }
        if (abstractByteBuf._getByte(n2 + 2) == by2) {
            return n2 + 2;
        }
        if (n3 == 3) {
            return -1;
        }
        if (abstractByteBuf._getByte(n2 + 3) == by2) {
            return n2 + 3;
        }
        if (n3 == 4) {
            return -1;
        }
        if (abstractByteBuf._getByte(n2 + 4) == by2) {
            return n2 + 4;
        }
        if (n3 == 5) {
            return -1;
        }
        if (abstractByteBuf._getByte(n2 + 5) == by2) {
            return n2 + 5;
        }
        if (n3 == 6) {
            return -1;
        }
        if (abstractByteBuf._getByte(n2 + 6) == by2) {
            return n2 + 6;
        }
        return -1;
    }

    static int firstIndexOf(AbstractByteBuf abstractByteBuf, int n2, int n3, byte by2) {
        int n4;
        if ((n2 = Math.max(n2, 0)) >= n3 || abstractByteBuf.capacity() == 0) {
            return -1;
        }
        int n5 = n3 - n2;
        abstractByteBuf.checkIndex(n2, n5);
        if (!PlatformDependent.isUnaligned()) {
            return ByteBufUtil.linearFirstIndexOf(abstractByteBuf, n2, n3, by2);
        }
        assert (PlatformDependent.isUnaligned());
        int n6 = n2;
        int n7 = n5 & 7;
        if (n7 > 0) {
            n4 = ByteBufUtil.unrolledFirstIndexOf(abstractByteBuf, n2, n7, by2);
            if (n4 != -1) {
                return n4;
            }
            if ((n6 += n7) == n3) {
                return -1;
            }
        }
        n4 = n5 >>> 3;
        ByteOrder byteOrder = ByteOrder.nativeOrder();
        boolean bl2 = byteOrder == abstractByteBuf.order();
        boolean bl3 = byteOrder == ByteOrder.LITTLE_ENDIAN;
        long l2 = SWARUtil.compilePattern(by2);
        for (int i2 = 0; i2 < n4; ++i2) {
            long l3 = bl3 ? abstractByteBuf._getLongLE(n6) : abstractByteBuf._getLong(n6);
            long l4 = SWARUtil.applyPattern(l3, l2);
            if (l4 != 0L) {
                return n6 + SWARUtil.getIndex(l4, bl2);
            }
            n6 += 8;
        }
        return -1;
    }

    private static int linearFirstIndexOf(AbstractByteBuf abstractByteBuf, int n2, int n3, byte by2) {
        for (int i2 = n2; i2 < n3; ++i2) {
            if (abstractByteBuf._getByte(i2) != by2) continue;
            return i2;
        }
        return -1;
    }

    public static short swapShort(short s2) {
        return Short.reverseBytes(s2);
    }

    public static int swapMedium(int n2) {
        int n3 = n2 << 16 & 0xFF0000 | n2 & 0xFF00 | n2 >>> 16 & 0xFF;
        if ((n3 & 0x800000) != 0) {
            n3 |= 0xFF000000;
        }
        return n3;
    }

    public static int swapInt(int n2) {
        return Integer.reverseBytes(n2);
    }

    public static long swapLong(long l2) {
        return Long.reverseBytes(l2);
    }

    public static ByteBuf writeShortBE(ByteBuf byteBuf, int n2) {
        return byteBuf.order() == ByteOrder.BIG_ENDIAN ? byteBuf.writeShort(n2) : byteBuf.writeShort(ByteBufUtil.swapShort((short)n2));
    }

    public static ByteBuf setShortBE(ByteBuf byteBuf, int n2, int n3) {
        return byteBuf.order() == ByteOrder.BIG_ENDIAN ? byteBuf.setShort(n2, n3) : byteBuf.setShort(n2, ByteBufUtil.swapShort((short)n3));
    }

    public static ByteBuf writeMediumBE(ByteBuf byteBuf, int n2) {
        return byteBuf.order() == ByteOrder.BIG_ENDIAN ? byteBuf.writeMedium(n2) : byteBuf.writeMedium(ByteBufUtil.swapMedium(n2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuf readBytes(ByteBufAllocator byteBufAllocator, ByteBuf byteBuf, int n2) {
        boolean bl2 = true;
        ByteBuf byteBuf2 = byteBufAllocator.buffer(n2);
        try {
            byteBuf.readBytes(byteBuf2);
            bl2 = false;
            ByteBuf byteBuf3 = byteBuf2;
            return byteBuf3;
        }
        finally {
            if (bl2) {
                byteBuf2.release();
            }
        }
    }

    static int lastIndexOf(AbstractByteBuf abstractByteBuf, int n2, int n3, byte by2) {
        assert (n2 > n3);
        int n4 = abstractByteBuf.capacity();
        if ((n2 = Math.min(n2, n4)) <= 0) {
            return -1;
        }
        int n5 = n2 - n3;
        abstractByteBuf.checkIndex(n3, n5);
        if (!PlatformDependent.isUnaligned()) {
            return ByteBufUtil.linearLastIndexOf(abstractByteBuf, n2, n3, by2);
        }
        int n6 = n5 >>> 3;
        if (n6 > 0) {
            ByteOrder byteOrder = ByteOrder.nativeOrder();
            boolean bl2 = byteOrder == abstractByteBuf.order();
            boolean bl3 = byteOrder == ByteOrder.LITTLE_ENDIAN;
            long l2 = SWARUtil.compilePattern(by2);
            int n7 = 0;
            int n8 = n2 - 8;
            while (n7 < n6) {
                long l3 = bl3 ? abstractByteBuf._getLongLE(n8) : abstractByteBuf._getLong(n8);
                long l4 = SWARUtil.applyPattern(l3, l2);
                if (l4 != 0L) {
                    return n8 + 8 - 1 - SWARUtil.getIndex(l4, !bl2);
                }
                ++n7;
                n8 -= 8;
            }
        }
        return ByteBufUtil.unrolledLastIndexOf(abstractByteBuf, n2 - (n6 << 3), n5 & 7, by2);
    }

    private static int linearLastIndexOf(AbstractByteBuf abstractByteBuf, int n2, int n3, byte by2) {
        for (int i2 = n2 - 1; i2 >= n3; --i2) {
            if (abstractByteBuf._getByte(i2) != by2) continue;
            return i2;
        }
        return -1;
    }

    private static int unrolledLastIndexOf(AbstractByteBuf abstractByteBuf, int n2, int n3, byte by2) {
        assert (n3 >= 0 && n3 < 8);
        if (n3 == 0) {
            return -1;
        }
        if (abstractByteBuf._getByte(n2 - 1) == by2) {
            return n2 - 1;
        }
        if (n3 == 1) {
            return -1;
        }
        if (abstractByteBuf._getByte(n2 - 2) == by2) {
            return n2 - 2;
        }
        if (n3 == 2) {
            return -1;
        }
        if (abstractByteBuf._getByte(n2 - 3) == by2) {
            return n2 - 3;
        }
        if (n3 == 3) {
            return -1;
        }
        if (abstractByteBuf._getByte(n2 - 4) == by2) {
            return n2 - 4;
        }
        if (n3 == 4) {
            return -1;
        }
        if (abstractByteBuf._getByte(n2 - 5) == by2) {
            return n2 - 5;
        }
        if (n3 == 5) {
            return -1;
        }
        if (abstractByteBuf._getByte(n2 - 6) == by2) {
            return n2 - 6;
        }
        if (n3 == 6) {
            return -1;
        }
        if (abstractByteBuf._getByte(n2 - 7) == by2) {
            return n2 - 7;
        }
        return -1;
    }

    public static int writeUtf8(ByteBuf byteBuf, CharSequence charSequence) {
        int n2 = charSequence.length();
        return ByteBufUtil.reserveAndWriteUtf8Seq(byteBuf, charSequence, 0, n2, ByteBufUtil.utf8MaxBytes(n2));
    }

    private static int reserveAndWriteUtf8Seq(ByteBuf byteBuf, CharSequence charSequence, int n2, int n3, int n4) {
        while (true) {
            if (byteBuf instanceof WrappedCompositeByteBuf) {
                byteBuf = byteBuf.unwrap();
                continue;
            }
            if (byteBuf instanceof AbstractByteBuf) {
                AbstractByteBuf abstractByteBuf = (AbstractByteBuf)byteBuf;
                abstractByteBuf.ensureWritable0(n4);
                int n5 = ByteBufUtil.writeUtf8(abstractByteBuf, abstractByteBuf.writerIndex, n4, charSequence, n2, n3);
                abstractByteBuf.writerIndex += n5;
                return n5;
            }
            if (!(byteBuf instanceof WrappedByteBuf)) break;
            byteBuf = byteBuf.unwrap();
        }
        byte[] byArray = charSequence.subSequence(n2, n3).toString().getBytes(CharsetUtil.UTF_8);
        byteBuf.writeBytes(byArray);
        return byArray.length;
    }

    static int writeUtf8(AbstractByteBuf abstractByteBuf, int n2, int n3, CharSequence charSequence, int n4) {
        return ByteBufUtil.writeUtf8(abstractByteBuf, n2, n3, charSequence, 0, n4);
    }

    static int writeUtf8(AbstractByteBuf abstractByteBuf, int n2, int n3, CharSequence charSequence, int n4, int n5) {
        if (charSequence instanceof AsciiString) {
            ByteBufUtil.writeAsciiString(abstractByteBuf, n2, (AsciiString)charSequence, n4, n5);
            return n5 - n4;
        }
        if (PlatformDependent.hasUnsafe()) {
            if (abstractByteBuf.hasArray()) {
                return ByteBufUtil.unsafeWriteUtf8(abstractByteBuf.array(), PlatformDependent.byteArrayBaseOffset(), abstractByteBuf.arrayOffset() + n2, charSequence, n4, n5);
            }
            if (abstractByteBuf.hasMemoryAddress()) {
                return ByteBufUtil.unsafeWriteUtf8(null, abstractByteBuf.memoryAddress(), n2, charSequence, n4, n5);
            }
        } else {
            if (abstractByteBuf.hasArray()) {
                return ByteBufUtil.safeArrayWriteUtf8(abstractByteBuf.array(), abstractByteBuf.arrayOffset() + n2, charSequence, n4, n5);
            }
            if (abstractByteBuf.isDirect()) {
                assert (abstractByteBuf.nioBufferCount() == 1);
                ByteBuffer byteBuffer = abstractByteBuf.internalNioBuffer(n2, n3);
                int n6 = byteBuffer.position();
                return ByteBufUtil.safeDirectWriteUtf8(byteBuffer, n6, charSequence, n4, n5);
            }
        }
        return ByteBufUtil.safeWriteUtf8(abstractByteBuf, n2, charSequence, n4, n5);
    }

    static void writeAsciiString(AbstractByteBuf abstractByteBuf, int n2, AsciiString asciiString, int n3, int n4) {
        int n5 = asciiString.arrayOffset() + n3;
        int n6 = n4 - n3;
        if (PlatformDependent.hasUnsafe()) {
            if (abstractByteBuf.hasArray()) {
                PlatformDependent.copyMemory(asciiString.array(), n5, abstractByteBuf.array(), abstractByteBuf.arrayOffset() + n2, n6);
                return;
            }
            if (abstractByteBuf.hasMemoryAddress()) {
                PlatformDependent.copyMemory(asciiString.array(), n5, abstractByteBuf.memoryAddress() + (long)n2, (long)n6);
                return;
            }
        }
        if (abstractByteBuf.hasArray()) {
            System.arraycopy(asciiString.array(), n5, abstractByteBuf.array(), abstractByteBuf.arrayOffset() + n2, n6);
            return;
        }
        abstractByteBuf.setBytes(n2, asciiString.array(), n5, n6);
    }

    private static int safeDirectWriteUtf8(ByteBuffer byteBuffer, int n2, CharSequence charSequence, int n3, int n4) {
        assert (!(charSequence instanceof AsciiString));
        int n5 = n2;
        for (int i2 = n3; i2 < n4; ++i2) {
            char c2 = charSequence.charAt(i2);
            if (c2 < '\u0080') {
                byteBuffer.put(n2++, (byte)c2);
                continue;
            }
            if (c2 < '\u0800') {
                byteBuffer.put(n2++, (byte)(0xC0 | c2 >> 6));
                byteBuffer.put(n2++, (byte)(0x80 | c2 & 0x3F));
                continue;
            }
            if (StringUtil.isSurrogate(c2)) {
                if (!Character.isHighSurrogate(c2)) {
                    byteBuffer.put(n2++, (byte)63);
                    continue;
                }
                if (++i2 == n4) {
                    byteBuffer.put(n2++, (byte)63);
                    break;
                }
                char c3 = charSequence.charAt(i2);
                if (!Character.isLowSurrogate(c3)) {
                    byteBuffer.put(n2++, (byte)63);
                    byteBuffer.put(n2++, (byte)(Character.isHighSurrogate(c3) ? 63 : (byte)c3));
                    continue;
                }
                int n6 = Character.toCodePoint(c2, c3);
                byteBuffer.put(n2++, (byte)(0xF0 | n6 >> 18));
                byteBuffer.put(n2++, (byte)(0x80 | n6 >> 12 & 0x3F));
                byteBuffer.put(n2++, (byte)(0x80 | n6 >> 6 & 0x3F));
                byteBuffer.put(n2++, (byte)(0x80 | n6 & 0x3F));
                continue;
            }
            byteBuffer.put(n2++, (byte)(0xE0 | c2 >> 12));
            byteBuffer.put(n2++, (byte)(0x80 | c2 >> 6 & 0x3F));
            byteBuffer.put(n2++, (byte)(0x80 | c2 & 0x3F));
        }
        return n2 - n5;
    }

    private static int safeWriteUtf8(AbstractByteBuf abstractByteBuf, int n2, CharSequence charSequence, int n3, int n4) {
        assert (!(charSequence instanceof AsciiString));
        int n5 = n2;
        for (int i2 = n3; i2 < n4; ++i2) {
            char c2 = charSequence.charAt(i2);
            if (c2 < '\u0080') {
                abstractByteBuf._setByte(n2++, (byte)c2);
                continue;
            }
            if (c2 < '\u0800') {
                abstractByteBuf._setByte(n2++, (byte)(0xC0 | c2 >> 6));
                abstractByteBuf._setByte(n2++, (byte)(0x80 | c2 & 0x3F));
                continue;
            }
            if (StringUtil.isSurrogate(c2)) {
                if (!Character.isHighSurrogate(c2)) {
                    abstractByteBuf._setByte(n2++, 63);
                    continue;
                }
                if (++i2 == n4) {
                    abstractByteBuf._setByte(n2++, 63);
                    break;
                }
                char c3 = charSequence.charAt(i2);
                if (!Character.isLowSurrogate(c3)) {
                    abstractByteBuf._setByte(n2++, 63);
                    abstractByteBuf._setByte(n2++, Character.isHighSurrogate(c3) ? 63 : (int)c3);
                    continue;
                }
                int n6 = Character.toCodePoint(c2, c3);
                abstractByteBuf._setByte(n2++, (byte)(0xF0 | n6 >> 18));
                abstractByteBuf._setByte(n2++, (byte)(0x80 | n6 >> 12 & 0x3F));
                abstractByteBuf._setByte(n2++, (byte)(0x80 | n6 >> 6 & 0x3F));
                abstractByteBuf._setByte(n2++, (byte)(0x80 | n6 & 0x3F));
                continue;
            }
            abstractByteBuf._setByte(n2++, (byte)(0xE0 | c2 >> 12));
            abstractByteBuf._setByte(n2++, (byte)(0x80 | c2 >> 6 & 0x3F));
            abstractByteBuf._setByte(n2++, (byte)(0x80 | c2 & 0x3F));
        }
        return n2 - n5;
    }

    private static int safeArrayWriteUtf8(byte[] byArray, int n2, CharSequence charSequence, int n3, int n4) {
        int n5 = n2;
        for (int i2 = n3; i2 < n4; ++i2) {
            char c2 = charSequence.charAt(i2);
            if (c2 < '\u0080') {
                byArray[n2++] = (byte)c2;
                continue;
            }
            if (c2 < '\u0800') {
                byArray[n2++] = (byte)(0xC0 | c2 >> 6);
                byArray[n2++] = (byte)(0x80 | c2 & 0x3F);
                continue;
            }
            if (StringUtil.isSurrogate(c2)) {
                if (!Character.isHighSurrogate(c2)) {
                    byArray[n2++] = 63;
                    continue;
                }
                if (++i2 == n4) {
                    byArray[n2++] = 63;
                    break;
                }
                char c3 = charSequence.charAt(i2);
                if (!Character.isLowSurrogate(c3)) {
                    byArray[n2++] = 63;
                    byArray[n2++] = (byte)(Character.isHighSurrogate(c3) ? 63 : (int)c3);
                    continue;
                }
                int n6 = Character.toCodePoint(c2, c3);
                byArray[n2++] = (byte)(0xF0 | n6 >> 18);
                byArray[n2++] = (byte)(0x80 | n6 >> 12 & 0x3F);
                byArray[n2++] = (byte)(0x80 | n6 >> 6 & 0x3F);
                byArray[n2++] = (byte)(0x80 | n6 & 0x3F);
                continue;
            }
            byArray[n2++] = (byte)(0xE0 | c2 >> 12);
            byArray[n2++] = (byte)(0x80 | c2 >> 6 & 0x3F);
            byArray[n2++] = (byte)(0x80 | c2 & 0x3F);
        }
        return n2 - n5;
    }

    private static int unsafeWriteUtf8(byte[] byArray, long l2, int n2, CharSequence charSequence, int n3, int n4) {
        long l3;
        assert (!(charSequence instanceof AsciiString));
        long l4 = l3 = l2 + (long)n2;
        for (int i2 = n3; i2 < n4; ++i2) {
            char c2 = charSequence.charAt(i2);
            if (c2 < '\u0080') {
                PlatformDependent.putByte((Object)byArray, l3++, (byte)c2);
                continue;
            }
            if (c2 < '\u0800') {
                PlatformDependent.putByte((Object)byArray, l3++, (byte)(0xC0 | c2 >> 6));
                PlatformDependent.putByte((Object)byArray, l3++, (byte)(0x80 | c2 & 0x3F));
                continue;
            }
            if (StringUtil.isSurrogate(c2)) {
                if (!Character.isHighSurrogate(c2)) {
                    PlatformDependent.putByte((Object)byArray, l3++, (byte)63);
                    continue;
                }
                if (++i2 == n4) {
                    PlatformDependent.putByte((Object)byArray, l3++, (byte)63);
                    break;
                }
                char c3 = charSequence.charAt(i2);
                if (!Character.isLowSurrogate(c3)) {
                    PlatformDependent.putByte((Object)byArray, l3++, (byte)63);
                    PlatformDependent.putByte((Object)byArray, l3++, (byte)(Character.isHighSurrogate(c3) ? 63 : (int)c3));
                    continue;
                }
                int n5 = Character.toCodePoint(c2, c3);
                PlatformDependent.putByte((Object)byArray, l3++, (byte)(0xF0 | n5 >> 18));
                PlatformDependent.putByte((Object)byArray, l3++, (byte)(0x80 | n5 >> 12 & 0x3F));
                PlatformDependent.putByte((Object)byArray, l3++, (byte)(0x80 | n5 >> 6 & 0x3F));
                PlatformDependent.putByte((Object)byArray, l3++, (byte)(0x80 | n5 & 0x3F));
                continue;
            }
            PlatformDependent.putByte((Object)byArray, l3++, (byte)(0xE0 | c2 >> 12));
            PlatformDependent.putByte((Object)byArray, l3++, (byte)(0x80 | c2 >> 6 & 0x3F));
            PlatformDependent.putByte((Object)byArray, l3++, (byte)(0x80 | c2 & 0x3F));
        }
        return (int)(l3 - l4);
    }

    public static int utf8MaxBytes(int n2) {
        return n2 * MAX_BYTES_PER_CHAR_UTF8;
    }

    public static int utf8MaxBytes(CharSequence charSequence) {
        if (charSequence instanceof AsciiString) {
            return charSequence.length();
        }
        return ByteBufUtil.utf8MaxBytes(charSequence.length());
    }

    public static int utf8Bytes(CharSequence charSequence) {
        return ByteBufUtil.utf8ByteCount(charSequence, 0, charSequence.length());
    }

    private static int utf8ByteCount(CharSequence charSequence, int n2, int n3) {
        int n4;
        if (charSequence instanceof AsciiString) {
            return n3 - n2;
        }
        for (n4 = n2; n4 < n3 && charSequence.charAt(n4) < '\u0080'; ++n4) {
        }
        return n4 < n3 ? n4 - n2 + ByteBufUtil.utf8BytesNonAscii(charSequence, n4, n3) : n4 - n2;
    }

    private static int utf8BytesNonAscii(CharSequence charSequence, int n2, int n3) {
        int n4 = 0;
        for (int i2 = n2; i2 < n3; ++i2) {
            char c2 = charSequence.charAt(i2);
            if (c2 < '\u0800') {
                n4 += (127 - c2 >>> 31) + 1;
                continue;
            }
            if (StringUtil.isSurrogate(c2)) {
                if (!Character.isHighSurrogate(c2)) {
                    ++n4;
                    continue;
                }
                if (++i2 == n3) {
                    ++n4;
                    break;
                }
                if (!Character.isLowSurrogate(charSequence.charAt(i2))) {
                    n4 += 2;
                    continue;
                }
                n4 += 4;
                continue;
            }
            n4 += 3;
        }
        return n4;
    }

    public static int writeAscii(ByteBuf byteBuf, CharSequence charSequence) {
        while (true) {
            if (byteBuf instanceof WrappedCompositeByteBuf) {
                byteBuf = byteBuf.unwrap();
                continue;
            }
            if (byteBuf instanceof AbstractByteBuf) {
                int n2 = charSequence.length();
                AbstractByteBuf abstractByteBuf = (AbstractByteBuf)byteBuf;
                abstractByteBuf.ensureWritable0(n2);
                if (charSequence instanceof AsciiString) {
                    ByteBufUtil.writeAsciiString(abstractByteBuf, abstractByteBuf.writerIndex, (AsciiString)charSequence, 0, n2);
                } else {
                    int n3 = ByteBufUtil.writeAscii(abstractByteBuf, abstractByteBuf.writerIndex, charSequence, n2);
                    assert (n3 == n2);
                }
                abstractByteBuf.writerIndex += n2;
                return n2;
            }
            if (!(byteBuf instanceof WrappedByteBuf)) break;
            byteBuf = byteBuf.unwrap();
        }
        byte[] byArray = charSequence.toString().getBytes(CharsetUtil.US_ASCII);
        byteBuf.writeBytes(byArray);
        return byArray.length;
    }

    static int writeAscii(AbstractByteBuf abstractByteBuf, int n2, CharSequence charSequence, int n3) {
        if (charSequence instanceof AsciiString) {
            ByteBufUtil.writeAsciiString(abstractByteBuf, n2, (AsciiString)charSequence, 0, n3);
        } else {
            ByteBufUtil.writeAsciiCharSequence(abstractByteBuf, n2, charSequence, n3);
        }
        return n3;
    }

    private static int writeAsciiCharSequence(AbstractByteBuf abstractByteBuf, int n2, CharSequence charSequence, int n3) {
        for (int i2 = 0; i2 < n3; ++i2) {
            abstractByteBuf._setByte(n2++, AsciiString.c2b(charSequence.charAt(i2)));
        }
        return n3;
    }

    static ByteBuf encodeString0(ByteBufAllocator byteBufAllocator, boolean bl2, CharBuffer charBuffer, Charset charset, int n2) {
        CharsetEncoder charsetEncoder = CharsetUtil.encoder(charset);
        int n3 = (int)((double)charBuffer.remaining() * (double)charsetEncoder.maxBytesPerChar()) + n2;
        boolean bl3 = true;
        ByteBuf byteBuf = bl2 ? byteBufAllocator.heapBuffer(n3) : byteBufAllocator.buffer(n3);
        try {
            ByteBuffer byteBuffer = byteBuf.internalNioBuffer(byteBuf.readerIndex(), n3);
            int n4 = byteBuffer.position();
            CoderResult coderResult = charsetEncoder.encode(charBuffer, byteBuffer, true);
            if (!coderResult.isUnderflow()) {
                coderResult.throwException();
            }
            if (!(coderResult = charsetEncoder.flush(byteBuffer)).isUnderflow()) {
                coderResult.throwException();
            }
            byteBuf.writerIndex(byteBuf.writerIndex() + byteBuffer.position() - n4);
            bl3 = false;
            ByteBuf byteBuf2 = byteBuf;
            return byteBuf2;
        }
        catch (CharacterCodingException characterCodingException) {
            throw new IllegalStateException(characterCodingException);
        }
        finally {
            if (bl3) {
                byteBuf.release();
            }
        }
    }

    static String decodeString(ByteBuf byteBuf, int n2, int n3, Charset charset) {
        int n4;
        byte[] byArray;
        if (n3 == 0) {
            return "";
        }
        if (byteBuf.hasArray()) {
            byArray = byteBuf.array();
            n4 = byteBuf.arrayOffset() + n2;
        } else {
            byArray = ByteBufUtil.threadLocalTempArray(n3);
            n4 = 0;
            byteBuf.getBytes(n2, byArray, 0, n3);
        }
        if (CharsetUtil.US_ASCII.equals(charset)) {
            return new String(byArray, 0, n4, n3);
        }
        return new String(byArray, n4, n3, charset);
    }

    public static ByteBuf threadLocalDirectBuffer() {
        if (THREAD_LOCAL_BUFFER_SIZE <= 0) {
            return null;
        }
        if (PlatformDependent.hasUnsafe()) {
            return ThreadLocalUnsafeDirectByteBuf.newInstance();
        }
        return ThreadLocalDirectByteBuf.newInstance();
    }

    public static byte[] getBytes(ByteBuf byteBuf) {
        return ByteBufUtil.getBytes(byteBuf, byteBuf.readerIndex(), byteBuf.readableBytes());
    }

    public static byte[] getBytes(ByteBuf byteBuf, int n2, int n3) {
        return ByteBufUtil.getBytes(byteBuf, n2, n3, true);
    }

    public static byte[] getBytes(ByteBuf byteBuf, int n2, int n3, boolean bl2) {
        int n4 = byteBuf.capacity();
        if (MathUtil.isOutOfBounds(n2, n3, n4)) {
            throw new IndexOutOfBoundsException("expected: 0 <= start(" + n2 + ") <= start + length(" + n3 + ") <= buf.capacity(" + n4 + ')');
        }
        if (byteBuf.hasArray()) {
            int n5 = byteBuf.arrayOffset() + n2;
            byte[] byArray = byteBuf.array();
            if (bl2 || n5 != 0 || n3 != byArray.length) {
                return Arrays.copyOfRange(byArray, n5, n5 + n3);
            }
            return byArray;
        }
        byte[] byArray = PlatformDependent.allocateUninitializedArray(n3);
        byteBuf.getBytes(n2, byArray);
        return byArray;
    }

    public static void copy(AsciiString asciiString, ByteBuf byteBuf) {
        ByteBufUtil.copy(asciiString, 0, byteBuf, asciiString.length());
    }

    public static void copy(AsciiString asciiString, int n2, ByteBuf byteBuf, int n3, int n4) {
        if (MathUtil.isOutOfBounds(n2, n4, asciiString.length())) {
            throw new IndexOutOfBoundsException("expected: 0 <= srcIdx(" + n2 + ") <= srcIdx + length(" + n4 + ") <= srcLen(" + asciiString.length() + ')');
        }
        ObjectUtil.checkNotNull(byteBuf, "dst").setBytes(n3, asciiString.array(), n2 + asciiString.arrayOffset(), n4);
    }

    public static void copy(AsciiString asciiString, int n2, ByteBuf byteBuf, int n3) {
        if (MathUtil.isOutOfBounds(n2, n3, asciiString.length())) {
            throw new IndexOutOfBoundsException("expected: 0 <= srcIdx(" + n2 + ") <= srcIdx + length(" + n3 + ") <= srcLen(" + asciiString.length() + ')');
        }
        ObjectUtil.checkNotNull(byteBuf, "dst").writeBytes(asciiString.array(), n2 + asciiString.arrayOffset(), n3);
    }

    public static void appendPrettyHexDump(StringBuilder stringBuilder, ByteBuf byteBuf) {
        ByteBufUtil.appendPrettyHexDump(stringBuilder, byteBuf, byteBuf.readerIndex(), byteBuf.readableBytes());
    }

    public static void appendPrettyHexDump(StringBuilder stringBuilder, ByteBuf byteBuf, int n2, int n3) {
        HexUtil.appendPrettyHexDump(stringBuilder, byteBuf, n2, n3);
    }

    private ByteBufUtil() {
    }

    static {
        AbstractByteBufAllocator abstractByteBufAllocator;
        logger = InternalLoggerFactory.getInstance(ByteBufUtil.class);
        BYTE_ARRAYS = new FastThreadLocal<byte[]>(){

            @Override
            protected byte[] initialValue() throws Exception {
                return PlatformDependent.allocateUninitializedArray(1024);
            }
        };
        MAX_BYTES_PER_CHAR_UTF8 = (int)CharsetUtil.encoder(CharsetUtil.UTF_8).maxBytesPerChar();
        String string = SystemPropertyUtil.get("com.gradle.scan.plugin.internal.dep.io.netty.allocator.type", PlatformDependent.isAndroid() ? "unpooled" : "pooled");
        if ("unpooled".equals(string)) {
            abstractByteBufAllocator = UnpooledByteBufAllocator.DEFAULT;
            logger.debug("-Dio.netty.allocator.type: {}", (Object)string);
        } else if ("pooled".equals(string)) {
            abstractByteBufAllocator = PooledByteBufAllocator.DEFAULT;
            logger.debug("-Dio.netty.allocator.type: {}", (Object)string);
        } else if ("adaptive".equals(string)) {
            abstractByteBufAllocator = new AdaptiveByteBufAllocator();
            logger.debug("-Dio.netty.allocator.type: {}", (Object)string);
        } else {
            abstractByteBufAllocator = PooledByteBufAllocator.DEFAULT;
            logger.debug("-Dio.netty.allocator.type: pooled (unknown: {})", (Object)string);
        }
        DEFAULT_ALLOCATOR = abstractByteBufAllocator;
        THREAD_LOCAL_BUFFER_SIZE = SystemPropertyUtil.getInt("com.gradle.scan.plugin.internal.dep.io.netty.threadLocalDirectBufferSize", 0);
        logger.debug("-Dio.netty.threadLocalDirectBufferSize: {}", (Object)THREAD_LOCAL_BUFFER_SIZE);
        MAX_CHAR_BUFFER_SIZE = SystemPropertyUtil.getInt("com.gradle.scan.plugin.internal.dep.io.netty.maxThreadLocalCharBufferSize", 16384);
        logger.debug("-Dio.netty.maxThreadLocalCharBufferSize: {}", (Object)MAX_CHAR_BUFFER_SIZE);
        FIND_NON_ASCII = new ByteProcessor(){

            @Override
            public boolean process(byte by2) {
                return by2 >= 0;
            }
        };
    }

    static final class ThreadLocalDirectByteBuf
    extends UnpooledDirectByteBuf {
        private static final ObjectPool<ThreadLocalDirectByteBuf> RECYCLER = ObjectPool.newPool(new ObjectPool.ObjectCreator<ThreadLocalDirectByteBuf>(){

            @Override
            public ThreadLocalDirectByteBuf newObject(ObjectPool.Handle<ThreadLocalDirectByteBuf> handle) {
                return new ThreadLocalDirectByteBuf(handle);
            }
        });
        private final Recycler.EnhancedHandle<ThreadLocalDirectByteBuf> handle;

        static ThreadLocalDirectByteBuf newInstance() {
            ThreadLocalDirectByteBuf threadLocalDirectByteBuf = RECYCLER.get();
            threadLocalDirectByteBuf.resetRefCnt();
            return threadLocalDirectByteBuf;
        }

        private ThreadLocalDirectByteBuf(ObjectPool.Handle<ThreadLocalDirectByteBuf> handle) {
            super(UnpooledByteBufAllocator.DEFAULT, 256, Integer.MAX_VALUE);
            this.handle = (Recycler.EnhancedHandle)handle;
        }

        @Override
        protected void deallocate() {
            if (this.capacity() > THREAD_LOCAL_BUFFER_SIZE) {
                super.deallocate();
            } else {
                this.clear();
                this.handle.unguardedRecycle(this);
            }
        }
    }

    static final class ThreadLocalUnsafeDirectByteBuf
    extends UnpooledUnsafeDirectByteBuf {
        private static final ObjectPool<ThreadLocalUnsafeDirectByteBuf> RECYCLER = ObjectPool.newPool(new ObjectPool.ObjectCreator<ThreadLocalUnsafeDirectByteBuf>(){

            @Override
            public ThreadLocalUnsafeDirectByteBuf newObject(ObjectPool.Handle<ThreadLocalUnsafeDirectByteBuf> handle) {
                return new ThreadLocalUnsafeDirectByteBuf(handle);
            }
        });
        private final Recycler.EnhancedHandle<ThreadLocalUnsafeDirectByteBuf> handle;

        static ThreadLocalUnsafeDirectByteBuf newInstance() {
            ThreadLocalUnsafeDirectByteBuf threadLocalUnsafeDirectByteBuf = RECYCLER.get();
            threadLocalUnsafeDirectByteBuf.resetRefCnt();
            return threadLocalUnsafeDirectByteBuf;
        }

        private ThreadLocalUnsafeDirectByteBuf(ObjectPool.Handle<ThreadLocalUnsafeDirectByteBuf> handle) {
            super(UnpooledByteBufAllocator.DEFAULT, 256, Integer.MAX_VALUE);
            this.handle = (Recycler.EnhancedHandle)handle;
        }

        @Override
        protected void deallocate() {
            if (this.capacity() > THREAD_LOCAL_BUFFER_SIZE) {
                super.deallocate();
            } else {
                this.clear();
                this.handle.unguardedRecycle(this);
            }
        }
    }

    private static final class HexUtil {
        private static final char[] BYTE2CHAR;
        private static final char[] HEXDUMP_TABLE;
        private static final String[] HEXPADDING;
        private static final String[] HEXDUMP_ROWPREFIXES;
        private static final String[] BYTE2HEX;
        private static final String[] BYTEPADDING;

        private static String hexDump(ByteBuf byteBuf, int n2, int n3) {
            ObjectUtil.checkPositiveOrZero(n3, "length");
            if (n3 == 0) {
                return "";
            }
            int n4 = n2 + n3;
            char[] cArray = new char[n3 << 1];
            int n5 = n2;
            int n6 = 0;
            while (n5 < n4) {
                System.arraycopy(HEXDUMP_TABLE, byteBuf.getUnsignedByte(n5) << 1, cArray, n6, 2);
                ++n5;
                n6 += 2;
            }
            return new String(cArray);
        }

        private static String hexDump(byte[] byArray, int n2, int n3) {
            ObjectUtil.checkPositiveOrZero(n3, "length");
            if (n3 == 0) {
                return "";
            }
            int n4 = n2 + n3;
            char[] cArray = new char[n3 << 1];
            int n5 = n2;
            int n6 = 0;
            while (n5 < n4) {
                System.arraycopy(HEXDUMP_TABLE, (byArray[n5] & 0xFF) << 1, cArray, n6, 2);
                ++n5;
                n6 += 2;
            }
            return new String(cArray);
        }

        private static void appendPrettyHexDump(StringBuilder stringBuilder, ByteBuf byteBuf, int n2, int n3) {
            int n4;
            int n5;
            int n6;
            if (MathUtil.isOutOfBounds(n2, n3, byteBuf.capacity())) {
                throw new IndexOutOfBoundsException("expected: 0 <= offset(" + n2 + ") <= offset + length(" + n3 + ") <= buf.capacity(" + byteBuf.capacity() + ')');
            }
            if (n3 == 0) {
                return;
            }
            stringBuilder.append("         +-------------------------------------------------+" + StringUtil.NEWLINE + "         |  0  1  2  3  4  5  6  7  8  9  a  b  c  d  e  f |" + StringUtil.NEWLINE + "+--------+-------------------------------------------------+----------------+");
            int n7 = n3 >>> 4;
            int n8 = n3 & 0xF;
            for (n6 = 0; n6 < n7; ++n6) {
                int n9;
                n5 = (n6 << 4) + n2;
                HexUtil.appendHexDumpRowPrefix(stringBuilder, n6, n5);
                n4 = n5 + 16;
                for (n9 = n5; n9 < n4; ++n9) {
                    stringBuilder.append(BYTE2HEX[byteBuf.getUnsignedByte(n9)]);
                }
                stringBuilder.append(" |");
                for (n9 = n5; n9 < n4; ++n9) {
                    stringBuilder.append(BYTE2CHAR[byteBuf.getUnsignedByte(n9)]);
                }
                stringBuilder.append('|');
            }
            if (n8 != 0) {
                n6 = (n7 << 4) + n2;
                HexUtil.appendHexDumpRowPrefix(stringBuilder, n7, n6);
                n5 = n6 + n8;
                for (n4 = n6; n4 < n5; ++n4) {
                    stringBuilder.append(BYTE2HEX[byteBuf.getUnsignedByte(n4)]);
                }
                stringBuilder.append(HEXPADDING[n8]);
                stringBuilder.append(" |");
                for (n4 = n6; n4 < n5; ++n4) {
                    stringBuilder.append(BYTE2CHAR[byteBuf.getUnsignedByte(n4)]);
                }
                stringBuilder.append(BYTEPADDING[n8]);
                stringBuilder.append('|');
            }
            stringBuilder.append(StringUtil.NEWLINE + "+--------+-------------------------------------------------+----------------+");
        }

        private static void appendHexDumpRowPrefix(StringBuilder stringBuilder, int n2, int n3) {
            if (n2 < HEXDUMP_ROWPREFIXES.length) {
                stringBuilder.append(HEXDUMP_ROWPREFIXES[n2]);
            } else {
                stringBuilder.append(StringUtil.NEWLINE);
                stringBuilder.append(Long.toHexString((long)n3 & 0xFFFFFFFFL | 0x100000000L));
                stringBuilder.setCharAt(stringBuilder.length() - 9, '|');
                stringBuilder.append('|');
            }
        }

        static {
            int n2;
            StringBuilder stringBuilder;
            int n3;
            BYTE2CHAR = new char[256];
            HEXDUMP_TABLE = new char[1024];
            HEXPADDING = new String[16];
            HEXDUMP_ROWPREFIXES = new String[4096];
            BYTE2HEX = new String[256];
            BYTEPADDING = new String[16];
            char[] cArray = "0123456789abcdef".toCharArray();
            for (n3 = 0; n3 < 256; ++n3) {
                HexUtil.HEXDUMP_TABLE[n3 << 1] = cArray[n3 >>> 4 & 0xF];
                HexUtil.HEXDUMP_TABLE[(n3 << 1) + 1] = cArray[n3 & 0xF];
            }
            for (n3 = 0; n3 < HEXPADDING.length; ++n3) {
                int n4 = HEXPADDING.length - n3;
                stringBuilder = new StringBuilder(n4 * 3);
                for (n2 = 0; n2 < n4; ++n2) {
                    stringBuilder.append("   ");
                }
                HexUtil.HEXPADDING[n3] = stringBuilder.toString();
            }
            for (n3 = 0; n3 < HEXDUMP_ROWPREFIXES.length; ++n3) {
                StringBuilder stringBuilder2 = new StringBuilder(12);
                stringBuilder2.append(StringUtil.NEWLINE);
                stringBuilder2.append(Long.toHexString((long)(n3 << 4) & 0xFFFFFFFFL | 0x100000000L));
                stringBuilder2.setCharAt(stringBuilder2.length() - 9, '|');
                stringBuilder2.append('|');
                HexUtil.HEXDUMP_ROWPREFIXES[n3] = stringBuilder2.toString();
            }
            for (n3 = 0; n3 < BYTE2HEX.length; ++n3) {
                HexUtil.BYTE2HEX[n3] = ' ' + StringUtil.byteToHexStringPadded(n3);
            }
            for (n3 = 0; n3 < BYTEPADDING.length; ++n3) {
                int n5 = BYTEPADDING.length - n3;
                stringBuilder = new StringBuilder(n5);
                for (n2 = 0; n2 < n5; ++n2) {
                    stringBuilder.append(' ');
                }
                HexUtil.BYTEPADDING[n3] = stringBuilder.toString();
            }
            for (n3 = 0; n3 < BYTE2CHAR.length; ++n3) {
                HexUtil.BYTE2CHAR[n3] = n3 <= 31 || n3 >= 127 ? 46 : (char)n3;
            }
        }
    }
}

