/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.datatype.jsr310.ser;

import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.annotation.JsonFormat;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.BeanProperty;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.JavaType;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.JsonMappingException;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.JsonNode;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.JsonSerializer;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.SerializationFeature;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.SerializerProvider;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonStringFormatVisitor;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonValueFormat;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.datatype.jsr310.ser.JSR310SerializerBase;
import java.lang.reflect.Type;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Locale;

abstract class JSR310FormattedSerializerBase<T>
extends JSR310SerializerBase<T>
implements ContextualSerializer {
    protected final Boolean _useTimestamp;
    protected final Boolean _useNanoseconds;
    protected final DateTimeFormatter _formatter;
    protected final JsonFormat.Shape _shape;
    protected volatile transient JavaType _integerListType;

    protected JSR310FormattedSerializerBase(Class<T> clazz) {
        this(clazz, null);
    }

    protected JSR310FormattedSerializerBase(Class<T> clazz, DateTimeFormatter dateTimeFormatter) {
        super((Class<?>)clazz);
        this._useTimestamp = null;
        this._useNanoseconds = null;
        this._shape = null;
        this._formatter = dateTimeFormatter;
    }

    protected JSR310FormattedSerializerBase(JSR310FormattedSerializerBase<?> jSR310FormattedSerializerBase, Boolean bl2, DateTimeFormatter dateTimeFormatter, JsonFormat.Shape shape) {
        this(jSR310FormattedSerializerBase, bl2, null, dateTimeFormatter, shape);
    }

    protected JSR310FormattedSerializerBase(JSR310FormattedSerializerBase<?> jSR310FormattedSerializerBase, Boolean bl2, Boolean bl3, DateTimeFormatter dateTimeFormatter, JsonFormat.Shape shape) {
        super((Class<?>)jSR310FormattedSerializerBase.handledType());
        this._useTimestamp = bl2;
        this._useNanoseconds = bl3;
        this._formatter = dateTimeFormatter;
        this._shape = shape;
    }

    protected abstract JSR310FormattedSerializerBase<?> withFormat(Boolean var1, DateTimeFormatter var2, JsonFormat.Shape var3);

    protected JSR310FormattedSerializerBase<?> withFeatures(Boolean bl2, Boolean bl3) {
        return this;
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider serializerProvider, BeanProperty beanProperty) throws JsonMappingException {
        JsonFormat.Value value = this.findFormatOverrides(serializerProvider, beanProperty, this.handledType());
        if (value != null) {
            Boolean bl2 = null;
            JsonFormat.Shape shape = value.getShape();
            bl2 = shape == JsonFormat.Shape.ARRAY || shape.isNumeric() ? Boolean.TRUE : (shape == JsonFormat.Shape.STRING ? Boolean.FALSE : null);
            DateTimeFormatter dateTimeFormatter = this._formatter;
            if (value.hasPattern()) {
                dateTimeFormatter = this._useDateTimeFormatter(serializerProvider, value);
            }
            JSR310FormattedSerializerBase jSR310FormattedSerializerBase = this;
            if (shape != this._shape || bl2 != this._useTimestamp || dateTimeFormatter != this._formatter) {
                jSR310FormattedSerializerBase = jSR310FormattedSerializerBase.withFormat(bl2, dateTimeFormatter, shape);
            }
            Boolean bl3 = value.getFeature(JsonFormat.Feature.WRITE_DATES_WITH_ZONE_ID);
            Boolean bl4 = value.getFeature(JsonFormat.Feature.WRITE_DATE_TIMESTAMPS_AS_NANOSECONDS);
            if (bl3 != null || bl4 != null) {
                jSR310FormattedSerializerBase = jSR310FormattedSerializerBase.withFeatures(bl3, bl4);
            }
            return jSR310FormattedSerializerBase;
        }
        return this;
    }

    @Override
    @Deprecated
    public JsonNode getSchema(SerializerProvider serializerProvider, Type type) {
        return this.createSchemaNode(serializerProvider.isEnabled(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS) ? "array" : "string", true);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) throws JsonMappingException {
        if (this.useTimestamp(jsonFormatVisitorWrapper.getProvider())) {
            this._acceptTimestampVisitor(jsonFormatVisitorWrapper, javaType);
        } else {
            JsonStringFormatVisitor jsonStringFormatVisitor = jsonFormatVisitorWrapper.expectStringFormat(javaType);
            if (jsonStringFormatVisitor != null) {
                jsonStringFormatVisitor.format(JsonValueFormat.DATE_TIME);
            }
        }
    }

    protected void _acceptTimestampVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) throws JsonMappingException {
        JsonArrayFormatVisitor jsonArrayFormatVisitor = jsonFormatVisitorWrapper.expectArrayFormat(this._integerListType(jsonFormatVisitorWrapper.getProvider()));
        if (jsonArrayFormatVisitor != null) {
            jsonArrayFormatVisitor.itemsFormat(JsonFormatTypes.INTEGER);
        }
    }

    protected JavaType _integerListType(SerializerProvider serializerProvider) {
        JavaType javaType = this._integerListType;
        if (javaType == null) {
            this._integerListType = javaType = serializerProvider.getTypeFactory().constructCollectionType(List.class, Integer.class);
        }
        return javaType;
    }

    protected SerializationFeature getTimestampsFeature() {
        return SerializationFeature.WRITE_DATES_AS_TIMESTAMPS;
    }

    protected boolean useTimestamp(SerializerProvider serializerProvider) {
        if (this._useTimestamp != null) {
            return this._useTimestamp;
        }
        if (this._shape != null) {
            if (this._shape == JsonFormat.Shape.STRING) {
                return false;
            }
            if (this._shape == JsonFormat.Shape.NUMBER_INT) {
                return true;
            }
        }
        return this._formatter == null && this.useTimestampFromGlobalDefaults(serializerProvider);
    }

    protected boolean useTimestampFromGlobalDefaults(SerializerProvider serializerProvider) {
        return serializerProvider != null && serializerProvider.isEnabled(this.getTimestampsFeature());
    }

    protected boolean _useTimestampExplicitOnly(SerializerProvider serializerProvider) {
        if (this._useTimestamp != null) {
            return this._useTimestamp;
        }
        return false;
    }

    protected boolean useNanoseconds(SerializerProvider serializerProvider) {
        if (this._useNanoseconds != null) {
            return this._useNanoseconds;
        }
        if (this._shape != null) {
            if (this._shape == JsonFormat.Shape.NUMBER_INT) {
                return false;
            }
            if (this._shape == JsonFormat.Shape.NUMBER_FLOAT) {
                return true;
            }
        }
        return serializerProvider != null && serializerProvider.isEnabled(SerializationFeature.WRITE_DATE_TIMESTAMPS_AS_NANOSECONDS);
    }

    protected DateTimeFormatter _useDateTimeFormatter(SerializerProvider serializerProvider, JsonFormat.Value value) {
        String string = value.getPattern();
        Locale locale = value.hasLocale() ? value.getLocale() : serializerProvider.getLocale();
        DateTimeFormatter dateTimeFormatter = locale == null ? DateTimeFormatter.ofPattern(string) : DateTimeFormatter.ofPattern(string, locale);
        if (value.hasTimeZone()) {
            dateTimeFormatter = dateTimeFormatter.withZone(value.getTimeZone().toZoneId());
        }
        return dateTimeFormatter;
    }
}

