/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http;

import com.gradle.scan.plugin.internal.dep.io.netty.channel.Channel;
import com.gradle.scan.plugin.internal.dep.io.netty.channel.embedded.EmbeddedChannel;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.compression.Brotli;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.compression.BrotliDecoder;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.compression.SnappyFrameDecoder;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.compression.ZlibCodecFactory;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.compression.ZlibWrapper;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.compression.Zstd;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.compression.ZstdDecoder;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.HttpContentDecoder;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.HttpHeaderValues;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.ObjectUtil;

public class HttpContentDecompressor
extends HttpContentDecoder {
    private final boolean strict;
    private final int maxAllocation;

    @Deprecated
    public HttpContentDecompressor() {
        this(false, 0);
    }

    public HttpContentDecompressor(boolean bl2, int n2) {
        this.strict = bl2;
        this.maxAllocation = ObjectUtil.checkPositiveOrZero(n2, "maxAllocation");
    }

    @Override
    protected EmbeddedChannel newContentDecoder(String string) throws Exception {
        Channel channel = this.ctx.channel();
        if (HttpHeaderValues.GZIP.contentEqualsIgnoreCase(string) || HttpHeaderValues.X_GZIP.contentEqualsIgnoreCase(string)) {
            return EmbeddedChannel.builder().channelId(channel.id()).hasDisconnect(channel.metadata().hasDisconnect()).config(channel.config()).handlers(ZlibCodecFactory.newZlibDecoder(ZlibWrapper.GZIP, this.maxAllocation)).build();
        }
        if (HttpHeaderValues.DEFLATE.contentEqualsIgnoreCase(string) || HttpHeaderValues.X_DEFLATE.contentEqualsIgnoreCase(string)) {
            ZlibWrapper zlibWrapper = this.strict ? ZlibWrapper.ZLIB : ZlibWrapper.ZLIB_OR_NONE;
            return EmbeddedChannel.builder().channelId(channel.id()).hasDisconnect(channel.metadata().hasDisconnect()).config(channel.config()).handlers(ZlibCodecFactory.newZlibDecoder(zlibWrapper, this.maxAllocation)).build();
        }
        if (Brotli.isAvailable() && HttpHeaderValues.BR.contentEqualsIgnoreCase(string)) {
            return EmbeddedChannel.builder().channelId(channel.id()).hasDisconnect(channel.metadata().hasDisconnect()).config(channel.config()).handlers(new BrotliDecoder()).build();
        }
        if (HttpHeaderValues.SNAPPY.contentEqualsIgnoreCase(string)) {
            return EmbeddedChannel.builder().channelId(channel.id()).hasDisconnect(channel.metadata().hasDisconnect()).config(channel.config()).handlers(new SnappyFrameDecoder()).build();
        }
        if (Zstd.isAvailable() && HttpHeaderValues.ZSTD.contentEqualsIgnoreCase(string)) {
            return EmbeddedChannel.builder().channelId(channel.id()).hasDisconnect(channel.metadata().hasDisconnect()).config(channel.config()).handlers(new ZstdDecoder()).build();
        }
        return null;
    }
}

