/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.enterprise.gradleplugin.test;

import com.gradle.enterprise.gradleplugin.test.JUnitXmlDialect;
import com.gradle.junit.xml.streaming.parser.j;
import com.gradle.nullability.Nullable;
import com.gradle.obfuscation.KeepMethods;
import com.gradle.obfuscation.KeepName;
import com.gradle.scan.plugin.internal.b.x.c;
import java.io.File;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.project.DefaultProjectRegistry;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectRegistry;
import org.gradle.api.internal.project.taskfactory.TaskIdentity;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.internal.operations.BuildOperationListener;
import org.gradle.internal.operations.BuildOperationListenerManager;
import org.gradle.internal.operations.CurrentBuildOperationRef;
import org.gradle.internal.operations.OperationProgressEvent;
import org.gradle.internal.scan.time.BuildScanClock;
import org.gradle.util.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@KeepName
@KeepMethods
public abstract class ImportJUnitXmlReports
extends DefaultTask {
    protected static final Logger a = LoggerFactory.getLogger(ImportJUnitXmlReports.class);
    private static final String b = "ImportJUnitXmlReports";
    private final BuildOperationListener c;
    private final BuildScanClock d;
    @Nullable(value="when loaded from configuration cache")
    private final transient Property<Task> e;

    @Inject
    public ImportJUnitXmlReports(BuildOperationListenerManager listenerManager, BuildScanClock clock, ObjectFactory objectFactory, Gradle gradle) {
        this.c = listenerManager.getBroadcaster();
        this.d = clock;
        this.e = objectFactory.property(Task.class);
        this.getReferenceTaskBuildPath().convention(this.e.map(it -> ImportJUnitXmlReports.getBuildPath((TaskInternal)it)));
        this.getReferenceTaskTaskPath().convention(this.e.map(it -> ImportJUnitXmlReports.getTaskPath((TaskInternal)it)));
        if (com.gradle.scan.plugin.internal.a.a(gradle).a(com.gradle.enterprise.version.a.c.d)) {
            gradle.getTaskGraph().whenReady(__ -> {
                if (!this.isPartOfSameBuildAsReferenceTask()) {
                    this.notCompatibleWithConfigurationCache("Referencing tasks across included builds is not supported");
                }
            });
        }
    }

    @Input
    public abstract Property<JUnitXmlDialect> getDialect();

    @Internal
    public abstract ConfigurableFileCollection getReports();

    @Internal
    @Nullable
    public Property<Task> getReferenceTask() {
        return this.e;
    }

    @Internal
    public abstract Property<String> getReferenceTaskBuildPath();

    @Internal
    public abstract Property<String> getReferenceTaskTaskPath();

    @TaskAction
    void importReports() {
        Task referenceTask = this.findReferenceTask();
        if (referenceTask != null && !referenceTask.getDidWork()) {
            this.setDidWork(false);
            return;
        }
        ImportJUnitXmlReports taskInternal = referenceTask == null ? this : (TaskInternal)referenceTask;
        TaskIdentity referenceTaskIdentity = taskInternal.getTaskIdentity();
        Set xmlFiles = this.getReports().filter(File::exists).filter(file -> file.getName().endsWith(".xml")).getFiles();
        if (xmlFiles.isEmpty()) {
            a.warn("No JUnit XML reports found in any of the declared inputs!");
        } else {
            j dialect = ((JUnitXmlDialect)((Object)this.getDialect().get())).toParserDialect();
            xmlFiles.stream().map(xml -> new a(xml.getAbsoluteFile(), referenceTaskIdentity, dialect)).forEach(this::emitEvent);
        }
    }

    @Nullable
    private Task findReferenceTask() {
        if (this.e == null) {
            String buildPath = (String)this.getReferenceTaskBuildPath().getOrNull();
            String taskPath = (String)this.getReferenceTaskTaskPath().getOrNull();
            if (buildPath == null || taskPath == null) {
                return null;
            }
            if (this.isPartOfSameBuildAsReferenceTask()) {
                Path referencePath = Path.path((String)taskPath);
                String referenceProjectPath = Objects.requireNonNull(referencePath.getParent()).getPath();
                ProjectInternal referenceProject = Objects.requireNonNull((ProjectInternal)this.getProjectRegistry().getProject(referenceProjectPath));
                String referenceTaskName = Objects.requireNonNull(referencePath.getName());
                TaskContainer tasks = (TaskContainer)referenceProject.getServices().get(TaskContainer.class);
                return tasks.getByName(referenceTaskName);
            }
            throw new InvalidUserDataException("Referencing tasks across included builds is not supported when using the configuration cache: " + taskPath + " in " + buildPath);
        }
        return (Task)this.e.getOrNull();
    }

    private boolean isPartOfSameBuildAsReferenceTask() {
        String referenceBuildPath = (String)this.getReferenceTaskBuildPath().getOrNull();
        return referenceBuildPath == null || ImportJUnitXmlReports.getBuildPath((TaskInternal)this).equals(referenceBuildPath);
    }

    private ProjectRegistry<ProjectInternal> getProjectRegistry() {
        return (ProjectRegistry)this.getServices().get(DefaultProjectRegistry.class);
    }

    private void emitEvent(c event) {
        this.c.progress(com.gradle.enterprise.a.a.a(CurrentBuildOperationRef.instance().getId(), () -> "operationIdentifier is null"), new OperationProgressEvent(this.d.getCurrentTime(), (Object)event));
    }

    public static TaskProvider<ImportJUnitXmlReports> register(TaskContainer tasks, TaskProvider<?> testTask, JUnitXmlDialect dialect) {
        TaskProvider<ImportJUnitXmlReports> finalizerTask = ImportJUnitXmlReports.registerFinalizerTask(tasks, testTask, dialect);
        testTask.configure(task -> task.finalizedBy(new Object[]{finalizerTask}));
        return finalizerTask;
    }

    private static TaskProvider<ImportJUnitXmlReports> registerFinalizerTask(TaskContainer tasks, TaskProvider<?> testTask, JUnitXmlDialect dialect) {
        return tasks.register(testTask.getName() + b, ImportJUnitXmlReports.class, importTask -> {
            importTask.getDialect().set((Object)dialect);
            Objects.requireNonNull(importTask.getReferenceTask()).set((Provider)testTask);
            importTask.getReports().from(new Object[]{testTask.map(task -> task.getOutputs().getFiles().getAsFileTree())});
        });
    }

    private static String getTaskPath(TaskInternal task) {
        return task.getTaskIdentity().projectPath.getPath();
    }

    private static String getBuildPath(TaskInternal task) {
        return task.getTaskIdentity().buildPath.getPath();
    }

    private static class a
    implements c {
        private final File a;
        private final TaskIdentity<?> b;
        private final j c;

        private a(File xmlFile, TaskIdentity<?> referenceTask, j dialect) {
            this.a = xmlFile;
            this.b = referenceTask;
            this.c = dialect;
        }

        @Override
        public File a() {
            return this.a;
        }

        @Override
        public TaskIdentity<?> b() {
            return this.b;
        }

        @Override
        public j c() {
            return this.c;
        }
    }
}

