/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.google.common.base;

import com.gradle.scan.plugin.internal.dep.com.google.common.base.Java8Usage;
import com.gradle.scan.plugin.internal.dep.com.google.common.base.Strings;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Preconditions {
    private Preconditions() {
    }

    public static void checkArgument(boolean bl2) {
        if (!bl2) {
            throw new IllegalArgumentException();
        }
    }

    public static void checkArgument(boolean bl2, Object object) {
        if (!bl2) {
            throw new IllegalArgumentException(String.valueOf(object));
        }
    }

    public static void checkArgument(boolean bl2, String string, int n2) {
        if (!bl2) {
            throw new IllegalArgumentException(Strings.lenientFormat(string, n2));
        }
    }

    public static void checkState(boolean bl2) {
        if (!bl2) {
            throw new IllegalStateException();
        }
    }

    public static <T> T checkNotNull(T t2) {
        if (t2 == null) {
            throw new NullPointerException();
        }
        return t2;
    }

    public static <T> T checkNotNull(T t2, Object object) {
        if (t2 == null) {
            throw new NullPointerException(String.valueOf(object));
        }
        return t2;
    }

    public static int checkElementIndex(int n2, int n3) {
        return Preconditions.checkElementIndex(n2, n3, "index");
    }

    public static int checkElementIndex(int n2, int n3, String string) {
        if (n2 < 0 || n2 >= n3) {
            throw new IndexOutOfBoundsException(Preconditions.badElementIndex(n2, n3, string));
        }
        return n2;
    }

    private static String badElementIndex(int n2, int n3, String string) {
        if (n2 < 0) {
            return Strings.lenientFormat("%s (%s) must not be negative", string, n2);
        }
        if (n3 < 0) {
            throw new IllegalArgumentException(new StringBuilder(26).append("negative size: ").append(n3).toString());
        }
        return Strings.lenientFormat("%s (%s) must be less than size (%s)", string, n2, n3);
    }

    public static int checkPositionIndex(int n2, int n3) {
        return Preconditions.checkPositionIndex(n2, n3, "index");
    }

    public static int checkPositionIndex(int n2, int n3, String string) {
        if (n2 < 0 || n2 > n3) {
            throw new IndexOutOfBoundsException(Preconditions.badPositionIndex(n2, n3, string));
        }
        return n2;
    }

    private static String badPositionIndex(int n2, int n3, String string) {
        if (n2 < 0) {
            return Strings.lenientFormat("%s (%s) must not be negative", string, n2);
        }
        if (n3 < 0) {
            throw new IllegalArgumentException(new StringBuilder(26).append("negative size: ").append(n3).toString());
        }
        return Strings.lenientFormat("%s (%s) must not be greater than size (%s)", string, n2, n3);
    }

    public static void checkPositionIndexes(int n2, int n3, int n4) {
        if (n2 < 0 || n3 < n2 || n3 > n4) {
            throw new IndexOutOfBoundsException(Preconditions.badPositionIndexes(n2, n3, n4));
        }
    }

    private static String badPositionIndexes(int n2, int n3, int n4) {
        if (n2 < 0 || n2 > n4) {
            return Preconditions.badPositionIndex(n2, n4, "start index");
        }
        if (n3 < 0 || n3 > n4) {
            return Preconditions.badPositionIndex(n3, n4, "end index");
        }
        return Strings.lenientFormat("end index (%s) must not be less than start index (%s)", n3, n2);
    }

    static {
        try {
            Java8Usage.performCheck();
        }
        catch (Throwable throwable) {
            Exception exception = new Exception("Guava will drop support for Java 7 in 2021. Please let us know if this will cause you problems: https://github.com/google/guava/issues/5269", throwable);
            Logger.getLogger(Preconditions.class.getName()).log(Level.WARNING, "Java 7 compatibility warning: See https://github.com/google/guava/issues/5269", exception);
        }
    }
}

