/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.google.common.collect;

import com.gradle.scan.plugin.internal.dep.com.google.common.base.Objects;
import com.gradle.scan.plugin.internal.dep.com.google.common.base.Preconditions;
import com.gradle.scan.plugin.internal.dep.com.google.common.collect.AbstractIndexedListIterator;
import com.gradle.scan.plugin.internal.dep.com.google.common.collect.UnmodifiableIterator;
import com.gradle.scan.plugin.internal.dep.com.google.common.collect.UnmodifiableListIterator;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class Iterators {
    static <T> UnmodifiableListIterator<T> emptyListIterator() {
        return ArrayItr.EMPTY;
    }

    public static boolean contains(Iterator<?> iterator, Object object) {
        if (object == null) {
            while (iterator.hasNext()) {
                if (iterator.next() != null) continue;
                return true;
            }
        } else {
            while (iterator.hasNext()) {
                if (!object.equals(iterator.next())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean elementsEqual(Iterator<?> iterator, Iterator<?> iterator2) {
        while (iterator.hasNext()) {
            Object obj;
            if (!iterator2.hasNext()) {
                return false;
            }
            Object obj2 = iterator.next();
            if (Objects.equal(obj2, obj = iterator2.next())) continue;
            return false;
        }
        return !iterator2.hasNext();
    }

    static <T> UnmodifiableListIterator<T> forArray(T[] TArray, int n2, int n3, int n4) {
        Preconditions.checkArgument(n3 >= 0);
        int n5 = n2 + n3;
        Preconditions.checkPositionIndexes(n2, n5, TArray.length);
        Preconditions.checkPositionIndex(n4, n3);
        if (n3 == 0) {
            return Iterators.emptyListIterator();
        }
        return new ArrayItr<T>(TArray, n2, n3, n4);
    }

    public static <T> UnmodifiableIterator<T> singletonIterator(final T t2) {
        return new UnmodifiableIterator<T>(){
            boolean done;

            @Override
            public boolean hasNext() {
                return !this.done;
            }

            @Override
            public T next() {
                if (this.done) {
                    throw new NoSuchElementException();
                }
                this.done = true;
                return t2;
            }
        };
    }

    private static final class ArrayItr<T>
    extends AbstractIndexedListIterator<T> {
        static final UnmodifiableListIterator<Object> EMPTY = new ArrayItr<Object>(new Object[0], 0, 0, 0);
        private final T[] array;
        private final int offset;

        ArrayItr(T[] TArray, int n2, int n3, int n4) {
            super(n3, n4);
            this.array = TArray;
            this.offset = n2;
        }

        @Override
        protected T get(int n2) {
            return this.array[this.offset + n2];
        }
    }
}

