/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.google.common.collect;

import com.gradle.scan.plugin.internal.dep.com.google.common.base.Preconditions;
import com.gradle.scan.plugin.internal.dep.com.google.common.collect.AbstractIterator;
import com.gradle.scan.plugin.internal.dep.com.google.common.collect.UnmodifiableIterator;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;

public final class Sets {
    public static <E> SetView<E> difference(final Set<E> set, final Set<?> set2) {
        Preconditions.checkNotNull(set, "set1");
        Preconditions.checkNotNull(set2, "set2");
        return new SetView<E>(){

            @Override
            public UnmodifiableIterator<E> iterator() {
                return new AbstractIterator<E>(){
                    final Iterator<E> itr;
                    {
                        this.itr = set.iterator();
                    }

                    @Override
                    protected E computeNext() {
                        while (this.itr.hasNext()) {
                            Object e2 = this.itr.next();
                            if (set2.contains(e2)) continue;
                            return e2;
                        }
                        return this.endOfData();
                    }
                };
            }

            @Override
            public Stream<E> stream() {
                return set.stream().filter(object -> !set2.contains(object));
            }

            @Override
            public Stream<E> parallelStream() {
                return set.parallelStream().filter(object -> !set2.contains(object));
            }

            @Override
            public int size() {
                int n2 = 0;
                for (Object e2 : set) {
                    if (set2.contains(e2)) continue;
                    ++n2;
                }
                return n2;
            }

            @Override
            public boolean isEmpty() {
                return set2.containsAll(set);
            }

            @Override
            public boolean contains(Object object) {
                return set.contains(object) && !set2.contains(object);
            }
        };
    }

    static int hashCodeImpl(Set<?> set) {
        int n2 = 0;
        for (Object obj : set) {
            n2 += obj != null ? obj.hashCode() : 0;
            n2 = ~(~n2);
        }
        return n2;
    }

    static boolean equalsImpl(Set<?> set, Object object) {
        if (set == object) {
            return true;
        }
        if (object instanceof Set) {
            Set set2 = (Set)object;
            try {
                return set.size() == set2.size() && set.containsAll(set2);
            }
            catch (ClassCastException | NullPointerException runtimeException) {
                return false;
            }
        }
        return false;
    }

    public static abstract class SetView<E>
    extends AbstractSet<E> {
        private SetView() {
        }

        @Override
        @Deprecated
        public final boolean add(E e2) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public final boolean remove(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public final boolean addAll(Collection<? extends E> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public final boolean removeAll(Collection<?> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public final boolean removeIf(Predicate<? super E> predicate) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public final boolean retainAll(Collection<?> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public final void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public abstract UnmodifiableIterator<E> iterator();
    }
}

