/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.dev.failsafe;

import com.gradle.scan.plugin.internal.dep.dev.failsafe.AsyncExecutionImpl;
import com.gradle.scan.plugin.internal.dep.dev.failsafe.ExecutionContext;
import com.gradle.scan.plugin.internal.dep.dev.failsafe.Functions;
import com.gradle.scan.plugin.internal.dep.dev.failsafe.Policy;
import com.gradle.scan.plugin.internal.dep.dev.failsafe.SyncExecutionImpl;
import com.gradle.scan.plugin.internal.dep.dev.failsafe.function.CheckedSupplier;
import com.gradle.scan.plugin.internal.dep.dev.failsafe.function.ContextualSupplier;
import com.gradle.scan.plugin.internal.dep.dev.failsafe.internal.EventHandler;
import com.gradle.scan.plugin.internal.dep.dev.failsafe.spi.AsyncExecutionInternal;
import com.gradle.scan.plugin.internal.dep.dev.failsafe.spi.ExecutionResult;
import com.gradle.scan.plugin.internal.dep.dev.failsafe.spi.FailsafeFuture;
import com.gradle.scan.plugin.internal.dep.dev.failsafe.spi.Scheduler;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Function;

public class FailsafeExecutor<R> {
    private Scheduler scheduler = Scheduler.DEFAULT;
    private Executor executor;
    final List<? extends Policy<R>> policies;
    private volatile EventHandler<R> completeHandler;
    private volatile EventHandler<R> failureHandler;
    private volatile EventHandler<R> successHandler;
    final BiConsumer<ExecutionResult<R>, ExecutionContext<R>> completionHandler = (executionResult, executionContext) -> {
        if (this.successHandler != null && executionResult.getSuccessAll()) {
            this.successHandler.handle((ExecutionResult<R>)executionResult, (ExecutionContext<R>)executionContext);
        } else if (this.failureHandler != null && !executionResult.getSuccessAll()) {
            this.failureHandler.handle((ExecutionResult<R>)executionResult, (ExecutionContext<R>)executionContext);
        }
        if (this.completeHandler != null) {
            this.completeHandler.handle((ExecutionResult<R>)executionResult, (ExecutionContext<R>)executionContext);
        }
    };

    FailsafeExecutor(List<? extends Policy<R>> list) {
        this.policies = list;
    }

    public <T extends R> T get(CheckedSupplier<T> checkedSupplier) {
        return (T)this.call(Functions.toCtxSupplier(checkedSupplier));
    }

    public <T extends R> CompletableFuture<T> getStageAsync(CheckedSupplier<? extends CompletionStage<T>> checkedSupplier) {
        return this.callAsync(failsafeFuture -> Functions.getPromiseOfStage(Functions.toCtxSupplier(checkedSupplier), failsafeFuture, this.executor), false);
    }

    private <T> T call(ContextualSupplier<T, T> contextualSupplier) {
        SyncExecutionImpl syncExecutionImpl = new SyncExecutionImpl(this, this.scheduler, null, Functions.get(contextualSupplier, this.executor));
        return (T)syncExecutionImpl.executeSync();
    }

    private <T> CompletableFuture<T> callAsync(Function<FailsafeFuture<T>, Function<AsyncExecutionInternal<T>, CompletableFuture<ExecutionResult<T>>>> function, boolean bl2) {
        FailsafeFuture failsafeFuture = new FailsafeFuture(this.completionHandler);
        AsyncExecutionImpl asyncExecutionImpl = new AsyncExecutionImpl(this.policies, this.scheduler, failsafeFuture, bl2, function.apply(failsafeFuture));
        failsafeFuture.setExecution(asyncExecutionImpl);
        asyncExecutionImpl.executeAsync();
        return failsafeFuture;
    }
}

