/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.thread;

import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.AtomicBiInteger;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.BlockingArrayQueue;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.StringUtil;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.component.ContainerLifeCycle;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.component.Dumpable;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.component.DumpableCollection;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.log.Log;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.log.Logger;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.thread.PrivilegedThreadFactory;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.thread.ReservedThreadExecutor;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.thread.ThreadPool;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.thread.ThreadPoolBudget;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.thread.TryExecutor;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class QueuedThreadPool
extends ContainerLifeCycle
implements ThreadFactory,
ThreadPool.SizedThreadPool,
TryExecutor {
    private static final Logger LOG = Log.getLogger(QueuedThreadPool.class);
    private static final Runnable NOOP = () -> {};
    private final AtomicBiInteger _counts = new AtomicBiInteger(Integer.MIN_VALUE, 0);
    private final AtomicLong _lastShrink = new AtomicLong();
    private final Set<Thread> _threads = ConcurrentHashMap.newKeySet();
    private final Object _joinLock = new Object();
    private final BlockingQueue<Runnable> _jobs;
    private final ThreadGroup _threadGroup;
    private final ThreadFactory _threadFactory;
    private String _name = "qtp" + this.hashCode();
    private int _idleTimeout;
    private int _maxThreads;
    private int _minThreads;
    private int _reservedThreads = -1;
    private TryExecutor _tryExecutor = TryExecutor.NO_TRY;
    private int _priority = 5;
    private boolean _daemon = false;
    private boolean _detailedDump = false;
    private int _lowThreadsThreshold = 1;
    private ThreadPoolBudget _budget;
    private final Runnable _runnable = new Runner();

    public QueuedThreadPool() {
        this(200);
    }

    public QueuedThreadPool(int n2) {
        this(n2, Math.min(8, n2));
    }

    public QueuedThreadPool(int n2, int n3) {
        this(n2, n3, 60000);
    }

    public QueuedThreadPool(int n2, int n3, int n4) {
        this(n2, n3, n4, null);
    }

    public QueuedThreadPool(int n2, int n3, int n4, BlockingQueue<Runnable> blockingQueue) {
        this(n2, n3, n4, blockingQueue, null);
    }

    public QueuedThreadPool(int n2, int n3, int n4, BlockingQueue<Runnable> blockingQueue, ThreadGroup threadGroup) {
        this(n2, n3, n4, -1, blockingQueue, threadGroup);
    }

    public QueuedThreadPool(int n2, int n3, int n4, int n5, BlockingQueue<Runnable> blockingQueue, ThreadGroup threadGroup) {
        this(n2, n3, n4, n5, blockingQueue, threadGroup, null);
    }

    public QueuedThreadPool(int n2, int n3, int n4, int n5, BlockingQueue<Runnable> blockingQueue, ThreadGroup threadGroup, ThreadFactory threadFactory) {
        if (n2 < n3) {
            throw new IllegalArgumentException("max threads (" + n2 + ") less than min threads (" + n3 + ")");
        }
        this.setMinThreads(n3);
        this.setMaxThreads(n2);
        this.setIdleTimeout(n4);
        this.setStopTimeout(5000L);
        this.setReservedThreads(n5);
        if (blockingQueue == null) {
            int n6 = Math.max(this._minThreads, 8) * 1024;
            blockingQueue = new BlockingArrayQueue<Runnable>(n6, n6);
        }
        this._jobs = blockingQueue;
        this._threadGroup = threadGroup;
        this.setThreadPoolBudget(new ThreadPoolBudget(this));
        this._threadFactory = threadFactory == null ? this : threadFactory;
    }

    @Override
    public ThreadPoolBudget getThreadPoolBudget() {
        return this._budget;
    }

    public void setThreadPoolBudget(ThreadPoolBudget threadPoolBudget) {
        if (threadPoolBudget != null && threadPoolBudget.getSizedThreadPool() != this) {
            throw new IllegalArgumentException();
        }
        this.updateBean(this._budget, threadPoolBudget);
        this._budget = threadPoolBudget;
    }

    @Override
    protected void doStart() throws Exception {
        if (this._reservedThreads == 0) {
            this._tryExecutor = NO_TRY;
        } else {
            ReservedThreadExecutor reservedThreadExecutor = new ReservedThreadExecutor(this, this._reservedThreads);
            reservedThreadExecutor.setIdleTimeout(this._idleTimeout, TimeUnit.MILLISECONDS);
            this._tryExecutor = reservedThreadExecutor;
        }
        this.addBean(this._tryExecutor);
        this._lastShrink.set(System.nanoTime());
        super.doStart();
        this._counts.set(0, 0);
        this.ensureThreads();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doStop() throws Exception {
        Object object;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Stopping {}", this);
        }
        super.doStop();
        this.removeBean(this._tryExecutor);
        this._tryExecutor = TryExecutor.NO_TRY;
        int n2 = this._counts.getAndSetHi(Integer.MIN_VALUE);
        long l2 = this.getStopTimeout();
        BlockingQueue<Runnable> blockingQueue = this.getQueue();
        for (int i2 = 0; i2 < n2; ++i2) {
            blockingQueue.offer(NOOP);
        }
        if (l2 > 0L) {
            this.joinThreads(System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(l2) / 2L);
        }
        Thread.yield();
        for (Thread thread : this._threads) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Interrupting {}", thread);
            }
            thread.interrupt();
        }
        if (l2 > 0L) {
            this.joinThreads(System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(l2) / 2L);
            Thread.yield();
            if (LOG.isDebugEnabled()) {
                for (Thread thread : this._threads) {
                    StringBuilder stringBuilder = new StringBuilder();
                    for (StackTraceElement stackTraceElement : thread.getStackTrace()) {
                        stringBuilder.append(System.lineSeparator()).append("\tat ").append(stackTraceElement);
                    }
                    LOG.warn("Couldn't stop {}{}", thread, stringBuilder.toString());
                }
            } else {
                for (Thread thread : this._threads) {
                    LOG.warn("{} Couldn't stop {}", this, thread);
                }
            }
        }
        while (!this._jobs.isEmpty()) {
            object = (Runnable)this._jobs.poll();
            if (object instanceof Closeable) {
                try {
                    ((Closeable)object).close();
                }
                catch (Throwable throwable) {
                    LOG.warn(throwable);
                }
                continue;
            }
            if (object == NOOP) continue;
            LOG.warn("Stopped without executing or closing {}", object);
        }
        if (this._budget != null) {
            this._budget.reset();
        }
        object = this._joinLock;
        synchronized (object) {
            this._joinLock.notifyAll();
        }
    }

    private void joinThreads(long l2) throws InterruptedException {
        for (Thread thread : this._threads) {
            long l3 = TimeUnit.NANOSECONDS.toMillis(l2 - System.nanoTime());
            if (LOG.isDebugEnabled()) {
                LOG.debug("Waiting for {} for {}", thread, l3);
            }
            if (l3 <= 0L) continue;
            thread.join(l3);
        }
    }

    public int getIdleTimeout() {
        return this._idleTimeout;
    }

    public void setIdleTimeout(int n2) {
        this._idleTimeout = n2;
        ReservedThreadExecutor reservedThreadExecutor = this.getBean(ReservedThreadExecutor.class);
        if (reservedThreadExecutor != null) {
            reservedThreadExecutor.setIdleTimeout(n2, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public int getMaxThreads() {
        return this._maxThreads;
    }

    public void setMaxThreads(int n2) {
        if (this._budget != null) {
            this._budget.check(n2);
        }
        this._maxThreads = n2;
        if (this._minThreads > this._maxThreads) {
            this._minThreads = this._maxThreads;
        }
    }

    public int getMinThreads() {
        return this._minThreads;
    }

    public void setMinThreads(int n2) {
        this._minThreads = n2;
        if (this._minThreads > this._maxThreads) {
            this._maxThreads = this._minThreads;
        }
        if (this.isStarted()) {
            this.ensureThreads();
        }
    }

    public int getReservedThreads() {
        return this._reservedThreads;
    }

    public void setReservedThreads(int n2) {
        if (this.isRunning()) {
            throw new IllegalStateException(this.getState());
        }
        this._reservedThreads = n2;
    }

    public void setName(String string) {
        if (this.isRunning()) {
            throw new IllegalStateException(this.getState());
        }
        this._name = string;
    }

    public int getThreadsPriority() {
        return this._priority;
    }

    public boolean isDaemon() {
        return this._daemon;
    }

    public void setDaemon(boolean bl2) {
        this._daemon = bl2;
    }

    public boolean isDetailedDump() {
        return this._detailedDump;
    }

    public int getQueueSize() {
        int n2 = this._counts.getLo();
        return Math.max(0, -n2);
    }

    public int getThreads() {
        int n2 = this._counts.getHi();
        return Math.max(0, n2);
    }

    @Override
    public void execute(Runnable runnable) {
        int n2;
        int n3;
        int n4;
        long l2;
        do {
            if ((n4 = AtomicBiInteger.getHi(l2 = this._counts.get())) != Integer.MIN_VALUE) continue;
            throw new RejectedExecutionException(runnable.toString());
        } while (!this._counts.compareAndSet(l2, n4 + (n3 = (n2 = AtomicBiInteger.getLo(l2)) <= 0 && n4 < this._maxThreads ? 1 : 0), n2 + n3 - 1));
        if (!this._jobs.offer(runnable)) {
            if (this.addCounts(-n3, 1 - n3)) {
                LOG.warn("{} rejected {}", this, runnable);
            }
            throw new RejectedExecutionException(runnable.toString());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("queue {} startThread={}", runnable, n3);
        }
        while (n3-- > 0) {
            this.startThread();
        }
    }

    @Override
    public boolean tryExecute(Runnable runnable) {
        TryExecutor tryExecutor = this._tryExecutor;
        return tryExecutor != null && tryExecutor.tryExecute(runnable);
    }

    private void ensureThreads() {
        long l2;
        int n2;
        while ((n2 = AtomicBiInteger.getHi(l2 = this._counts.get())) != Integer.MIN_VALUE) {
            int n3 = AtomicBiInteger.getLo(l2);
            if (n2 >= this._minThreads && (n3 >= 0 || n2 >= this._maxThreads)) break;
            if (!this._counts.compareAndSet(l2, n2 + 1, n3 + 1)) continue;
            this.startThread();
        }
    }

    protected void startThread() {
        boolean bl2 = false;
        try {
            Thread thread = this._threadFactory.newThread(this._runnable);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Starting {}", thread);
            }
            this._threads.add(thread);
            this._lastShrink.set(System.nanoTime());
            thread.start();
            bl2 = true;
        }
        finally {
            if (!bl2) {
                this.addCounts(-1, -1);
            }
        }
    }

    private boolean addCounts(int n2, int n3) {
        int n4;
        int n5;
        long l2;
        long l3;
        do {
            l3 = this._counts.get();
            n5 = AtomicBiInteger.getHi(l3);
            n4 = AtomicBiInteger.getLo(l3);
            if (n5 != Integer.MIN_VALUE) continue;
            return false;
        } while (!this._counts.compareAndSet(l3, l2 = AtomicBiInteger.encode(n5 + n2, n4 + n3)));
        return true;
    }

    @Override
    public Thread newThread(Runnable runnable) {
        return PrivilegedThreadFactory.newThread(() -> {
            Thread thread = new Thread(this._threadGroup, runnable);
            thread.setDaemon(this.isDaemon());
            thread.setPriority(this.getThreadsPriority());
            thread.setName(this._name + "-" + thread.getId());
            thread.setContextClassLoader(this.getClass().getClassLoader());
            return thread;
        });
    }

    protected void removeThread(Thread thread) {
        this._threads.remove(thread);
    }

    @Override
    public void dump(Appendable appendable2, String string) throws IOException {
        ArrayList<Object> arrayList = new ArrayList<Object>(this.getMaxThreads());
        for (Thread thread : this._threads) {
            StackTraceElement[] stackTraceElementArray = thread.getStackTrace();
            String string3 = this.getCompressedStackTag(stackTraceElementArray);
            String string4 = String.format("%s %s tid=%d prio=%d", new Object[]{thread.getName(), thread.getState(), thread.getId(), thread.getPriority()});
            if (!StringUtil.isBlank(string3)) {
                arrayList.add(string4 + " " + string3);
                continue;
            }
            if (this.isDetailedDump()) {
                arrayList.add((appendable, string2) -> Dumpable.dumpObjects(appendable, string2, string4, stackTraceElementArray));
                continue;
            }
            arrayList.add(string4 + " @ " + (stackTraceElementArray.length > 0 ? stackTraceElementArray[0].toString() : "???"));
        }
        DumpableCollection dumpableCollection = new DumpableCollection("threads", arrayList);
        if (this.isDetailedDump()) {
            this.dumpObjects(appendable2, string, dumpableCollection, new DumpableCollection("jobs", new ArrayList<Runnable>(this.getQueue())));
        } else {
            this.dumpObjects(appendable2, string, dumpableCollection);
        }
    }

    private String getCompressedStackTag(StackTraceElement[] stackTraceElementArray) {
        for (StackTraceElement stackTraceElement : stackTraceElementArray) {
            if ("idleJobPoll".equals(stackTraceElement.getMethodName()) && stackTraceElement.getClassName().equals(Runner.class.getName())) {
                return "IDLE";
            }
            if ("reservedWait".equals(stackTraceElement.getMethodName()) && stackTraceElement.getClassName().endsWith("ReservedThread")) {
                return "RESERVED";
            }
            if ("select".equals(stackTraceElement.getMethodName()) && stackTraceElement.getClassName().endsWith("SelectorProducer")) {
                return "SELECTING";
            }
            if (!"accept".equals(stackTraceElement.getMethodName()) || !stackTraceElement.getClassName().contains("ServerConnector")) continue;
            return "ACCEPTING";
        }
        return "";
    }

    protected void runJob(Runnable runnable) {
        runnable.run();
    }

    protected BlockingQueue<Runnable> getQueue() {
        return this._jobs;
    }

    @Override
    public String toString() {
        long l2 = this._counts.get();
        int n2 = Math.max(0, AtomicBiInteger.getHi(l2));
        int n3 = Math.max(0, AtomicBiInteger.getLo(l2));
        int n4 = this.getQueueSize();
        return String.format("%s[%s]@%x{%s,%d<=%d<=%d,i=%d,r=%d,q=%d}[%s]", this.getClass().getSimpleName(), this._name, this.hashCode(), this.getState(), this.getMinThreads(), n2, this.getMaxThreads(), n3, this.getReservedThreads(), n4, this._tryExecutor);
    }

    private class Runner
    implements Runnable {
        private Runner() {
        }

        private Runnable idleJobPoll(long l2) throws InterruptedException {
            if (l2 <= 0L) {
                return (Runnable)QueuedThreadPool.this._jobs.take();
            }
            return (Runnable)QueuedThreadPool.this._jobs.poll(l2, TimeUnit.MILLISECONDS);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Runner started for {}", QueuedThreadPool.this);
            }
            boolean bl2 = true;
            try {
                void var2_3;
                Object var2_2 = null;
                while (QueuedThreadPool.this.addCounts(0, var2_3 == null ? 0 : 1)) {
                    bl2 = true;
                    try {
                        void var2_6;
                        Runnable runnable = (Runnable)QueuedThreadPool.this._jobs.poll();
                        if (runnable == null) {
                            Runnable runnable2;
                            long l2 = QueuedThreadPool.this.getIdleTimeout();
                            if (l2 > 0L && QueuedThreadPool.this.getThreads() > QueuedThreadPool.this._minThreads) {
                                long l3 = QueuedThreadPool.this._lastShrink.get();
                                long l4 = System.nanoTime();
                                if (l4 - l3 > TimeUnit.MILLISECONDS.toNanos(l2) && QueuedThreadPool.this._lastShrink.compareAndSet(l3, l4)) {
                                    if (LOG.isDebugEnabled()) {
                                        LOG.debug("shrinking {}", QueuedThreadPool.this);
                                    }
                                    break;
                                }
                            }
                            if ((runnable2 = this.idleJobPoll(l2)) == null) continue;
                        }
                        bl2 = false;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("run {} in {}", var2_6, QueuedThreadPool.this);
                        }
                        QueuedThreadPool.this.runJob((Runnable)var2_6);
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug("ran {} in {}", var2_6, QueuedThreadPool.this);
                    }
                    catch (InterruptedException interruptedException) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("interrupted {} in {}", var2_3, QueuedThreadPool.this);
                        }
                        LOG.ignore(interruptedException);
                    }
                    catch (Throwable throwable) {
                        LOG.warn(throwable);
                    }
                    finally {
                        Thread.interrupted();
                    }
                }
            }
            catch (Throwable throwable) {
                Thread thread = Thread.currentThread();
                QueuedThreadPool.this.removeThread(thread);
                QueuedThreadPool.this.addCounts(-1, bl2 ? -1 : 0);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} exited for {}", thread, QueuedThreadPool.this);
                }
                QueuedThreadPool.this.ensureThreads();
                throw throwable;
            }
            Thread thread = Thread.currentThread();
            QueuedThreadPool.this.removeThread(thread);
            QueuedThreadPool.this.addCounts(-1, bl2 ? -1 : 0);
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} exited for {}", thread, QueuedThreadPool.this);
            }
            QueuedThreadPool.this.ensureThreads();
        }
    }
}

