/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.esotericsoftware.kryo.pool;

import com.gradle.scan.plugin.internal.dep.com.esotericsoftware.kryo.Kryo;
import com.gradle.scan.plugin.internal.dep.com.esotericsoftware.kryo.pool.KryoCallback;
import com.gradle.scan.plugin.internal.dep.com.esotericsoftware.kryo.pool.KryoFactory;
import com.gradle.scan.plugin.internal.dep.com.esotericsoftware.kryo.pool.KryoPool;
import java.util.Queue;

class KryoPoolQueueImpl
implements KryoPool {
    private final Queue<Kryo> queue;
    private final KryoFactory factory;

    KryoPoolQueueImpl(KryoFactory kryoFactory, Queue<Kryo> queue) {
        this.factory = kryoFactory;
        this.queue = queue;
    }

    public Kryo borrow() {
        Kryo kryo = this.queue.poll();
        if (kryo != null) {
            return kryo;
        }
        return this.factory.create();
    }

    public void release(Kryo kryo) {
        this.queue.offer(kryo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T run(KryoCallback<T> kryoCallback) {
        Kryo kryo = this.borrow();
        try {
            T t2 = kryoCallback.execute(kryo);
            return t2;
        }
        finally {
            this.release(kryo);
        }
    }
}

