/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.esotericsoftware.kryo.serializers;

import com.gradle.scan.plugin.internal.dep.com.esotericsoftware.kryo.Kryo;
import com.gradle.scan.plugin.internal.dep.com.esotericsoftware.kryo.KryoException;
import com.gradle.scan.plugin.internal.dep.com.esotericsoftware.kryo.Serializer;
import com.gradle.scan.plugin.internal.dep.com.esotericsoftware.kryo.io.Input;
import com.gradle.scan.plugin.internal.dep.com.esotericsoftware.kryo.io.Output;
import com.gradle.scan.plugin.internal.dep.com.esotericsoftware.kryo.util.ObjectMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;

public class JavaSerializer
extends Serializer {
    public void write(Kryo kryo, Output output, Object object) {
        try {
            ObjectMap objectMap = kryo.getGraphContext();
            ObjectOutputStream objectOutputStream = (ObjectOutputStream)objectMap.get(this);
            if (objectOutputStream == null) {
                objectOutputStream = new ObjectOutputStream(output);
                objectMap.put(this, objectOutputStream);
            }
            objectOutputStream.writeObject(object);
            objectOutputStream.flush();
        }
        catch (Exception exception) {
            throw new KryoException("Error during Java serialization.", exception);
        }
    }

    public Object read(Kryo kryo, Input input, Class clazz) {
        try {
            ObjectMap objectMap = kryo.getGraphContext();
            ObjectInputStream objectInputStream = (ObjectInputStream)objectMap.get(this);
            if (objectInputStream == null) {
                objectInputStream = new ObjectInputStreamWithKryoClassLoader(input, kryo);
                objectMap.put(this, objectInputStream);
            }
            return objectInputStream.readObject();
        }
        catch (Exception exception) {
            throw new KryoException("Error during Java deserialization.", exception);
        }
    }

    private static class ObjectInputStreamWithKryoClassLoader
    extends ObjectInputStream {
        private final ClassLoader loader;

        ObjectInputStreamWithKryoClassLoader(InputStream inputStream, Kryo kryo) throws IOException {
            super(inputStream);
            this.loader = kryo.getClassLoader();
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass objectStreamClass) {
            try {
                return Class.forName(objectStreamClass.getName(), false, this.loader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new RuntimeException("Class not found: " + objectStreamClass.getName(), classNotFoundException);
            }
        }
    }
}

