/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.io;

import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.io.Connection;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.io.EndPoint;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.Callback;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.log.Log;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.log.Logger;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeoutException;

public abstract class AbstractConnection
implements Connection {
    private static final Logger LOG = Log.getLogger(AbstractConnection.class);
    private final List<Connection.Listener> _listeners = new CopyOnWriteArrayList<Connection.Listener>();
    private final long _created = System.currentTimeMillis();
    private final EndPoint _endPoint;
    private final Executor _executor;
    private final Callback _readCallback;
    private int _inputBufferSize = 2048;

    protected AbstractConnection(EndPoint endPoint, Executor executor) {
        if (executor == null) {
            throw new IllegalArgumentException("Executor must not be null!");
        }
        this._endPoint = endPoint;
        this._executor = executor;
        this._readCallback = new ReadCallback();
    }

    @Override
    public void addListener(Connection.Listener listener) {
        this._listeners.add(listener);
    }

    public int getInputBufferSize() {
        return this._inputBufferSize;
    }

    public void setInputBufferSize(int n2) {
        this._inputBufferSize = n2;
    }

    protected Executor getExecutor() {
        return this._executor;
    }

    public void fillInterested() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("fillInterested {}", this);
        }
        this.getEndPoint().fillInterested(this._readCallback);
    }

    public void tryFillInterested(Callback callback) {
        this.getEndPoint().tryFillInterested(callback);
    }

    public abstract void onFillable();

    protected void onFillInterestedFailed(Throwable throwable) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} onFillInterestedFailed {}", this, throwable);
        }
        if (this._endPoint.isOpen()) {
            boolean bl2 = true;
            if (throwable instanceof TimeoutException) {
                bl2 = this.onReadTimeout(throwable);
            }
            if (bl2) {
                if (this._endPoint.isOutputShutdown()) {
                    this._endPoint.close();
                } else {
                    this._endPoint.shutdownOutput();
                    this.fillInterested();
                }
            }
        }
    }

    protected boolean onReadTimeout(Throwable throwable) {
        return true;
    }

    @Override
    public void onOpen() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onOpen {}", this);
        }
        for (Connection.Listener listener : this._listeners) {
            this.onOpened(listener);
        }
    }

    private void onOpened(Connection.Listener listener) {
        try {
            listener.onOpened(this);
        }
        catch (Throwable throwable) {
            LOG.info("Failure while notifying listener " + listener, throwable);
        }
    }

    @Override
    public void onClose() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onClose {}", this);
        }
        for (Connection.Listener listener : this._listeners) {
            this.onClosed(listener);
        }
    }

    private void onClosed(Connection.Listener listener) {
        try {
            listener.onClosed(this);
        }
        catch (Throwable throwable) {
            LOG.info("Failure while notifying listener " + listener, throwable);
        }
    }

    @Override
    public EndPoint getEndPoint() {
        return this._endPoint;
    }

    @Override
    public void close() {
        this.getEndPoint().close();
    }

    @Override
    public boolean onIdleExpired() {
        return true;
    }

    public final String toString() {
        return String.format("%s@%h::%s", this.getClass().getSimpleName(), this, this.getEndPoint());
    }

    public String toConnectionString() {
        return String.format("%s@%h", this.getClass().getSimpleName(), this);
    }

    private class ReadCallback
    implements Callback {
        private ReadCallback() {
        }

        @Override
        public void succeeded() {
            AbstractConnection.this.onFillable();
        }

        @Override
        public void failed(Throwable throwable) {
            AbstractConnection.this.onFillInterestedFailed(throwable);
        }

        public String toString() {
            return String.format("AC.ReadCB@%h{%s}", AbstractConnection.this, AbstractConnection.this);
        }
    }
}

