/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util;

import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.TypeUtil;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.log.Log;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class BufferUtil {
    static final byte[] DIGIT = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
    public static final ByteBuffer EMPTY_BUFFER = ByteBuffer.wrap(new byte[0]);
    private static final int[] decDivisors = new int[]{1000000000, 100000000, 10000000, 1000000, 100000, 10000, 1000, 100, 10, 1};
    private static final int[] hexDivisors = new int[]{0x10000000, 0x1000000, 0x100000, 65536, 4096, 256, 16, 1};
    private static final long[] decDivisorsL = new long[]{1000000000000000000L, 100000000000000000L, 10000000000000000L, 1000000000000000L, 100000000000000L, 10000000000000L, 1000000000000L, 100000000000L, 10000000000L, 1000000000L, 100000000L, 10000000L, 1000000L, 100000L, 10000L, 1000L, 100L, 10L, 1L};

    public static ByteBuffer allocate(int n2) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(n2);
        byteBuffer.limit(0);
        return byteBuffer;
    }

    public static ByteBuffer allocateDirect(int n2) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n2);
        byteBuffer.limit(0);
        return byteBuffer;
    }

    public static void reset(ByteBuffer byteBuffer) {
        if (byteBuffer != null) {
            byteBuffer.order(ByteOrder.BIG_ENDIAN);
            byteBuffer.position(0);
            byteBuffer.limit(0);
        }
    }

    public static void clear(ByteBuffer byteBuffer) {
        if (byteBuffer != null) {
            byteBuffer.position(0);
            byteBuffer.limit(0);
        }
    }

    public static void clearToFill(ByteBuffer byteBuffer) {
        if (byteBuffer != null) {
            byteBuffer.position(0);
            byteBuffer.limit(byteBuffer.capacity());
        }
    }

    public static int flipToFill(ByteBuffer byteBuffer) {
        int n2;
        int n3 = byteBuffer.position();
        if (n3 == (n2 = byteBuffer.limit())) {
            byteBuffer.position(0);
            byteBuffer.limit(byteBuffer.capacity());
            return 0;
        }
        int n4 = byteBuffer.capacity();
        if (n2 == n4) {
            byteBuffer.compact();
            return 0;
        }
        byteBuffer.position(n2);
        byteBuffer.limit(n4);
        return n3;
    }

    public static void flipToFlush(ByteBuffer byteBuffer, int n2) {
        byteBuffer.limit(byteBuffer.position());
        byteBuffer.position(n2);
    }

    public static byte[] toArray(ByteBuffer byteBuffer) {
        if (byteBuffer.hasArray()) {
            byte[] byArray = byteBuffer.array();
            int n2 = byteBuffer.arrayOffset() + byteBuffer.position();
            return Arrays.copyOfRange(byArray, n2, n2 + byteBuffer.remaining());
        }
        byte[] byArray = new byte[byteBuffer.remaining()];
        byteBuffer.slice().get(byArray);
        return byArray;
    }

    public static boolean isTheEmptyBuffer(ByteBuffer byteBuffer) {
        boolean bl2 = byteBuffer == EMPTY_BUFFER;
        return bl2;
    }

    public static boolean isEmpty(ByteBuffer byteBuffer) {
        return byteBuffer == null || byteBuffer.remaining() == 0;
    }

    public static boolean isEmpty(ByteBuffer[] byteBufferArray) {
        if (byteBufferArray == null || byteBufferArray.length == 0) {
            return true;
        }
        for (ByteBuffer byteBuffer : byteBufferArray) {
            if (byteBuffer == null || !byteBuffer.hasRemaining()) continue;
            return false;
        }
        return true;
    }

    public static long remaining(ByteBuffer ... byteBufferArray) {
        long l2 = 0L;
        if (byteBufferArray != null) {
            for (ByteBuffer byteBuffer : byteBufferArray) {
                if (byteBuffer == null) continue;
                l2 += (long)byteBuffer.remaining();
            }
        }
        return l2;
    }

    public static boolean hasContent(ByteBuffer byteBuffer) {
        return byteBuffer != null && byteBuffer.remaining() > 0;
    }

    public static int length(ByteBuffer byteBuffer) {
        return byteBuffer == null ? 0 : byteBuffer.remaining();
    }

    public static int space(ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            return 0;
        }
        return byteBuffer.capacity() - byteBuffer.limit();
    }

    public static boolean compact(ByteBuffer byteBuffer) {
        if (byteBuffer.position() == 0) {
            return false;
        }
        boolean bl2 = byteBuffer.limit() == byteBuffer.capacity();
        byteBuffer.compact().flip();
        return bl2 && byteBuffer.limit() < byteBuffer.capacity();
    }

    public static int put(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        int n2;
        int n3 = byteBuffer.remaining();
        if (n3 > 0) {
            if (n3 <= byteBuffer2.remaining()) {
                byteBuffer2.put(byteBuffer);
                n2 = n3;
                byteBuffer.position(byteBuffer.limit());
            } else if (byteBuffer.hasArray()) {
                n2 = byteBuffer2.remaining();
                byteBuffer2.put(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), n2);
                byteBuffer.position(byteBuffer.position() + n2);
            } else {
                n2 = byteBuffer2.remaining();
                ByteBuffer byteBuffer3 = byteBuffer.slice();
                byteBuffer3.limit(n2);
                byteBuffer2.put(byteBuffer3);
                byteBuffer.position(byteBuffer.position() + n2);
            }
        } else {
            n2 = 0;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int append(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        int n2 = BufferUtil.flipToFill(byteBuffer);
        try {
            int n3 = BufferUtil.put(byteBuffer2, byteBuffer);
            return n3;
        }
        finally {
            BufferUtil.flipToFlush(byteBuffer, n2);
        }
    }

    public static void writeTo(ByteBuffer byteBuffer, OutputStream outputStream) throws IOException {
        if (byteBuffer.hasArray()) {
            outputStream.write(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining());
            byteBuffer.position(byteBuffer.position() + byteBuffer.remaining());
        } else {
            byte[] byArray = new byte[Math.min(byteBuffer.remaining(), 4096)];
            while (byteBuffer.hasRemaining()) {
                int n2 = Math.min(byteBuffer.remaining(), 4096);
                byteBuffer.get(byArray, 0, n2);
                outputStream.write(byArray, 0, n2);
            }
        }
    }

    public static String toString(ByteBuffer byteBuffer, int n2, int n3, Charset charset) {
        byte[] byArray;
        if (byteBuffer == null) {
            return null;
        }
        byte[] byArray2 = byArray = byteBuffer.hasArray() ? byteBuffer.array() : null;
        if (byArray == null) {
            ByteBuffer byteBuffer2 = byteBuffer.asReadOnlyBuffer();
            byteBuffer2.position(n2);
            byteBuffer2.limit(n2 + n3);
            byte[] byArray3 = new byte[n3];
            byteBuffer2.get(byArray3);
            return new String(byArray3, 0, byArray3.length, charset);
        }
        return new String(byArray, byteBuffer.arrayOffset() + n2, n3, charset);
    }

    public static void putHexInt(ByteBuffer byteBuffer, int n2) {
        if (n2 < 0) {
            byteBuffer.put((byte)45);
            if (n2 == Integer.MIN_VALUE) {
                byteBuffer.put((byte)56);
                byteBuffer.put((byte)48);
                byteBuffer.put((byte)48);
                byteBuffer.put((byte)48);
                byteBuffer.put((byte)48);
                byteBuffer.put((byte)48);
                byteBuffer.put((byte)48);
                byteBuffer.put((byte)48);
                return;
            }
            n2 = -n2;
        }
        if (n2 < 16) {
            byteBuffer.put(DIGIT[n2]);
        } else {
            boolean bl2 = false;
            for (int n3 : hexDivisors) {
                if (n2 < n3) {
                    if (!bl2) continue;
                    byteBuffer.put((byte)48);
                    continue;
                }
                bl2 = true;
                int n4 = n2 / n3;
                byteBuffer.put(DIGIT[n4]);
                n2 -= n4 * n3;
            }
        }
    }

    public static void putDecLong(ByteBuffer byteBuffer, long l2) {
        if (l2 < 0L) {
            byteBuffer.put((byte)45);
            if (l2 == Long.MIN_VALUE) {
                byteBuffer.put((byte)57);
                l2 = 223372036854775808L;
            } else {
                l2 = -l2;
            }
        }
        if (l2 < 10L) {
            byteBuffer.put(DIGIT[(int)l2]);
        } else {
            boolean bl2 = false;
            for (long l3 : decDivisorsL) {
                if (l2 < l3) {
                    if (!bl2) continue;
                    byteBuffer.put((byte)48);
                    continue;
                }
                bl2 = true;
                long l4 = l2 / l3;
                byteBuffer.put(DIGIT[(int)l4]);
                l2 -= l4 * l3;
            }
        }
    }

    public static ByteBuffer toBuffer(String string) {
        return BufferUtil.toBuffer(string, StandardCharsets.ISO_8859_1);
    }

    public static ByteBuffer toBuffer(String string, Charset charset) {
        if (string == null) {
            return EMPTY_BUFFER;
        }
        return BufferUtil.toBuffer(string.getBytes(charset));
    }

    public static ByteBuffer toBuffer(byte[] byArray) {
        if (byArray == null) {
            return EMPTY_BUFFER;
        }
        return BufferUtil.toBuffer(byArray, 0, byArray.length);
    }

    public static ByteBuffer toBuffer(byte[] byArray, int n2, int n3) {
        if (byArray == null) {
            return EMPTY_BUFFER;
        }
        return ByteBuffer.wrap(byArray, n2, n3);
    }

    public static String toSummaryString(ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[p=");
        stringBuilder.append(byteBuffer.position());
        stringBuilder.append(",l=");
        stringBuilder.append(byteBuffer.limit());
        stringBuilder.append(",c=");
        stringBuilder.append(byteBuffer.capacity());
        stringBuilder.append(",r=");
        stringBuilder.append(byteBuffer.remaining());
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static String toDetailString(ByteBuffer[] byteBufferArray) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        for (int i2 = 0; i2 < byteBufferArray.length; ++i2) {
            if (i2 > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(BufferUtil.toDetailString(byteBufferArray[i2]));
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    private static void idString(ByteBuffer byteBuffer, StringBuilder stringBuilder) {
        stringBuilder.append(byteBuffer.getClass().getSimpleName());
        stringBuilder.append("@");
        if (byteBuffer.hasArray() && byteBuffer.arrayOffset() == 4) {
            stringBuilder.append('T');
            byte[] byArray = byteBuffer.array();
            TypeUtil.toHex(byArray[0], stringBuilder);
            TypeUtil.toHex(byArray[1], stringBuilder);
            TypeUtil.toHex(byArray[2], stringBuilder);
            TypeUtil.toHex(byArray[3], stringBuilder);
        } else {
            stringBuilder.append(Integer.toHexString(System.identityHashCode(byteBuffer)));
        }
    }

    public static String toDetailString(ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder();
        BufferUtil.idString(byteBuffer, stringBuilder);
        stringBuilder.append("[p=");
        stringBuilder.append(byteBuffer.position());
        stringBuilder.append(",l=");
        stringBuilder.append(byteBuffer.limit());
        stringBuilder.append(",c=");
        stringBuilder.append(byteBuffer.capacity());
        stringBuilder.append(",r=");
        stringBuilder.append(byteBuffer.remaining());
        stringBuilder.append("]={");
        BufferUtil.appendDebugString(stringBuilder, byteBuffer);
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private static void appendDebugString(StringBuilder stringBuilder, ByteBuffer byteBuffer) {
        byteBuffer = byteBuffer.asReadOnlyBuffer();
        try {
            int n2;
            for (n2 = 0; n2 < byteBuffer.position(); ++n2) {
                BufferUtil.appendContentChar(stringBuilder, byteBuffer.get(n2));
                if (n2 != 8 || byteBuffer.position() <= 16) continue;
                stringBuilder.append("...");
                n2 = byteBuffer.position() - 8;
            }
            stringBuilder.append("<<<");
            for (n2 = byteBuffer.position(); n2 < byteBuffer.limit(); ++n2) {
                BufferUtil.appendContentChar(stringBuilder, byteBuffer.get(n2));
                if (n2 != byteBuffer.position() + 24 || byteBuffer.limit() <= byteBuffer.position() + 48) continue;
                stringBuilder.append("...");
                n2 = byteBuffer.limit() - 24;
            }
            stringBuilder.append(">>>");
            n2 = byteBuffer.limit();
            byteBuffer.limit(byteBuffer.capacity());
            for (int i2 = n2; i2 < byteBuffer.capacity(); ++i2) {
                BufferUtil.appendContentChar(stringBuilder, byteBuffer.get(i2));
                if (i2 != n2 + 8 || byteBuffer.capacity() <= n2 + 16) continue;
                stringBuilder.append("...");
                i2 = byteBuffer.capacity() - 8;
            }
            byteBuffer.limit(n2);
        }
        catch (Throwable throwable) {
            Log.getRootLogger().ignore(throwable);
            stringBuilder.append("!!concurrent mod!!");
        }
    }

    private static void appendContentChar(StringBuilder stringBuilder, byte by2) {
        if (by2 == 92) {
            stringBuilder.append("\\\\");
        } else if (by2 >= 32 && by2 <= 126) {
            stringBuilder.append((char)by2);
        } else if (by2 == 13) {
            stringBuilder.append("\\r");
        } else if (by2 == 10) {
            stringBuilder.append("\\n");
        } else if (by2 == 9) {
            stringBuilder.append("\\t");
        } else {
            stringBuilder.append("\\x").append(TypeUtil.toHexString(by2));
        }
    }

    public static void putCRLF(ByteBuffer byteBuffer) {
        byteBuffer.put((byte)13);
        byteBuffer.put((byte)10);
    }

    public static ByteBuffer ensureCapacity(ByteBuffer byteBuffer, int n2) {
        if (byteBuffer == null) {
            return BufferUtil.allocate(n2);
        }
        if (byteBuffer.capacity() >= n2) {
            return byteBuffer;
        }
        if (byteBuffer.hasArray()) {
            return ByteBuffer.wrap(Arrays.copyOfRange(byteBuffer.array(), byteBuffer.arrayOffset(), byteBuffer.arrayOffset() + n2), byteBuffer.position(), byteBuffer.remaining());
        }
        throw new UnsupportedOperationException();
    }
}

