/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.component;

import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.StringUtil;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.component.AbstractLifeCycle;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.component.Container;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.component.ContainerLifeCycle;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.component.LifeCycle;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Stream;

public interface Dumpable {
    public void dump(Appendable var1, String var2) throws IOException;

    public static String dump(Dumpable dumpable) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            dumpable.dump(stringBuilder, "");
        }
        catch (IOException iOException) {
            stringBuilder.append(iOException.toString());
        }
        stringBuilder.append("key: +- bean, += managed, +~ unmanaged, +? auto, +: iterable, +] array, +@ map, +> undefined");
        return stringBuilder.toString();
    }

    default public String dumpSelf() {
        return this.toString();
    }

    public static void dumpObject(Appendable appendable, Object object) throws IOException {
        try {
            String string;
            if (object == null) {
                string = "null";
            } else if (object instanceof Dumpable) {
                string = ((Dumpable)object).dumpSelf();
                string = StringUtil.replace(string, "\r\n", "|");
                string = StringUtil.replace(string, '\n', '|');
            } else if (object instanceof Collection) {
                string = String.format("%s@%x(size=%d)", object.getClass().getName(), object.hashCode(), ((Collection)object).size());
            } else if (object.getClass().isArray()) {
                string = String.format("%s@%x[size=%d]", object.getClass().getComponentType(), object.hashCode(), Array.getLength(object));
            } else if (object instanceof Map) {
                string = String.format("%s@%x{size=%d}", object.getClass().getName(), object.hashCode(), ((Map)object).size());
            } else {
                string = String.valueOf(object);
                string = StringUtil.replace(string, "\r\n", "|");
                string = StringUtil.replace(string, '\n', '|');
            }
            if (object instanceof LifeCycle) {
                appendable.append(string).append(" - ").append(AbstractLifeCycle.getState((LifeCycle)object)).append("\n");
            } else {
                appendable.append(string).append("\n");
            }
        }
        catch (Throwable throwable) {
            appendable.append("=> ").append(throwable.toString()).append("\n");
        }
    }

    public static void dumpObjects(Appendable appendable, String string, Object object, Object ... objectArray) throws IOException {
        int n2;
        Dumpable.dumpObject(appendable, object);
        int n3 = n2 = objectArray == null ? 0 : objectArray.length;
        if (object instanceof Stream) {
            object = ((Stream)object).toArray();
        }
        if (object instanceof Array) {
            object = Arrays.asList(object);
        }
        if (object instanceof Container) {
            Dumpable.dumpContainer(appendable, string, (Container)object, n2 == 0);
        }
        if (object instanceof Iterable) {
            Dumpable.dumpIterable(appendable, string, (Iterable)object, n2 == 0);
        } else if (object instanceof Map) {
            Dumpable.dumpMapEntries(appendable, string, (Map)object, n2 == 0);
        }
        if (n2 == 0) {
            return;
        }
        int n4 = 0;
        for (Object object2 : objectArray) {
            String string2 = string + (++n4 < n2 ? "|  " : "   ");
            appendable.append(string).append("+> ");
            if (object2 instanceof Dumpable) {
                ((Dumpable)object2).dump(appendable, string2);
                continue;
            }
            Dumpable.dumpObjects(appendable, string2, object2, new Object[0]);
        }
    }

    public static void dumpContainer(Appendable appendable, String string, Container container, boolean bl2) throws IOException {
        Container container2 = container;
        ContainerLifeCycle containerLifeCycle = container2 instanceof ContainerLifeCycle ? (ContainerLifeCycle)container2 : null;
        Iterator<Object> iterator = container2.getBeans().iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (container2 instanceof DumpableContainer && !((DumpableContainer)((Object)container2)).isDumpable(object)) continue;
            String string2 = string + (iterator.hasNext() || !bl2 ? "|  " : "   ");
            if (object instanceof LifeCycle) {
                if (container2.isManaged(object)) {
                    appendable.append(string).append("+= ");
                    if (object instanceof Dumpable) {
                        ((Dumpable)object).dump(appendable, string2);
                        continue;
                    }
                    Dumpable.dumpObjects(appendable, string2, object, new Object[0]);
                    continue;
                }
                if (containerLifeCycle != null && containerLifeCycle.isAuto(object)) {
                    appendable.append(string).append("+? ");
                    if (object instanceof Dumpable) {
                        ((Dumpable)object).dump(appendable, string2);
                        continue;
                    }
                    Dumpable.dumpObjects(appendable, string2, object, new Object[0]);
                    continue;
                }
                appendable.append(string).append("+~ ");
                Dumpable.dumpObject(appendable, object);
                continue;
            }
            if (containerLifeCycle != null && containerLifeCycle.isUnmanaged(object)) {
                appendable.append(string).append("+~ ");
                Dumpable.dumpObject(appendable, object);
                continue;
            }
            appendable.append(string).append("+- ");
            if (object instanceof Dumpable) {
                ((Dumpable)object).dump(appendable, string2);
                continue;
            }
            Dumpable.dumpObjects(appendable, string2, object, new Object[0]);
        }
    }

    public static void dumpIterable(Appendable appendable, String string, Iterable<?> iterable, boolean bl2) throws IOException {
        Iterator<?> iterator = iterable.iterator();
        while (iterator.hasNext()) {
            Object obj = iterator.next();
            String string2 = string + (iterator.hasNext() || !bl2 ? "|  " : "   ");
            appendable.append(string).append("+: ");
            if (obj instanceof Dumpable) {
                ((Dumpable)obj).dump(appendable, string2);
                continue;
            }
            Dumpable.dumpObjects(appendable, string2, obj, new Object[0]);
        }
    }

    public static void dumpMapEntries(Appendable appendable, String string, Map<?, ?> map, boolean bl2) throws IOException {
        Iterator<Map.Entry<?, ?>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<?, ?> entry = iterator.next();
            String string2 = string + (iterator.hasNext() || !bl2 ? "|  " : "   ");
            appendable.append(string).append("+@ ").append(String.valueOf(entry.getKey())).append(" = ");
            Object obj = entry.getValue();
            if (obj instanceof Dumpable) {
                ((Dumpable)obj).dump(appendable, string2);
                continue;
            }
            Dumpable.dumpObjects(appendable, string2, obj, new Object[0]);
        }
    }

    public static interface DumpableContainer
    extends Dumpable {
        default public boolean isDumpable(Object object) {
            return true;
        }
    }
}

