/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.common;

import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.api.extensions.Frame;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.common.OpCode;
import java.nio.ByteBuffer;
import java.util.Arrays;

public abstract class WebSocketFrame
implements Frame {
    protected byte finRsvOp;
    protected boolean masked = false;
    protected byte[] mask;
    protected ByteBuffer data;

    protected WebSocketFrame(byte by2) {
        this.reset();
        this.setOpCode(by2);
    }

    public abstract void assertValid();

    protected void copyHeaders(Frame frame) {
        this.finRsvOp = 0;
        this.finRsvOp = (byte)(this.finRsvOp | (frame.isFin() ? 128 : 0));
        this.finRsvOp = (byte)(this.finRsvOp | (frame.isRsv1() ? 64 : 0));
        this.finRsvOp = (byte)(this.finRsvOp | (frame.isRsv2() ? 32 : 0));
        this.finRsvOp = (byte)(this.finRsvOp | (frame.isRsv3() ? 16 : 0));
        this.finRsvOp = (byte)(this.finRsvOp | frame.getOpCode() & 0xF);
        this.masked = frame.isMasked();
        this.mask = (byte[])(this.masked ? frame.getMask() : null);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        WebSocketFrame webSocketFrame = (WebSocketFrame)object;
        if (this.data == null ? webSocketFrame.data != null : !this.data.equals(webSocketFrame.data)) {
            return false;
        }
        if (this.finRsvOp != webSocketFrame.finRsvOp) {
            return false;
        }
        if (!Arrays.equals(this.mask, webSocketFrame.mask)) {
            return false;
        }
        return this.masked == webSocketFrame.masked;
    }

    @Override
    public byte[] getMask() {
        return this.mask;
    }

    @Override
    public final byte getOpCode() {
        return (byte)(this.finRsvOp & 0xF);
    }

    @Override
    public ByteBuffer getPayload() {
        return this.data;
    }

    @Override
    public int getPayloadLength() {
        if (this.data == null) {
            return 0;
        }
        return this.data.remaining();
    }

    @Override
    public Frame.Type getType() {
        return Frame.Type.from(this.getOpCode());
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.data == null ? 0 : this.data.hashCode());
        n3 = 31 * n3 + this.finRsvOp;
        n3 = 31 * n3 + Arrays.hashCode(this.mask);
        return n3;
    }

    @Override
    public boolean hasPayload() {
        return this.data != null && this.data.hasRemaining();
    }

    public abstract boolean isDataFrame();

    @Override
    public boolean isFin() {
        return (byte)(this.finRsvOp & 0x80) != 0;
    }

    @Override
    public boolean isMasked() {
        return this.masked;
    }

    @Override
    public boolean isRsv1() {
        return (byte)(this.finRsvOp & 0x40) != 0;
    }

    @Override
    public boolean isRsv2() {
        return (byte)(this.finRsvOp & 0x20) != 0;
    }

    @Override
    public boolean isRsv3() {
        return (byte)(this.finRsvOp & 0x10) != 0;
    }

    public void reset() {
        this.finRsvOp = (byte)-128;
        this.masked = false;
        this.data = null;
        this.mask = null;
    }

    public WebSocketFrame setFin(boolean bl2) {
        this.finRsvOp = (byte)(this.finRsvOp & 0x7F | (bl2 ? 128 : 0));
        return this;
    }

    public Frame setMask(byte[] byArray) {
        this.mask = byArray;
        this.masked = this.mask != null;
        return this;
    }

    public Frame setMasked(boolean bl2) {
        this.masked = bl2;
        return this;
    }

    protected WebSocketFrame setOpCode(byte by2) {
        this.finRsvOp = (byte)(this.finRsvOp & 0xF0 | by2 & 0xF);
        return this;
    }

    public WebSocketFrame setPayload(ByteBuffer byteBuffer) {
        this.data = byteBuffer;
        return this;
    }

    public WebSocketFrame setRsv1(boolean bl2) {
        this.finRsvOp = (byte)(this.finRsvOp & 0xBF | (bl2 ? 64 : 0));
        return this;
    }

    public WebSocketFrame setRsv2(boolean bl2) {
        this.finRsvOp = (byte)(this.finRsvOp & 0xDF | (bl2 ? 32 : 0));
        return this;
    }

    public WebSocketFrame setRsv3(boolean bl2) {
        this.finRsvOp = (byte)(this.finRsvOp & 0xEF | (bl2 ? 16 : 0));
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(OpCode.name((byte)(this.finRsvOp & 0xF)));
        stringBuilder.append('[');
        stringBuilder.append("len=").append(this.getPayloadLength());
        stringBuilder.append(",fin=").append((this.finRsvOp & 0x80) != 0);
        stringBuilder.append(",rsv=");
        stringBuilder.append((this.finRsvOp & 0x40) != 0 ? (char)'1' : '.');
        stringBuilder.append((this.finRsvOp & 0x20) != 0 ? (char)'1' : '.');
        stringBuilder.append((this.finRsvOp & 0x10) != 0 ? (char)'1' : '.');
        stringBuilder.append(",masked=").append(this.masked);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

