/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.common.events;

import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.log.Log;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.log.Logger;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.api.Session;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.api.annotations.OnWebSocketError;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.api.annotations.OnWebSocketFrame;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.api.extensions.Frame;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.common.events.JettyAnnotatedMetadata;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.common.events.ParamList;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.common.events.annotated.AbstractMethodAnnotationScanner;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.common.events.annotated.CallableMethod;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.common.events.annotated.InvalidSignatureException;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.common.events.annotated.OptionalSessionCallableMethod;
import java.io.InputStream;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

public class JettyAnnotatedScanner
extends AbstractMethodAnnotationScanner<JettyAnnotatedMetadata> {
    private static final Logger LOG = Log.getLogger(JettyAnnotatedScanner.class);
    private static final ParamList validBinaryParams;
    private static final ParamList validConnectParams;
    private static final ParamList validCloseParams;
    private static final ParamList validErrorParams;
    private static final ParamList validFrameParams;
    private static final ParamList validTextParams;

    @Override
    public void onMethodAnnotation(JettyAnnotatedMetadata jettyAnnotatedMetadata, Class<?> clazz, Method method, Annotation annotation) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onMethodAnnotation({}, {}, {}, {})", jettyAnnotatedMetadata, clazz, method, annotation);
        }
        if (this.isAnnotation(annotation, OnWebSocketConnect.class)) {
            this.assertValidSignature(method, OnWebSocketConnect.class, validConnectParams);
            this.assertUnset(jettyAnnotatedMetadata.onConnect, OnWebSocketConnect.class, method);
            jettyAnnotatedMetadata.onConnect = new CallableMethod(clazz, method);
            return;
        }
        if (this.isAnnotation(annotation, OnWebSocketMessage.class)) {
            if (this.isSignatureMatch(method, validTextParams)) {
                this.assertUnset(jettyAnnotatedMetadata.onText, OnWebSocketMessage.class, method);
                jettyAnnotatedMetadata.onText = new OptionalSessionCallableMethod(clazz, method);
                return;
            }
            if (this.isSignatureMatch(method, validBinaryParams)) {
                this.assertUnset(jettyAnnotatedMetadata.onBinary, OnWebSocketMessage.class, method);
                jettyAnnotatedMetadata.onBinary = new OptionalSessionCallableMethod(clazz, method);
                return;
            }
            throw InvalidSignatureException.build(method, OnWebSocketMessage.class, validTextParams, validBinaryParams);
        }
        if (this.isAnnotation(annotation, OnWebSocketClose.class)) {
            this.assertValidSignature(method, OnWebSocketClose.class, validCloseParams);
            this.assertUnset(jettyAnnotatedMetadata.onClose, OnWebSocketClose.class, method);
            jettyAnnotatedMetadata.onClose = new OptionalSessionCallableMethod(clazz, method);
            return;
        }
        if (this.isAnnotation(annotation, OnWebSocketError.class)) {
            this.assertValidSignature(method, OnWebSocketError.class, validErrorParams);
            this.assertUnset(jettyAnnotatedMetadata.onError, OnWebSocketError.class, method);
            jettyAnnotatedMetadata.onError = new OptionalSessionCallableMethod(clazz, method);
            return;
        }
        if (this.isAnnotation(annotation, OnWebSocketFrame.class)) {
            this.assertValidSignature(method, OnWebSocketFrame.class, validFrameParams);
            this.assertUnset(jettyAnnotatedMetadata.onFrame, OnWebSocketFrame.class, method);
            jettyAnnotatedMetadata.onFrame = new OptionalSessionCallableMethod(clazz, method);
            return;
        }
    }

    public JettyAnnotatedMetadata scan(Class<?> clazz) {
        JettyAnnotatedMetadata jettyAnnotatedMetadata = new JettyAnnotatedMetadata();
        this.scanMethodAnnotations(jettyAnnotatedMetadata, clazz);
        return jettyAnnotatedMetadata;
    }

    static {
        validConnectParams = new ParamList();
        validConnectParams.addParams(Session.class);
        validCloseParams = new ParamList();
        validCloseParams.addParams(Integer.TYPE, String.class);
        validCloseParams.addParams(Session.class, Integer.TYPE, String.class);
        validErrorParams = new ParamList();
        validErrorParams.addParams(Throwable.class);
        validErrorParams.addParams(Session.class, Throwable.class);
        validTextParams = new ParamList();
        validTextParams.addParams(String.class);
        validTextParams.addParams(Session.class, String.class);
        validTextParams.addParams(Reader.class);
        validTextParams.addParams(Session.class, Reader.class);
        validBinaryParams = new ParamList();
        validBinaryParams.addParams(byte[].class, Integer.TYPE, Integer.TYPE);
        validBinaryParams.addParams(Session.class, byte[].class, Integer.TYPE, Integer.TYPE);
        validBinaryParams.addParams(InputStream.class);
        validBinaryParams.addParams(Session.class, InputStream.class);
        validFrameParams = new ParamList();
        validFrameParams.addParams(Frame.class);
        validFrameParams.addParams(Session.class, Frame.class);
    }
}

