/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client;

import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.HttpChannel;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.HttpClient;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.HttpDestination;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.HttpExchange;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.HttpProxy;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.HttpRequest;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.HttpRequestException;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.ProxyConfiguration;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.SendFailure;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.api.Authentication;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.api.AuthenticationStore;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.api.Connection;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.api.ContentProvider;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.api.Request;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.api.Response;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.http.HttpFields;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.http.HttpHeader;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.http.HttpVersion;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.io.CyclicTimeouts;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.Attachable;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.HttpCookieStore;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.log.Log;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.log.Logger;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.thread.Scheduler;
import java.net.CookieStore;
import java.net.HttpCookie;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public abstract class HttpConnection
implements Connection,
Attachable {
    private static final Logger LOG = Log.getLogger(HttpConnection.class);
    private final HttpDestination destination;
    private final RequestTimeouts requestTimeouts;
    private Object attachment;
    private int idleTimeoutGuard;
    private long idleTimeoutStamp;

    protected HttpConnection(HttpDestination httpDestination) {
        this.destination = httpDestination;
        this.requestTimeouts = new RequestTimeouts(httpDestination.getHttpClient().getScheduler());
        this.idleTimeoutStamp = System.nanoTime();
    }

    public HttpClient getHttpClient() {
        return this.destination.getHttpClient();
    }

    public HttpDestination getHttpDestination() {
        return this.destination;
    }

    protected abstract Iterator<HttpChannel> getHttpChannels();

    @Override
    public void send(Request request, Response.CompleteListener completeListener) {
        HttpExchange httpExchange;
        SendFailure sendFailure;
        HttpRequest httpRequest = (HttpRequest)request;
        ArrayList<Response.ResponseListener> arrayList = new ArrayList<Response.ResponseListener>(httpRequest.getResponseListeners());
        httpRequest.sent();
        if (completeListener != null) {
            arrayList.add(completeListener);
        }
        if ((sendFailure = this.send(httpExchange = new HttpExchange(this.getHttpDestination(), httpRequest, arrayList))) != null) {
            httpRequest.abort(sendFailure.failure);
        }
    }

    protected abstract SendFailure send(HttpExchange var1);

    protected void normalizeRequest(Request request) {
        URI uRI;
        Object object;
        boolean bl2 = ((HttpRequest)request).normalized();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Normalizing {} {}", !bl2, request);
        }
        if (bl2) {
            return;
        }
        HttpVersion httpVersion = request.getVersion();
        HttpFields httpFields = request.getHeaders();
        ContentProvider contentProvider = request.getContent();
        ProxyConfiguration.Proxy proxy = this.destination.getProxy();
        String string = request.getPath();
        if (string.trim().length() == 0) {
            string = "/";
            request.path(string);
        }
        if (proxy instanceof HttpProxy && !HttpClient.isSchemeSecure(request.getScheme()) && (object = request.getURI()) != null) {
            string = ((URI)object).toString();
            request.path(string);
        }
        if (httpVersion.getVersion() <= 11 && !httpFields.containsKey(HttpHeader.HOST.asString())) {
            object = request.getURI();
            if (object != null) {
                httpFields.put(HttpHeader.HOST, ((URI)object).getAuthority());
            } else {
                httpFields.put(this.getHttpDestination().getHostField());
            }
        }
        if (contentProvider != null) {
            long l2;
            if (!httpFields.containsKey(HttpHeader.CONTENT_TYPE.asString())) {
                object = null;
                if (contentProvider instanceof ContentProvider.Typed) {
                    object = ((ContentProvider.Typed)contentProvider).getContentType();
                }
                if (object != null) {
                    httpFields.put(HttpHeader.CONTENT_TYPE, (String)object);
                } else {
                    object = this.getHttpClient().getDefaultRequestContentType();
                    if (object != null) {
                        httpFields.put(HttpHeader.CONTENT_TYPE, (String)object);
                    }
                }
            }
            if ((l2 = contentProvider.getLength()) >= 0L && !httpFields.containsKey(HttpHeader.CONTENT_LENGTH.asString())) {
                httpFields.put(HttpHeader.CONTENT_LENGTH, String.valueOf(l2));
            }
        }
        StringBuilder stringBuilder = this.convertCookies(request.getCookies(), null);
        CookieStore cookieStore = this.getHttpClient().getCookieStore();
        if (cookieStore != null && cookieStore.getClass() != HttpCookieStore.Empty.class && (uRI = request.getURI()) != null) {
            stringBuilder = this.convertCookies(HttpCookieStore.matchPath(uRI, cookieStore.get(uRI)), stringBuilder);
        }
        if (stringBuilder != null) {
            request.header(HttpHeader.COOKIE.asString(), stringBuilder.toString());
        }
        this.applyProxyAuthentication(request, proxy);
        this.applyRequestAuthentication(request);
    }

    private StringBuilder convertCookies(List<HttpCookie> list, StringBuilder stringBuilder) {
        for (HttpCookie httpCookie : list) {
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder();
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.append("; ");
            }
            stringBuilder.append(httpCookie.getName()).append("=").append(httpCookie.getValue());
        }
        return stringBuilder;
    }

    private void applyRequestAuthentication(Request request) {
        Authentication.Result result;
        URI uRI;
        AuthenticationStore authenticationStore = this.getHttpClient().getAuthenticationStore();
        if (authenticationStore.hasAuthenticationResults() && (uRI = request.getURI()) != null && (result = authenticationStore.findAuthenticationResult(uRI)) != null) {
            result.apply(request);
        }
    }

    private void applyProxyAuthentication(Request request, ProxyConfiguration.Proxy proxy) {
        Authentication.Result result;
        if (proxy != null && (result = this.getHttpClient().getAuthenticationStore().findAuthenticationResult(proxy.getURI())) != null) {
            result.apply(request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SendFailure send(HttpChannel httpChannel, HttpExchange httpExchange) {
        boolean bl2;
        Object object = this;
        synchronized (object) {
            boolean bl3 = bl2 = this.idleTimeoutGuard >= 0;
            if (bl2) {
                ++this.idleTimeoutGuard;
            }
        }
        if (bl2) {
            SendFailure sendFailure;
            object = httpExchange.getRequest();
            if (httpChannel.associate(httpExchange)) {
                this.requestTimeouts.schedule(httpChannel);
                httpChannel.send();
                sendFailure = null;
            } else {
                httpChannel.release();
                sendFailure = new SendFailure(new HttpRequestException("Could not associate request to connection", (Request)object), false);
            }
            HttpConnection httpConnection = this;
            synchronized (httpConnection) {
                --this.idleTimeoutGuard;
                this.idleTimeoutStamp = System.nanoTime();
            }
            return sendFailure;
        }
        return new SendFailure(new TimeoutException(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onIdleTimeout(long l2) {
        HttpConnection httpConnection = this;
        synchronized (httpConnection) {
            if (this.idleTimeoutGuard == 0) {
                boolean bl2;
                long l3 = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.idleTimeoutStamp);
                boolean bl3 = bl2 = l3 > l2 / 2L;
                if (bl2) {
                    this.idleTimeoutGuard = -1;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Idle timeout {}/{}ms - {}", l3, l2, this);
                }
                return bl2;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Idle timeout skipped - {}", this);
            }
            return false;
        }
    }

    @Override
    public void setAttachment(Object object) {
        this.attachment = object;
    }

    @Override
    public Object getAttachment() {
        return this.attachment;
    }

    protected void destroy() {
        this.requestTimeouts.destroy();
    }

    public String toString() {
        return String.format("%s@%h", this.getClass().getSimpleName(), this);
    }

    private class RequestTimeouts
    extends CyclicTimeouts<HttpChannel> {
        private RequestTimeouts(Scheduler scheduler) {
            super(scheduler);
        }

        @Override
        protected Iterator<HttpChannel> iterator() {
            return HttpConnection.this.getHttpChannels();
        }

        @Override
        protected boolean onExpired(HttpChannel httpChannel) {
            HttpExchange httpExchange = httpChannel.getHttpExchange();
            if (httpExchange != null) {
                HttpRequest httpRequest = httpExchange.getRequest();
                httpRequest.abort(new TimeoutException("Total timeout " + httpRequest.getConversation().getTimeout() + " ms elapsed"));
            }
            return false;
        }
    }
}

