/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.thread;

import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.log.Log;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.log.Logger;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.thread.ThreadPool;
import java.io.Closeable;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;

public class ThreadPoolBudget {
    private static final Logger LOG = Log.getLogger(ThreadPoolBudget.class);
    private static final Lease NOOP_LEASE = new Lease(){

        @Override
        public void close() {
        }

        @Override
        public int getThreads() {
            return 0;
        }
    };
    private final Set<Leased> leases = new CopyOnWriteArraySet<Leased>();
    private final AtomicBoolean warned = new AtomicBoolean();
    private final ThreadPool.SizedThreadPool pool;
    private final int warnAt;

    public ThreadPoolBudget(ThreadPool.SizedThreadPool sizedThreadPool) {
        this.pool = sizedThreadPool;
        this.warnAt = -1;
    }

    public ThreadPool.SizedThreadPool getSizedThreadPool() {
        return this.pool;
    }

    public int getLeasedThreads() {
        return this.leases.stream().mapToInt(Lease::getThreads).sum();
    }

    public void reset() {
        this.leases.clear();
        this.warned.set(false);
    }

    public Lease leaseTo(Object object, int n2) {
        Leased leased = new Leased(object, n2);
        this.leases.add(leased);
        try {
            this.check(this.pool.getMaxThreads());
            return leased;
        }
        catch (IllegalStateException illegalStateException) {
            leased.close();
            throw illegalStateException;
        }
    }

    public boolean check(int n2) throws IllegalStateException {
        int n3 = this.getLeasedThreads();
        int n4 = n2 - n3;
        if (n4 <= 0) {
            this.printInfoOnLeases();
            throw new IllegalStateException(String.format("Insufficient configured threads: required=%d < max=%d for %s", n3, n2, this.pool));
        }
        if (n4 < this.warnAt) {
            if (this.warned.compareAndSet(false, true)) {
                this.printInfoOnLeases();
                LOG.info("Low configured threads: (max={} - required={})={} < warnAt={} for {}", n2, n3, n4, this.warnAt, this.pool);
            }
            return false;
        }
        return true;
    }

    private void printInfoOnLeases() {
        this.leases.forEach(leased -> LOG.info("{} requires {} threads from {}", ((Leased)leased).leasee, leased.getThreads(), this.pool));
    }

    public static Lease leaseFrom(Executor executor, Object object, int n2) {
        ThreadPoolBudget threadPoolBudget;
        if (executor instanceof ThreadPool.SizedThreadPool && (threadPoolBudget = ((ThreadPool.SizedThreadPool)executor).getThreadPoolBudget()) != null) {
            return threadPoolBudget.leaseTo(object, n2);
        }
        return NOOP_LEASE;
    }

    public class Leased
    implements Lease {
        private final Object leasee;
        private final int threads;

        private Leased(Object object, int n2) {
            this.leasee = object;
            this.threads = n2;
        }

        @Override
        public int getThreads() {
            return this.threads;
        }

        @Override
        public void close() {
            ThreadPoolBudget.this.leases.remove(this);
            ThreadPoolBudget.this.warned.set(false);
        }
    }

    public static interface Lease
    extends Closeable {
        public int getThreads();
    }
}

