/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.client;

import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.HttpClient;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.HttpConversation;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.HttpRequest;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.HttpResponse;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.HttpResponseException;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.api.ContentResponse;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.api.Response;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.api.Result;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.http.HttpConnectionOverHTTP;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.http.HttpConnectionUpgrader;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.http.HttpField;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.http.HttpFields;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.http.HttpHeader;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.http.HttpMethod;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.http.HttpVersion;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.io.Connection;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.io.EndPoint;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.MultiMap;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.QuotedStringTokenizer;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.UrlEncoded;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.component.LifeCycle;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.log.Log;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.log.Logger;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.api.Session;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.api.UpgradeException;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.api.UpgradeRequest;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.api.extensions.ExtensionConfig;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.api.extensions.ExtensionFactory;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.api.extensions.IncomingFrames;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.api.extensions.OutgoingFrames;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.client.ClientUpgradeResponse;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.client.WebSocketClient;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.client.io.UpgradeListener;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.client.io.WebSocketClientConnection;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.common.AcceptHash;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.common.SessionFactory;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.common.WebSocketSession;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.common.events.EventDriver;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.common.extensions.ExtensionStack;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeoutException;

public class WebSocketUpgradeRequest
extends HttpRequest
implements Response.CompleteListener,
HttpConnectionUpgrader {
    private static final Logger LOG = Log.getLogger(WebSocketUpgradeRequest.class);
    private final WebSocketClient wsClient;
    private final EventDriver localEndpoint;
    private final CompletableFuture<Session> fut;
    private final ClientUpgradeRequestFacade apiRequestFacade = new ClientUpgradeRequestFacade();
    private UpgradeListener upgradeListener;

    public WebSocketUpgradeRequest(WebSocketClient webSocketClient, HttpClient httpClient, URI uRI, Object object) {
        super(httpClient, new HttpConversation(), uRI);
        if (!uRI.isAbsolute()) {
            throw new IllegalArgumentException("WebSocket URI must be an absolute URI: " + uRI);
        }
        String string = uRI.getScheme();
        if (string == null || !string.equalsIgnoreCase("ws") && !string.equalsIgnoreCase("wss")) {
            throw new IllegalArgumentException("WebSocket URI must use 'ws' or 'wss' scheme: " + uRI);
        }
        this.wsClient = webSocketClient;
        try {
            if (!this.wsClient.isRunning()) {
                this.wsClient.start();
            }
        }
        catch (Exception exception) {
            throw new IllegalStateException("Unable to start WebSocketClient", exception);
        }
        this.localEndpoint = this.wsClient.getEventDriverFactory().wrap(object);
        this.fut = new CompletableFuture();
        this.fut.whenComplete((session, throwable) -> {
            if (throwable != null) {
                this.abort((Throwable)throwable);
            }
        });
        this.getConversation().setAttribute(HttpConnectionUpgrader.class.getName(), this);
    }

    private String genRandomKey() {
        byte[] byArray = new byte[16];
        ThreadLocalRandom.current().nextBytes(byArray);
        return Base64.getEncoder().encodeToString(byArray);
    }

    private ExtensionFactory getExtensionFactory() {
        return this.wsClient.getExtensionFactory();
    }

    private SessionFactory getSessionFactory() {
        return this.wsClient.getSessionFactory();
    }

    private void initWebSocketHeaders() {
        this.method(HttpMethod.GET);
        this.version(HttpVersion.HTTP_1_1);
        this.header(HttpHeader.UPGRADE, "websocket");
        this.header(HttpHeader.CONNECTION, "Upgrade");
        this.header(HttpHeader.SEC_WEBSOCKET_KEY, this.genRandomKey());
        this.header(HttpHeader.SEC_WEBSOCKET_VERSION, "13");
        this.header(HttpHeader.PRAGMA, "no-cache");
        this.header(HttpHeader.CACHE_CONTROL, "no-cache");
        if (!this.apiRequestFacade.getExtensions().isEmpty()) {
            for (ExtensionConfig object : this.apiRequestFacade.getExtensions()) {
                this.header(HttpHeader.SEC_WEBSOCKET_EXTENSIONS, object.getParameterizedName());
            }
        }
        if (!this.apiRequestFacade.getSubProtocols().isEmpty()) {
            for (String string : this.apiRequestFacade.getSubProtocols()) {
                this.header(HttpHeader.SEC_WEBSOCKET_SUBPROTOCOL, string);
            }
        }
        if (this.upgradeListener != null) {
            this.upgradeListener.onHandshakeRequest(this.apiRequestFacade);
        }
    }

    @Override
    public void onComplete(Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onComplete() - {}", result);
        }
        URI uRI = result.getRequest().getURI();
        Response response = result.getResponse();
        int n2 = response.getStatus();
        String string = n2 + " " + response.getReason();
        if (result.isFailed()) {
            Throwable throwable;
            if (LOG.isDebugEnabled()) {
                if (result.getFailure() != null) {
                    LOG.debug("General Failure", result.getFailure());
                }
                if (result.getRequestFailure() != null) {
                    LOG.debug("Request Failure", result.getRequestFailure());
                }
                if (result.getResponseFailure() != null) {
                    LOG.debug("Response Failure", result.getResponseFailure());
                }
            }
            if ((throwable = result.getFailure()) instanceof IOException || throwable instanceof UpgradeException) {
                this.handleException(throwable);
            } else {
                this.handleException(new UpgradeException(uRI, n2, string, throwable));
            }
            return;
        }
        if (n2 != 101) {
            this.handleException(new UpgradeException(uRI, n2, "Failed to upgrade to websocket: Unexpected HTTP Response Status Code: " + string));
        }
    }

    private void handleException(Throwable throwable) {
        try {
            this.localEndpoint.onError(throwable);
        }
        catch (Throwable throwable2) {
            LOG.warn("Exception while notifying onError", throwable2);
        }
        this.fut.completeExceptionally(throwable);
    }

    @Override
    public ContentResponse send() throws InterruptedException, TimeoutException, ExecutionException {
        throw new RuntimeException("Working with raw ContentResponse is invalid for WebSocket");
    }

    @Override
    public void send(Response.CompleteListener completeListener) {
        this.initWebSocketHeaders();
        super.send(completeListener);
    }

    public CompletableFuture<Session> sendAsync() {
        this.send(this);
        return this.fut;
    }

    @Override
    public void upgrade(HttpResponse httpResponse, HttpConnectionOverHTTP httpConnectionOverHTTP) {
        Object object;
        String string;
        if (!this.getHeaders().get(HttpHeader.UPGRADE).equalsIgnoreCase("websocket")) {
            throw new HttpResponseException("Not WebSocket Upgrade", httpResponse);
        }
        String string2 = this.getHeaders().get(HttpHeader.SEC_WEBSOCKET_KEY);
        String string3 = AcceptHash.hashKey(string2);
        if (!string3.equalsIgnoreCase(string = httpResponse.getHeaders().get(HttpHeader.SEC_WEBSOCKET_ACCEPT))) {
            throw new HttpResponseException("Invalid Sec-WebSocket-Accept hash", httpResponse);
        }
        EndPoint endPoint = httpConnectionOverHTTP.getEndPoint();
        WebSocketClientConnection webSocketClientConnection = new WebSocketClientConnection(endPoint, this.wsClient.getExecutor(), this.wsClient.getScheduler(), this.localEndpoint.getPolicy(), this.wsClient.getBufferPool());
        Collection<Connection.Listener> collection = this.wsClient.getBeans(Connection.Listener.class);
        if (collection != null) {
            collection.forEach(listener -> {
                if (!(listener instanceof WebSocketSession)) {
                    webSocketClientConnection.addListener((Connection.Listener)listener);
                }
            });
        }
        URI uRI = this.getURI();
        ClientUpgradeResponse clientUpgradeResponse = new ClientUpgradeResponse(httpResponse);
        WebSocketSession webSocketSession = this.getSessionFactory().createSession(uRI, this.localEndpoint, webSocketClientConnection);
        webSocketSession.setUpgradeRequest(new ClientUpgradeRequest(this));
        webSocketSession.setUpgradeResponse(clientUpgradeResponse);
        webSocketClientConnection.addListener(webSocketSession);
        ArrayList<ExtensionConfig> arrayList = new ArrayList<ExtensionConfig>();
        HttpField httpField = httpResponse.getHeaders().getField(HttpHeader.SEC_WEBSOCKET_EXTENSIONS);
        if (httpField != null && (object = httpField.getValues()) != null) {
            for (String string4 : object) {
                QuotedStringTokenizer quotedStringTokenizer = new QuotedStringTokenizer(string4, ",");
                while (quotedStringTokenizer.hasMoreTokens()) {
                    arrayList.add(ExtensionConfig.parse(quotedStringTokenizer.nextToken()));
                }
            }
        }
        object = new ExtensionStack(this.getExtensionFactory());
        ((ExtensionStack)object).negotiate(arrayList);
        ((ExtensionStack)object).configure(webSocketClientConnection.getParser());
        ((ExtensionStack)object).configure(webSocketClientConnection.getGenerator());
        webSocketClientConnection.setNextIncomingFrames((IncomingFrames)object);
        ((ExtensionStack)object).setNextIncoming(webSocketSession);
        webSocketSession.setOutgoingHandler((OutgoingFrames)object);
        ((ExtensionStack)object).setNextOutgoing(webSocketClientConnection);
        webSocketSession.addManaged((LifeCycle)object);
        webSocketSession.setFuture(this.fut);
        if (this.upgradeListener != null) {
            this.upgradeListener.onHandshakeResponse(clientUpgradeResponse);
        }
        endPoint.upgrade(webSocketClientConnection);
    }

    private HttpFields getHttpFields() {
        return super.getHeaders();
    }

    private class ClientUpgradeRequestFacade
    implements UpgradeRequest {
        private List<ExtensionConfig> extensions = new ArrayList<ExtensionConfig>();
        private List<String> subProtocols = new ArrayList<String>();

        public List<ExtensionConfig> getExtensions() {
            return this.extensions;
        }

        public List<String> getSubProtocols() {
            return this.subProtocols;
        }

        @Override
        public Map<String, List<String>> getParameterMap() {
            TreeMap<String, List<String>> treeMap = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
            String string = this.getQueryString();
            MultiMap<String> multiMap = new MultiMap<String>();
            UrlEncoded.decodeTo(string, multiMap, StandardCharsets.UTF_8);
            treeMap.putAll(multiMap);
            return treeMap;
        }

        @Override
        public String getProtocolVersion() {
            String string = WebSocketUpgradeRequest.this.getHttpFields().get(HttpHeader.SEC_WEBSOCKET_VERSION);
            if (string == null) {
                return Integer.toString(13);
            }
            return string;
        }

        public String getQueryString() {
            return WebSocketUpgradeRequest.this.getURI().getQuery();
        }
    }
}

