/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.deser.std;

import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.annotation.JsonFormat;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.annotation.Nulls;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonParser;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonToken;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.StreamReadCapability;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.StreamReadFeature;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.exc.StreamReadException;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.io.NumberInput;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.BeanProperty;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.DeserializationContext;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.DeserializationFeature;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.JavaType;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.JsonDeserializer;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.JsonMappingException;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.KeyDeserializer;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.MapperFeature;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.PropertyMetadata;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.cfg.CoercionAction;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.cfg.CoercionInputShape;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.deser.BeanDeserializerBase;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.deser.NullValueProvider;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.deser.impl.NullsAsEmptyProvider;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.deser.impl.NullsConstantProvider;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.deser.impl.NullsFailProvider;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.deser.std.StdDelegatingDeserializer;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.type.LogicalType;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.util.AccessPattern;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.util.ClassUtil;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.util.Converter;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.Map;

public abstract class StdDeserializer<T>
extends JsonDeserializer<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final int F_MASK_INT_COERCIONS = DeserializationFeature.USE_BIG_INTEGER_FOR_INTS.getMask() | DeserializationFeature.USE_LONG_FOR_INTS.getMask();
    @Deprecated
    protected static final int F_MASK_ACCEPT_ARRAYS = DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS.getMask() | DeserializationFeature.ACCEPT_EMPTY_ARRAY_AS_NULL_OBJECT.getMask();
    protected final Class<?> _valueClass;
    protected final JavaType _valueType;

    protected StdDeserializer(Class<?> clazz) {
        this._valueClass = clazz;
        this._valueType = null;
    }

    protected StdDeserializer(JavaType javaType) {
        this._valueClass = javaType == null ? Object.class : javaType.getRawClass();
        this._valueType = javaType;
    }

    protected StdDeserializer(StdDeserializer<?> stdDeserializer) {
        this._valueClass = stdDeserializer._valueClass;
        this._valueType = stdDeserializer._valueType;
    }

    @Override
    public Class<?> handledType() {
        return this._valueClass;
    }

    @Deprecated
    public final Class<?> getValueClass() {
        return this._valueClass;
    }

    public JavaType getValueType() {
        return this._valueType;
    }

    public JavaType getValueType(DeserializationContext deserializationContext) {
        if (this._valueType != null) {
            return this._valueType;
        }
        return deserializationContext.constructType(this._valueClass);
    }

    public ValueInstantiator getValueInstantiator() {
        return null;
    }

    protected boolean isDefaultDeserializer(JsonDeserializer<?> jsonDeserializer) {
        return ClassUtil.isJacksonStdImpl(jsonDeserializer);
    }

    protected boolean isDefaultKeyDeserializer(KeyDeserializer keyDeserializer) {
        return ClassUtil.isJacksonStdImpl(keyDeserializer);
    }

    @Override
    public Object deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) throws IOException {
        return typeDeserializer.deserializeTypedFromAny(jsonParser, deserializationContext);
    }

    protected T _deserializeFromArray(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        CoercionAction coercionAction = this._findCoercionFromEmptyArray(deserializationContext);
        boolean bl2 = deserializationContext.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS);
        if (bl2 || coercionAction != CoercionAction.Fail) {
            JsonToken jsonToken = jsonParser.nextToken();
            if (jsonToken == JsonToken.END_ARRAY) {
                switch (coercionAction) {
                    case AsEmpty: {
                        return (T)this.getEmptyValue(deserializationContext);
                    }
                    case AsNull: 
                    case TryConvert: {
                        return this.getNullValue(deserializationContext);
                    }
                }
            } else if (bl2) {
                T t2 = this._deserializeWrappedValue(jsonParser, deserializationContext);
                if (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                    this.handleMissingEndArrayForSingle(jsonParser, deserializationContext);
                }
                return t2;
            }
        }
        return (T)deserializationContext.handleUnexpectedToken(this.getValueType(deserializationContext), JsonToken.START_ARRAY, jsonParser, null, new Object[0]);
    }

    @Deprecated
    protected T _deserializeFromEmpty(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        if (jsonParser.hasToken(JsonToken.START_ARRAY) && deserializationContext.isEnabled(DeserializationFeature.ACCEPT_EMPTY_ARRAY_AS_NULL_OBJECT)) {
            JsonToken jsonToken = jsonParser.nextToken();
            if (jsonToken == JsonToken.END_ARRAY) {
                return null;
            }
            return (T)deserializationContext.handleUnexpectedToken(this.getValueType(deserializationContext), jsonParser);
        }
        return (T)deserializationContext.handleUnexpectedToken(this.getValueType(deserializationContext), jsonParser);
    }

    protected T _deserializeFromString(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        ValueInstantiator valueInstantiator = this.getValueInstantiator();
        Class<?> clazz = this.handledType();
        String string = jsonParser.getValueAsString();
        if (valueInstantiator != null && valueInstantiator.canCreateFromString()) {
            return (T)valueInstantiator.createFromString(deserializationContext, string);
        }
        if (string.isEmpty()) {
            CoercionAction coercionAction = deserializationContext.findCoercionAction(this.logicalType(), clazz, CoercionInputShape.EmptyString);
            return (T)this._deserializeFromEmptyString(jsonParser, deserializationContext, coercionAction, clazz, "empty String (\"\")");
        }
        if (StdDeserializer._isBlank(string)) {
            CoercionAction coercionAction = deserializationContext.findCoercionFromBlankString(this.logicalType(), clazz, CoercionAction.Fail);
            return (T)this._deserializeFromEmptyString(jsonParser, deserializationContext, coercionAction, clazz, "blank String (all whitespace)");
        }
        if (valueInstantiator != null) {
            string = string.trim();
            if (valueInstantiator.canCreateFromInt() && deserializationContext.findCoercionAction(LogicalType.Integer, Integer.class, CoercionInputShape.String) == CoercionAction.TryConvert) {
                return (T)valueInstantiator.createFromInt(deserializationContext, this._parseIntPrimitive(deserializationContext, string));
            }
            if (valueInstantiator.canCreateFromLong() && deserializationContext.findCoercionAction(LogicalType.Integer, Long.class, CoercionInputShape.String) == CoercionAction.TryConvert) {
                return (T)valueInstantiator.createFromLong(deserializationContext, this._parseLongPrimitive(deserializationContext, string));
            }
            if (valueInstantiator.canCreateFromBoolean() && deserializationContext.findCoercionAction(LogicalType.Boolean, Boolean.class, CoercionInputShape.String) == CoercionAction.TryConvert) {
                String string2 = string.trim();
                if ("true".equals(string2)) {
                    return (T)valueInstantiator.createFromBoolean(deserializationContext, true);
                }
                if ("false".equals(string2)) {
                    return (T)valueInstantiator.createFromBoolean(deserializationContext, false);
                }
            }
        }
        return (T)deserializationContext.handleMissingInstantiator(clazz, valueInstantiator, deserializationContext.getParser(), "no String-argument constructor/factory method to deserialize from String value ('%s')", string);
    }

    protected Object _deserializeFromEmptyString(JsonParser jsonParser, DeserializationContext deserializationContext, CoercionAction coercionAction, Class<?> clazz, String string) throws IOException {
        switch (coercionAction) {
            case AsEmpty: {
                return this.getEmptyValue(deserializationContext);
            }
            case Fail: {
                this._checkCoercionFail(deserializationContext, coercionAction, clazz, "", "empty String (\"\")");
            }
        }
        return null;
    }

    protected T _deserializeWrappedValue(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        if (jsonParser.hasToken(JsonToken.START_ARRAY)) {
            Object object = this.handleNestedArrayForSingle(jsonParser, deserializationContext);
            return (T)object;
        }
        return this.deserialize(jsonParser, deserializationContext);
    }

    @Deprecated
    protected final boolean _parseBooleanPrimitive(DeserializationContext deserializationContext, JsonParser jsonParser, Class<?> clazz) throws IOException {
        return this._parseBooleanPrimitive(jsonParser, deserializationContext);
    }

    protected final boolean _parseBooleanPrimitive(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        String string;
        switch (jsonParser.currentTokenId()) {
            case 6: {
                string = jsonParser.getText();
                break;
            }
            case 7: {
                return Boolean.TRUE.equals(this._coerceBooleanFromInt(jsonParser, deserializationContext, Boolean.TYPE));
            }
            case 9: {
                return true;
            }
            case 10: {
                return false;
            }
            case 11: {
                this._verifyNullForPrimitive(deserializationContext);
                return false;
            }
            case 1: {
                string = deserializationContext.extractScalarFromObject(jsonParser, this, Boolean.TYPE);
                break;
            }
            case 3: {
                if (deserializationContext.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
                    if (jsonParser.nextToken() == JsonToken.START_ARRAY) {
                        return (Boolean)this.handleNestedArrayForSingle(jsonParser, deserializationContext);
                    }
                    boolean bl2 = this._parseBooleanPrimitive(jsonParser, deserializationContext);
                    this._verifyEndArrayForSingle(jsonParser, deserializationContext);
                    return bl2;
                }
            }
            default: {
                return (Boolean)deserializationContext.handleUnexpectedToken(Boolean.TYPE, jsonParser);
            }
        }
        CoercionAction coercionAction = this._checkFromStringCoercion(deserializationContext, string, LogicalType.Boolean, Boolean.TYPE);
        if (coercionAction == CoercionAction.AsNull) {
            this._verifyNullForPrimitive(deserializationContext);
            return false;
        }
        if (coercionAction == CoercionAction.AsEmpty) {
            return false;
        }
        int n2 = (string = string.trim()).length();
        if (n2 == 4) {
            if (this._isTrue(string)) {
                return true;
            }
        } else if (n2 == 5 && this._isFalse(string)) {
            return false;
        }
        if (this._hasTextualNull(string)) {
            this._verifyNullForPrimitiveCoercion(deserializationContext, string);
            return false;
        }
        Boolean bl3 = (Boolean)deserializationContext.handleWeirdStringValue(Boolean.TYPE, string, "only \"true\"/\"True\"/\"TRUE\" or \"false\"/\"False\"/\"FALSE\" recognized", new Object[0]);
        return Boolean.TRUE.equals(bl3);
    }

    protected boolean _isTrue(String string) {
        char c2 = string.charAt(0);
        if (c2 == 't') {
            return "true".equals(string);
        }
        if (c2 == 'T') {
            return "TRUE".equals(string) || "True".equals(string);
        }
        return false;
    }

    protected boolean _isFalse(String string) {
        char c2 = string.charAt(0);
        if (c2 == 'f') {
            return "false".equals(string);
        }
        if (c2 == 'F') {
            return "FALSE".equals(string) || "False".equals(string);
        }
        return false;
    }

    protected final Boolean _parseBoolean(JsonParser jsonParser, DeserializationContext deserializationContext, Class<?> clazz) throws IOException {
        String string;
        switch (jsonParser.currentTokenId()) {
            case 6: {
                string = jsonParser.getText();
                break;
            }
            case 7: {
                return this._coerceBooleanFromInt(jsonParser, deserializationContext, clazz);
            }
            case 9: {
                return true;
            }
            case 10: {
                return false;
            }
            case 11: {
                return null;
            }
            case 1: {
                string = deserializationContext.extractScalarFromObject(jsonParser, this, clazz);
                break;
            }
            case 3: {
                return (Boolean)this._deserializeFromArray(jsonParser, deserializationContext);
            }
            default: {
                return (Boolean)deserializationContext.handleUnexpectedToken(clazz, jsonParser);
            }
        }
        CoercionAction coercionAction = this._checkFromStringCoercion(deserializationContext, string, LogicalType.Boolean, clazz);
        if (coercionAction == CoercionAction.AsNull) {
            return null;
        }
        if (coercionAction == CoercionAction.AsEmpty) {
            return false;
        }
        int n2 = (string = string.trim()).length();
        if (n2 == 4) {
            if (this._isTrue(string)) {
                return true;
            }
        } else if (n2 == 5 && this._isFalse(string)) {
            return false;
        }
        if (this._checkTextualNull(deserializationContext, string)) {
            return null;
        }
        return (Boolean)deserializationContext.handleWeirdStringValue(clazz, string, "only \"true\" or \"false\" recognized", new Object[0]);
    }

    protected final byte _parseBytePrimitive(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        int n2;
        String string;
        switch (jsonParser.currentTokenId()) {
            case 6: {
                string = jsonParser.getText();
                break;
            }
            case 8: {
                CoercionAction coercionAction = this._checkFloatToIntCoercion(jsonParser, deserializationContext, Byte.TYPE);
                if (coercionAction == CoercionAction.AsNull) {
                    return 0;
                }
                if (coercionAction == CoercionAction.AsEmpty) {
                    return 0;
                }
                return jsonParser.getByteValue();
            }
            case 7: {
                return jsonParser.getByteValue();
            }
            case 11: {
                this._verifyNullForPrimitive(deserializationContext);
                return 0;
            }
            case 1: {
                string = deserializationContext.extractScalarFromObject(jsonParser, this, Byte.TYPE);
                break;
            }
            case 3: {
                if (deserializationContext.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
                    if (jsonParser.nextToken() == JsonToken.START_ARRAY) {
                        return (Byte)this.handleNestedArrayForSingle(jsonParser, deserializationContext);
                    }
                    byte by2 = this._parseBytePrimitive(jsonParser, deserializationContext);
                    this._verifyEndArrayForSingle(jsonParser, deserializationContext);
                    return by2;
                }
            }
            default: {
                return (Byte)deserializationContext.handleUnexpectedToken(deserializationContext.constructType(Byte.TYPE), jsonParser);
            }
        }
        CoercionAction coercionAction = this._checkFromStringCoercion(deserializationContext, string, LogicalType.Integer, Byte.TYPE);
        if (coercionAction == CoercionAction.AsNull) {
            this._verifyNullForPrimitive(deserializationContext);
            return 0;
        }
        if (coercionAction == CoercionAction.AsEmpty) {
            return 0;
        }
        if (this._hasTextualNull(string = string.trim())) {
            this._verifyNullForPrimitiveCoercion(deserializationContext, string);
            return 0;
        }
        try {
            n2 = NumberInput.parseInt(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return (Byte)deserializationContext.handleWeirdStringValue(this._valueClass, string, "not a valid `byte` value", new Object[0]);
        }
        if (this._byteOverflow(n2)) {
            return (Byte)deserializationContext.handleWeirdStringValue(this._valueClass, string, "overflow, value cannot be represented as 8-bit value", new Object[0]);
        }
        return (byte)n2;
    }

    protected final short _parseShortPrimitive(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        int n2;
        String string;
        switch (jsonParser.currentTokenId()) {
            case 6: {
                string = jsonParser.getText();
                break;
            }
            case 8: {
                CoercionAction coercionAction = this._checkFloatToIntCoercion(jsonParser, deserializationContext, Short.TYPE);
                if (coercionAction == CoercionAction.AsNull) {
                    return 0;
                }
                if (coercionAction == CoercionAction.AsEmpty) {
                    return 0;
                }
                return jsonParser.getShortValue();
            }
            case 7: {
                return jsonParser.getShortValue();
            }
            case 11: {
                this._verifyNullForPrimitive(deserializationContext);
                return 0;
            }
            case 1: {
                string = deserializationContext.extractScalarFromObject(jsonParser, this, Short.TYPE);
                break;
            }
            case 3: {
                if (deserializationContext.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
                    if (jsonParser.nextToken() == JsonToken.START_ARRAY) {
                        return (Short)this.handleNestedArrayForSingle(jsonParser, deserializationContext);
                    }
                    short s2 = this._parseShortPrimitive(jsonParser, deserializationContext);
                    this._verifyEndArrayForSingle(jsonParser, deserializationContext);
                    return s2;
                }
            }
            default: {
                return (Short)deserializationContext.handleUnexpectedToken(deserializationContext.constructType(Short.TYPE), jsonParser);
            }
        }
        CoercionAction coercionAction = this._checkFromStringCoercion(deserializationContext, string, LogicalType.Integer, Short.TYPE);
        if (coercionAction == CoercionAction.AsNull) {
            this._verifyNullForPrimitive(deserializationContext);
            return 0;
        }
        if (coercionAction == CoercionAction.AsEmpty) {
            return 0;
        }
        if (this._hasTextualNull(string = string.trim())) {
            this._verifyNullForPrimitiveCoercion(deserializationContext, string);
            return 0;
        }
        try {
            n2 = NumberInput.parseInt(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return (Short)deserializationContext.handleWeirdStringValue(Short.TYPE, string, "not a valid `short` value", new Object[0]);
        }
        if (this._shortOverflow(n2)) {
            return (Short)deserializationContext.handleWeirdStringValue(Short.TYPE, string, "overflow, value cannot be represented as 16-bit value", new Object[0]);
        }
        return (short)n2;
    }

    protected final int _parseIntPrimitive(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        String string;
        switch (jsonParser.currentTokenId()) {
            case 6: {
                string = jsonParser.getText();
                break;
            }
            case 8: {
                CoercionAction coercionAction = this._checkFloatToIntCoercion(jsonParser, deserializationContext, Integer.TYPE);
                if (coercionAction == CoercionAction.AsNull) {
                    return 0;
                }
                if (coercionAction == CoercionAction.AsEmpty) {
                    return 0;
                }
                return jsonParser.getValueAsInt();
            }
            case 7: {
                return jsonParser.getIntValue();
            }
            case 11: {
                this._verifyNullForPrimitive(deserializationContext);
                return 0;
            }
            case 1: {
                string = deserializationContext.extractScalarFromObject(jsonParser, this, Integer.TYPE);
                break;
            }
            case 3: {
                if (deserializationContext.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
                    if (jsonParser.nextToken() == JsonToken.START_ARRAY) {
                        return (Integer)this.handleNestedArrayForSingle(jsonParser, deserializationContext);
                    }
                    int n2 = this._parseIntPrimitive(jsonParser, deserializationContext);
                    this._verifyEndArrayForSingle(jsonParser, deserializationContext);
                    return n2;
                }
            }
            default: {
                return ((Number)deserializationContext.handleUnexpectedToken(Integer.TYPE, jsonParser)).intValue();
            }
        }
        CoercionAction coercionAction = this._checkFromStringCoercion(deserializationContext, string, LogicalType.Integer, Integer.TYPE);
        if (coercionAction == CoercionAction.AsNull) {
            this._verifyNullForPrimitive(deserializationContext);
            return 0;
        }
        if (coercionAction == CoercionAction.AsEmpty) {
            return 0;
        }
        if (this._hasTextualNull(string = string.trim())) {
            this._verifyNullForPrimitiveCoercion(deserializationContext, string);
            return 0;
        }
        return this._parseIntPrimitive(deserializationContext, string);
    }

    protected final int _parseIntPrimitive(DeserializationContext deserializationContext, String string) throws IOException {
        try {
            if (string.length() > 9) {
                long l2 = NumberInput.parseLong(string);
                if (this._intOverflow(l2)) {
                    Number number = (Number)deserializationContext.handleWeirdStringValue(Integer.TYPE, string, "Overflow: numeric value (%s) out of range of int (%d -%d)", string, Integer.MIN_VALUE, Integer.MAX_VALUE);
                    return this._nonNullNumber(number).intValue();
                }
                return (int)l2;
            }
            return NumberInput.parseInt(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Number number = (Number)deserializationContext.handleWeirdStringValue(Integer.TYPE, string, "not a valid `int` value", new Object[0]);
            return this._nonNullNumber(number).intValue();
        }
    }

    protected final Integer _parseInteger(JsonParser jsonParser, DeserializationContext deserializationContext, Class<?> clazz) throws IOException {
        String string;
        switch (jsonParser.currentTokenId()) {
            case 6: {
                string = jsonParser.getText();
                break;
            }
            case 8: {
                CoercionAction coercionAction = this._checkFloatToIntCoercion(jsonParser, deserializationContext, clazz);
                if (coercionAction == CoercionAction.AsNull) {
                    return (Integer)this.getNullValue(deserializationContext);
                }
                if (coercionAction == CoercionAction.AsEmpty) {
                    return (Integer)this.getEmptyValue(deserializationContext);
                }
                return jsonParser.getValueAsInt();
            }
            case 7: {
                return jsonParser.getIntValue();
            }
            case 11: {
                return (Integer)this.getNullValue(deserializationContext);
            }
            case 1: {
                string = deserializationContext.extractScalarFromObject(jsonParser, this, clazz);
                break;
            }
            case 3: {
                return (Integer)this._deserializeFromArray(jsonParser, deserializationContext);
            }
            default: {
                return (Integer)deserializationContext.handleUnexpectedToken(this.getValueType(deserializationContext), jsonParser);
            }
        }
        CoercionAction coercionAction = this._checkFromStringCoercion(deserializationContext, string);
        if (coercionAction == CoercionAction.AsNull) {
            return (Integer)this.getNullValue(deserializationContext);
        }
        if (coercionAction == CoercionAction.AsEmpty) {
            return (Integer)this.getEmptyValue(deserializationContext);
        }
        if (this._checkTextualNull(deserializationContext, string = string.trim())) {
            return (Integer)this.getNullValue(deserializationContext);
        }
        return this._parseInteger(deserializationContext, string);
    }

    protected final Integer _parseInteger(DeserializationContext deserializationContext, String string) throws IOException {
        try {
            if (string.length() > 9) {
                long l2 = NumberInput.parseLong(string);
                if (this._intOverflow(l2)) {
                    return (Integer)deserializationContext.handleWeirdStringValue(Integer.class, string, "Overflow: numeric value (%s) out of range of `java.lang.Integer` (%d -%d)", string, Integer.MIN_VALUE, Integer.MAX_VALUE);
                }
                return (int)l2;
            }
            return NumberInput.parseInt(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return (Integer)deserializationContext.handleWeirdStringValue(Integer.class, string, "not a valid `java.lang.Integer` value", new Object[0]);
        }
    }

    protected final long _parseLongPrimitive(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        String string;
        switch (jsonParser.currentTokenId()) {
            case 6: {
                string = jsonParser.getText();
                break;
            }
            case 8: {
                CoercionAction coercionAction = this._checkFloatToIntCoercion(jsonParser, deserializationContext, Long.TYPE);
                if (coercionAction == CoercionAction.AsNull) {
                    return 0L;
                }
                if (coercionAction == CoercionAction.AsEmpty) {
                    return 0L;
                }
                return jsonParser.getValueAsLong();
            }
            case 7: {
                return jsonParser.getLongValue();
            }
            case 11: {
                this._verifyNullForPrimitive(deserializationContext);
                return 0L;
            }
            case 1: {
                string = deserializationContext.extractScalarFromObject(jsonParser, this, Long.TYPE);
                break;
            }
            case 3: {
                if (deserializationContext.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
                    if (jsonParser.nextToken() == JsonToken.START_ARRAY) {
                        return (Long)this.handleNestedArrayForSingle(jsonParser, deserializationContext);
                    }
                    long l2 = this._parseLongPrimitive(jsonParser, deserializationContext);
                    this._verifyEndArrayForSingle(jsonParser, deserializationContext);
                    return l2;
                }
            }
            default: {
                return ((Number)deserializationContext.handleUnexpectedToken(Long.TYPE, jsonParser)).longValue();
            }
        }
        CoercionAction coercionAction = this._checkFromStringCoercion(deserializationContext, string, LogicalType.Integer, Long.TYPE);
        if (coercionAction == CoercionAction.AsNull) {
            this._verifyNullForPrimitive(deserializationContext);
            return 0L;
        }
        if (coercionAction == CoercionAction.AsEmpty) {
            return 0L;
        }
        if (this._hasTextualNull(string = string.trim())) {
            this._verifyNullForPrimitiveCoercion(deserializationContext, string);
            return 0L;
        }
        return this._parseLongPrimitive(deserializationContext, string);
    }

    protected final long _parseLongPrimitive(DeserializationContext deserializationContext, String string) throws IOException {
        try {
            return NumberInput.parseLong(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Number number = (Number)deserializationContext.handleWeirdStringValue(Long.TYPE, string, "not a valid `long` value", new Object[0]);
            return this._nonNullNumber(number).longValue();
        }
    }

    protected final Long _parseLong(JsonParser jsonParser, DeserializationContext deserializationContext, Class<?> clazz) throws IOException {
        String string;
        switch (jsonParser.currentTokenId()) {
            case 6: {
                string = jsonParser.getText();
                break;
            }
            case 8: {
                CoercionAction coercionAction = this._checkFloatToIntCoercion(jsonParser, deserializationContext, clazz);
                if (coercionAction == CoercionAction.AsNull) {
                    return (Long)this.getNullValue(deserializationContext);
                }
                if (coercionAction == CoercionAction.AsEmpty) {
                    return (Long)this.getEmptyValue(deserializationContext);
                }
                return jsonParser.getValueAsLong();
            }
            case 11: {
                return (Long)this.getNullValue(deserializationContext);
            }
            case 7: {
                return jsonParser.getLongValue();
            }
            case 1: {
                string = deserializationContext.extractScalarFromObject(jsonParser, this, clazz);
                break;
            }
            case 3: {
                return (Long)this._deserializeFromArray(jsonParser, deserializationContext);
            }
            default: {
                return (Long)deserializationContext.handleUnexpectedToken(this.getValueType(deserializationContext), jsonParser);
            }
        }
        CoercionAction coercionAction = this._checkFromStringCoercion(deserializationContext, string);
        if (coercionAction == CoercionAction.AsNull) {
            return (Long)this.getNullValue(deserializationContext);
        }
        if (coercionAction == CoercionAction.AsEmpty) {
            return (Long)this.getEmptyValue(deserializationContext);
        }
        if (this._checkTextualNull(deserializationContext, string = string.trim())) {
            return (Long)this.getNullValue(deserializationContext);
        }
        return this._parseLong(deserializationContext, string);
    }

    protected final Long _parseLong(DeserializationContext deserializationContext, String string) throws IOException {
        try {
            return NumberInput.parseLong(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return (Long)deserializationContext.handleWeirdStringValue(Long.class, string, "not a valid `java.lang.Long` value", new Object[0]);
        }
    }

    protected final float _parseFloatPrimitive(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        String string;
        switch (jsonParser.currentTokenId()) {
            case 6: {
                string = jsonParser.getText();
                break;
            }
            case 7: {
                CoercionAction coercionAction = this._checkIntToFloatCoercion(jsonParser, deserializationContext, Float.TYPE);
                if (coercionAction == CoercionAction.AsNull) {
                    return 0.0f;
                }
                if (coercionAction == CoercionAction.AsEmpty) {
                    return 0.0f;
                }
            }
            case 8: {
                return jsonParser.getFloatValue();
            }
            case 11: {
                this._verifyNullForPrimitive(deserializationContext);
                return 0.0f;
            }
            case 1: {
                string = deserializationContext.extractScalarFromObject(jsonParser, this, Float.TYPE);
                break;
            }
            case 3: {
                if (deserializationContext.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
                    if (jsonParser.nextToken() == JsonToken.START_ARRAY) {
                        return ((Float)this.handleNestedArrayForSingle(jsonParser, deserializationContext)).floatValue();
                    }
                    float f2 = this._parseFloatPrimitive(jsonParser, deserializationContext);
                    this._verifyEndArrayForSingle(jsonParser, deserializationContext);
                    return f2;
                }
            }
            default: {
                return ((Number)deserializationContext.handleUnexpectedToken(Float.TYPE, jsonParser)).floatValue();
            }
        }
        Object object = this._checkFloatSpecialValue(string);
        if (object != null) {
            return object.floatValue();
        }
        object = this._checkFromStringCoercion(deserializationContext, string, LogicalType.Integer, Float.TYPE);
        if (object == CoercionAction.AsNull) {
            this._verifyNullForPrimitive(deserializationContext);
            return 0.0f;
        }
        if (object == CoercionAction.AsEmpty) {
            return 0.0f;
        }
        if (this._hasTextualNull(string = string.trim())) {
            this._verifyNullForPrimitiveCoercion(deserializationContext, string);
            return 0.0f;
        }
        return this._parseFloatPrimitive(jsonParser, deserializationContext, string);
    }

    protected final float _parseFloatPrimitive(DeserializationContext deserializationContext, String string) throws IOException {
        try {
            return NumberInput.parseFloat(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Number number = (Number)deserializationContext.handleWeirdStringValue(Float.TYPE, string, "not a valid `float` value", new Object[0]);
            return this._nonNullNumber(number).floatValue();
        }
    }

    protected final float _parseFloatPrimitive(JsonParser jsonParser, DeserializationContext deserializationContext, String string) throws IOException {
        try {
            return NumberInput.parseFloat(string, jsonParser.isEnabled(StreamReadFeature.USE_FAST_DOUBLE_PARSER));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Number number = (Number)deserializationContext.handleWeirdStringValue(Float.TYPE, string, "not a valid `float` value", new Object[0]);
            return this._nonNullNumber(number).floatValue();
        }
    }

    protected Float _checkFloatSpecialValue(String string) {
        if (!string.isEmpty()) {
            switch (string.charAt(0)) {
                case 'I': {
                    if (!this._isPosInf(string)) break;
                    return Float.valueOf(Float.POSITIVE_INFINITY);
                }
                case 'N': {
                    if (!this._isNaN(string)) break;
                    return Float.valueOf(Float.NaN);
                }
                case '-': {
                    if (!this._isNegInf(string)) break;
                    return Float.valueOf(Float.NEGATIVE_INFINITY);
                }
            }
        }
        return null;
    }

    protected final double _parseDoublePrimitive(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        String string;
        switch (jsonParser.currentTokenId()) {
            case 6: {
                string = jsonParser.getText();
                break;
            }
            case 7: {
                CoercionAction coercionAction = this._checkIntToFloatCoercion(jsonParser, deserializationContext, Double.TYPE);
                if (coercionAction == CoercionAction.AsNull) {
                    return 0.0;
                }
                if (coercionAction == CoercionAction.AsEmpty) {
                    return 0.0;
                }
            }
            case 8: {
                return jsonParser.getDoubleValue();
            }
            case 11: {
                this._verifyNullForPrimitive(deserializationContext);
                return 0.0;
            }
            case 1: {
                string = deserializationContext.extractScalarFromObject(jsonParser, this, Double.TYPE);
                break;
            }
            case 3: {
                if (deserializationContext.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
                    if (jsonParser.nextToken() == JsonToken.START_ARRAY) {
                        return (Double)this.handleNestedArrayForSingle(jsonParser, deserializationContext);
                    }
                    double d2 = this._parseDoublePrimitive(jsonParser, deserializationContext);
                    this._verifyEndArrayForSingle(jsonParser, deserializationContext);
                    return d2;
                }
            }
            default: {
                return ((Number)deserializationContext.handleUnexpectedToken(Double.TYPE, jsonParser)).doubleValue();
            }
        }
        Object object = this._checkDoubleSpecialValue(string);
        if (object != null) {
            return object;
        }
        object = this._checkFromStringCoercion(deserializationContext, string, LogicalType.Integer, Double.TYPE);
        if (object == CoercionAction.AsNull) {
            this._verifyNullForPrimitive(deserializationContext);
            return 0.0;
        }
        if (object == CoercionAction.AsEmpty) {
            return 0.0;
        }
        if (this._hasTextualNull(string = string.trim())) {
            this._verifyNullForPrimitiveCoercion(deserializationContext, string);
            return 0.0;
        }
        return this._parseDoublePrimitive(jsonParser, deserializationContext, string);
    }

    protected final double _parseDoublePrimitive(DeserializationContext deserializationContext, String string) throws IOException {
        try {
            return StdDeserializer._parseDouble(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Number number = (Number)deserializationContext.handleWeirdStringValue(Double.TYPE, string, "not a valid `double` value (as String to convert)", new Object[0]);
            return this._nonNullNumber(number).doubleValue();
        }
    }

    protected final double _parseDoublePrimitive(JsonParser jsonParser, DeserializationContext deserializationContext, String string) throws IOException {
        try {
            return StdDeserializer._parseDouble(string, jsonParser.isEnabled(StreamReadFeature.USE_FAST_DOUBLE_PARSER));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Number number = (Number)deserializationContext.handleWeirdStringValue(Double.TYPE, string, "not a valid `double` value (as String to convert)", new Object[0]);
            return this._nonNullNumber(number).doubleValue();
        }
    }

    protected static final double _parseDouble(String string) throws NumberFormatException {
        return StdDeserializer._parseDouble(string, false);
    }

    protected static final double _parseDouble(String string, boolean bl2) throws NumberFormatException {
        return NumberInput.parseDouble(string, bl2);
    }

    protected Double _checkDoubleSpecialValue(String string) {
        if (!string.isEmpty()) {
            switch (string.charAt(0)) {
                case 'I': {
                    if (!this._isPosInf(string)) break;
                    return Double.POSITIVE_INFINITY;
                }
                case 'N': {
                    if (!this._isNaN(string)) break;
                    return Double.NaN;
                }
                case '-': {
                    if (!this._isNegInf(string)) break;
                    return Double.NEGATIVE_INFINITY;
                }
            }
        }
        return null;
    }

    protected Date _parseDate(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        String string;
        switch (jsonParser.currentTokenId()) {
            case 6: {
                string = jsonParser.getText();
                break;
            }
            case 7: {
                long l2;
                try {
                    l2 = jsonParser.getLongValue();
                }
                catch (StreamReadException streamReadException) {
                    Number number = (Number)deserializationContext.handleWeirdNumberValue(this._valueClass, jsonParser.getNumberValue(), "not a valid 64-bit `long` for creating `java.util.Date`", new Object[0]);
                    l2 = number.longValue();
                }
                return new Date(l2);
            }
            case 11: {
                return (Date)this.getNullValue(deserializationContext);
            }
            case 1: {
                string = deserializationContext.extractScalarFromObject(jsonParser, this, this._valueClass);
                break;
            }
            case 3: {
                return this._parseDateFromArray(jsonParser, deserializationContext);
            }
            default: {
                return (Date)deserializationContext.handleUnexpectedToken(this._valueClass, jsonParser);
            }
        }
        return this._parseDate(string.trim(), deserializationContext);
    }

    protected Date _parseDateFromArray(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        CoercionAction coercionAction = this._findCoercionFromEmptyArray(deserializationContext);
        boolean bl2 = deserializationContext.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS);
        if (bl2 || coercionAction != CoercionAction.Fail) {
            JsonToken jsonToken = jsonParser.nextToken();
            if (jsonToken == JsonToken.END_ARRAY) {
                switch (coercionAction) {
                    case AsEmpty: {
                        return (Date)this.getEmptyValue(deserializationContext);
                    }
                    case AsNull: 
                    case TryConvert: {
                        return (Date)this.getNullValue(deserializationContext);
                    }
                }
            } else if (bl2) {
                if (jsonToken == JsonToken.START_ARRAY) {
                    return (Date)this.handleNestedArrayForSingle(jsonParser, deserializationContext);
                }
                Date date = this._parseDate(jsonParser, deserializationContext);
                this._verifyEndArrayForSingle(jsonParser, deserializationContext);
                return date;
            }
        }
        return (Date)deserializationContext.handleUnexpectedToken(this._valueClass, JsonToken.START_ARRAY, jsonParser, null, new Object[0]);
    }

    protected Date _parseDate(String string, DeserializationContext deserializationContext) throws IOException {
        try {
            if (string.isEmpty()) {
                CoercionAction coercionAction = this._checkFromStringCoercion(deserializationContext, string);
                switch (coercionAction) {
                    case AsEmpty: {
                        return new Date(0L);
                    }
                }
                return null;
            }
            if (this._hasTextualNull(string)) {
                return null;
            }
            return deserializationContext.parseDate(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return (Date)deserializationContext.handleWeirdStringValue(this._valueClass, string, "not a valid representation (error: %s)", ClassUtil.exceptionMessage(illegalArgumentException));
        }
    }

    @Deprecated
    protected final String _parseString(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        return this._parseString(jsonParser, deserializationContext, NullsConstantProvider.nuller());
    }

    protected final String _parseString(JsonParser jsonParser, DeserializationContext deserializationContext, NullValueProvider nullValueProvider) throws IOException {
        String string;
        CoercionAction coercionAction = CoercionAction.TryConvert;
        switch (jsonParser.currentTokenId()) {
            case 6: {
                return jsonParser.getText();
            }
            case 12: {
                Object object = jsonParser.getEmbeddedObject();
                if (object instanceof byte[]) {
                    return deserializationContext.getBase64Variant().encode((byte[])object, false);
                }
                if (object == null) {
                    return null;
                }
                return object.toString();
            }
            case 1: {
                return deserializationContext.extractScalarFromObject(jsonParser, this, this._valueClass);
            }
            case 7: {
                coercionAction = this._checkIntToStringCoercion(jsonParser, deserializationContext, this._valueClass);
                break;
            }
            case 8: {
                coercionAction = this._checkFloatToStringCoercion(jsonParser, deserializationContext, this._valueClass);
                break;
            }
            case 9: 
            case 10: {
                coercionAction = this._checkBooleanToStringCoercion(jsonParser, deserializationContext, this._valueClass);
            }
        }
        if (coercionAction == CoercionAction.AsNull) {
            return (String)nullValueProvider.getNullValue(deserializationContext);
        }
        if (coercionAction == CoercionAction.AsEmpty) {
            return "";
        }
        if (jsonParser.currentToken().isScalarValue() && (string = jsonParser.getValueAsString()) != null) {
            return string;
        }
        return (String)deserializationContext.handleUnexpectedToken(this.getValueType(deserializationContext), jsonParser);
    }

    protected boolean _hasTextualNull(String string) {
        return "null".equals(string);
    }

    protected final boolean _isNegInf(String string) {
        return "-Infinity".equals(string) || "-INF".equals(string);
    }

    protected final boolean _isPosInf(String string) {
        return "Infinity".equals(string) || "INF".equals(string);
    }

    protected final boolean _isNaN(String string) {
        return "NaN".equals(string);
    }

    protected static final boolean _isBlank(String string) {
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (string.charAt(i2) <= ' ') continue;
            return false;
        }
        return true;
    }

    protected CoercionAction _checkFromStringCoercion(DeserializationContext deserializationContext, String string) throws IOException {
        return this._checkFromStringCoercion(deserializationContext, string, this.logicalType(), this.handledType());
    }

    protected CoercionAction _checkFromStringCoercion(DeserializationContext deserializationContext, String string, LogicalType logicalType, Class<?> clazz) throws IOException {
        if (string.isEmpty()) {
            CoercionAction coercionAction = deserializationContext.findCoercionAction(logicalType, clazz, CoercionInputShape.EmptyString);
            return this._checkCoercionFail(deserializationContext, coercionAction, clazz, string, "empty String (\"\")");
        }
        if (StdDeserializer._isBlank(string)) {
            CoercionAction coercionAction = deserializationContext.findCoercionFromBlankString(logicalType, clazz, CoercionAction.Fail);
            return this._checkCoercionFail(deserializationContext, coercionAction, clazz, string, "blank String (all whitespace)");
        }
        if (deserializationContext.isEnabled(StreamReadCapability.UNTYPED_SCALARS)) {
            return CoercionAction.TryConvert;
        }
        CoercionAction coercionAction = deserializationContext.findCoercionAction(logicalType, clazz, CoercionInputShape.String);
        if (coercionAction == CoercionAction.Fail) {
            deserializationContext.reportInputMismatch(this, "Cannot coerce String value (\"%s\") to %s (but might if coercion using `CoercionConfig` was enabled)", string, this._coercedTypeDesc());
        }
        return coercionAction;
    }

    protected CoercionAction _checkFloatToIntCoercion(JsonParser jsonParser, DeserializationContext deserializationContext, Class<?> clazz) throws IOException {
        CoercionAction coercionAction = deserializationContext.findCoercionAction(LogicalType.Integer, clazz, CoercionInputShape.Float);
        if (coercionAction == CoercionAction.Fail) {
            return this._checkCoercionFail(deserializationContext, coercionAction, clazz, jsonParser.getNumberValue(), "Floating-point value (" + jsonParser.getText() + ")");
        }
        return coercionAction;
    }

    protected CoercionAction _checkIntToStringCoercion(JsonParser jsonParser, DeserializationContext deserializationContext, Class<?> clazz) throws IOException {
        return this._checkToStringCoercion(jsonParser, deserializationContext, clazz, jsonParser.getNumberValue(), CoercionInputShape.Integer);
    }

    protected CoercionAction _checkFloatToStringCoercion(JsonParser jsonParser, DeserializationContext deserializationContext, Class<?> clazz) throws IOException {
        return this._checkToStringCoercion(jsonParser, deserializationContext, clazz, jsonParser.getNumberValue(), CoercionInputShape.Float);
    }

    protected CoercionAction _checkBooleanToStringCoercion(JsonParser jsonParser, DeserializationContext deserializationContext, Class<?> clazz) throws IOException {
        return this._checkToStringCoercion(jsonParser, deserializationContext, clazz, jsonParser.getBooleanValue(), CoercionInputShape.Boolean);
    }

    protected CoercionAction _checkToStringCoercion(JsonParser jsonParser, DeserializationContext deserializationContext, Class<?> clazz, Object object, CoercionInputShape coercionInputShape) throws IOException {
        CoercionAction coercionAction = deserializationContext.findCoercionAction(LogicalType.Textual, clazz, coercionInputShape);
        if (coercionAction == CoercionAction.Fail) {
            return this._checkCoercionFail(deserializationContext, coercionAction, clazz, object, coercionInputShape.name() + " value (" + jsonParser.getText() + ")");
        }
        return coercionAction;
    }

    protected CoercionAction _checkIntToFloatCoercion(JsonParser jsonParser, DeserializationContext deserializationContext, Class<?> clazz) throws IOException {
        CoercionAction coercionAction = deserializationContext.findCoercionAction(LogicalType.Float, clazz, CoercionInputShape.Integer);
        if (coercionAction == CoercionAction.Fail) {
            return this._checkCoercionFail(deserializationContext, coercionAction, clazz, jsonParser.getNumberValue(), "Integer value (" + jsonParser.getText() + ")");
        }
        return coercionAction;
    }

    protected Boolean _coerceBooleanFromInt(JsonParser jsonParser, DeserializationContext deserializationContext, Class<?> clazz) throws IOException {
        CoercionAction coercionAction = deserializationContext.findCoercionAction(LogicalType.Boolean, clazz, CoercionInputShape.Integer);
        switch (coercionAction) {
            case Fail: {
                this._checkCoercionFail(deserializationContext, coercionAction, clazz, jsonParser.getNumberValue(), "Integer value (" + jsonParser.getText() + ")");
                return Boolean.FALSE;
            }
            case AsNull: {
                return null;
            }
            case AsEmpty: {
                return Boolean.FALSE;
            }
        }
        if (jsonParser.getNumberType() == JsonParser.NumberType.INT) {
            return jsonParser.getIntValue() != 0;
        }
        return !"0".equals(jsonParser.getText());
    }

    protected CoercionAction _checkCoercionFail(DeserializationContext deserializationContext, CoercionAction coercionAction, Class<?> clazz, Object object, String string) throws IOException {
        if (coercionAction == CoercionAction.Fail) {
            deserializationContext.reportBadCoercion(this, clazz, object, "Cannot coerce %s to %s (but could if coercion was enabled using `CoercionConfig`)", string, this._coercedTypeDesc());
        }
        return coercionAction;
    }

    protected boolean _checkTextualNull(DeserializationContext deserializationContext, String string) throws JsonMappingException {
        if (this._hasTextualNull(string)) {
            if (!deserializationContext.isEnabled(MapperFeature.ALLOW_COERCION_OF_SCALARS)) {
                this._reportFailedNullCoerce(deserializationContext, true, MapperFeature.ALLOW_COERCION_OF_SCALARS, "String \"null\"");
            }
            return true;
        }
        return false;
    }

    protected Object _coerceIntegral(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        if (deserializationContext.isEnabled(DeserializationFeature.USE_BIG_INTEGER_FOR_INTS)) {
            return jsonParser.getBigIntegerValue();
        }
        if (deserializationContext.isEnabled(DeserializationFeature.USE_LONG_FOR_INTS)) {
            return jsonParser.getLongValue();
        }
        return jsonParser.getNumberValue();
    }

    protected final void _verifyNullForPrimitive(DeserializationContext deserializationContext) throws JsonMappingException {
        if (deserializationContext.isEnabled(DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES)) {
            deserializationContext.reportInputMismatch(this, "Cannot coerce `null` to %s (disable `DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES` to allow)", this._coercedTypeDesc());
        }
    }

    protected final void _verifyNullForPrimitiveCoercion(DeserializationContext deserializationContext, String string) throws JsonMappingException {
        boolean bl2;
        Enum enum_;
        if (!deserializationContext.isEnabled(MapperFeature.ALLOW_COERCION_OF_SCALARS)) {
            enum_ = MapperFeature.ALLOW_COERCION_OF_SCALARS;
            bl2 = true;
        } else if (deserializationContext.isEnabled(DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES)) {
            enum_ = DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES;
            bl2 = false;
        } else {
            return;
        }
        String string2 = string.isEmpty() ? "empty String (\"\")" : String.format("String \"%s\"", string);
        this._reportFailedNullCoerce(deserializationContext, bl2, enum_, string2);
    }

    protected void _reportFailedNullCoerce(DeserializationContext deserializationContext, boolean bl2, Enum<?> enum_, String string) throws JsonMappingException {
        String string2 = bl2 ? "enable" : "disable";
        deserializationContext.reportInputMismatch(this, "Cannot coerce %s to Null value as %s (%s `%s.%s` to allow)", string, this._coercedTypeDesc(), string2, enum_.getDeclaringClass().getSimpleName(), enum_.name());
    }

    protected String _coercedTypeDesc() {
        String string;
        boolean bl2;
        JavaType javaType = this.getValueType();
        if (javaType != null && !javaType.isPrimitive()) {
            bl2 = javaType.isContainerType() || javaType.isReferenceType();
            string = ClassUtil.getTypeDescription(javaType);
        } else {
            Class<?> clazz = this.handledType();
            bl2 = clazz.isArray() || Collection.class.isAssignableFrom(clazz) || Map.class.isAssignableFrom(clazz);
            string = ClassUtil.getClassDescription(clazz);
        }
        if (bl2) {
            return "element of " + string;
        }
        return string + " value";
    }

    @Deprecated
    protected boolean _parseBooleanFromInt(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        this._verifyNumberForScalarCoercion(deserializationContext, jsonParser);
        return !"0".equals(jsonParser.getText());
    }

    @Deprecated
    protected void _verifyStringForScalarCoercion(DeserializationContext deserializationContext, String string) throws JsonMappingException {
        MapperFeature mapperFeature = MapperFeature.ALLOW_COERCION_OF_SCALARS;
        if (!deserializationContext.isEnabled(mapperFeature)) {
            deserializationContext.reportInputMismatch(this, "Cannot coerce String \"%s\" to %s (enable `%s.%s` to allow)", string, this._coercedTypeDesc(), mapperFeature.getDeclaringClass().getSimpleName(), mapperFeature.name());
        }
    }

    @Deprecated
    protected Object _coerceEmptyString(DeserializationContext deserializationContext, boolean bl2) throws JsonMappingException {
        boolean bl3;
        Enum enum_;
        if (!deserializationContext.isEnabled(MapperFeature.ALLOW_COERCION_OF_SCALARS)) {
            enum_ = MapperFeature.ALLOW_COERCION_OF_SCALARS;
            bl3 = true;
        } else if (bl2 && deserializationContext.isEnabled(DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES)) {
            enum_ = DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES;
            bl3 = false;
        } else {
            return this.getNullValue(deserializationContext);
        }
        this._reportFailedNullCoerce(deserializationContext, bl3, enum_, "empty String (\"\")");
        return null;
    }

    @Deprecated
    protected void _failDoubleToIntCoercion(JsonParser jsonParser, DeserializationContext deserializationContext, String string) throws IOException {
        deserializationContext.reportInputMismatch(this.handledType(), "Cannot coerce a floating-point value ('%s') into %s (enable `DeserializationFeature.ACCEPT_FLOAT_AS_INT` to allow)", jsonParser.getValueAsString(), string);
    }

    @Deprecated
    protected final void _verifyNullForScalarCoercion(DeserializationContext deserializationContext, String string) throws JsonMappingException {
        if (!deserializationContext.isEnabled(MapperFeature.ALLOW_COERCION_OF_SCALARS)) {
            String string2 = string.isEmpty() ? "empty String (\"\")" : String.format("String \"%s\"", string);
            this._reportFailedNullCoerce(deserializationContext, true, MapperFeature.ALLOW_COERCION_OF_SCALARS, string2);
        }
    }

    @Deprecated
    protected void _verifyNumberForScalarCoercion(DeserializationContext deserializationContext, JsonParser jsonParser) throws IOException {
        MapperFeature mapperFeature = MapperFeature.ALLOW_COERCION_OF_SCALARS;
        if (!deserializationContext.isEnabled(mapperFeature)) {
            String string = jsonParser.getText();
            deserializationContext.reportInputMismatch(this, "Cannot coerce Number (%s) to %s (enable `%s.%s` to allow)", string, this._coercedTypeDesc(), mapperFeature.getDeclaringClass().getSimpleName(), mapperFeature.name());
        }
    }

    @Deprecated
    protected Object _coerceNullToken(DeserializationContext deserializationContext, boolean bl2) throws JsonMappingException {
        if (bl2) {
            this._verifyNullForPrimitive(deserializationContext);
        }
        return this.getNullValue(deserializationContext);
    }

    @Deprecated
    protected Object _coerceTextualNull(DeserializationContext deserializationContext, boolean bl2) throws JsonMappingException {
        if (!deserializationContext.isEnabled(MapperFeature.ALLOW_COERCION_OF_SCALARS)) {
            this._reportFailedNullCoerce(deserializationContext, true, MapperFeature.ALLOW_COERCION_OF_SCALARS, "String \"null\"");
        }
        return this.getNullValue(deserializationContext);
    }

    @Deprecated
    protected boolean _isEmptyOrTextualNull(String string) {
        return string.isEmpty() || "null".equals(string);
    }

    protected JsonDeserializer<Object> findDeserializer(DeserializationContext deserializationContext, JavaType javaType, BeanProperty beanProperty) throws JsonMappingException {
        return deserializationContext.findContextualValueDeserializer(javaType, beanProperty);
    }

    protected final boolean _isIntNumber(String string) {
        int n2 = string.length();
        if (n2 > 0) {
            int n3;
            char c2 = string.charAt(0);
            if (c2 == '-' || c2 == '+') {
                if (n2 == 1) {
                    return false;
                }
                n3 = 1;
            } else {
                n3 = 0;
            }
            while (n3 < n2) {
                char c3 = string.charAt(n3);
                if (c3 > '9' || c3 < '0') {
                    return false;
                }
                ++n3;
            }
            return true;
        }
        return false;
    }

    protected JsonDeserializer<?> findConvertingContentDeserializer(DeserializationContext deserializationContext, BeanProperty beanProperty, JsonDeserializer<?> jsonDeserializer) throws JsonMappingException {
        Object object;
        AnnotatedMember annotatedMember;
        AnnotationIntrospector annotationIntrospector = deserializationContext.getAnnotationIntrospector();
        if (StdDeserializer._neitherNull(annotationIntrospector, beanProperty) && (annotatedMember = beanProperty.getMember()) != null && (object = annotationIntrospector.findDeserializationContentConverter(annotatedMember)) != null) {
            Converter<Object, Object> converter = deserializationContext.converterInstance(beanProperty.getMember(), object);
            JavaType javaType = converter.getInputType(deserializationContext.getTypeFactory());
            if (jsonDeserializer == null) {
                jsonDeserializer = deserializationContext.findContextualValueDeserializer(javaType, beanProperty);
            }
            return new StdDelegatingDeserializer<Object>(converter, javaType, jsonDeserializer);
        }
        return jsonDeserializer;
    }

    protected JsonFormat.Value findFormatOverrides(DeserializationContext deserializationContext, BeanProperty beanProperty, Class<?> clazz) {
        if (beanProperty != null) {
            return beanProperty.findPropertyFormat(deserializationContext.getConfig(), clazz);
        }
        return deserializationContext.getDefaultPropertyFormat(clazz);
    }

    protected Boolean findFormatFeature(DeserializationContext deserializationContext, BeanProperty beanProperty, Class<?> clazz, JsonFormat.Feature feature) {
        JsonFormat.Value value = this.findFormatOverrides(deserializationContext, beanProperty, clazz);
        if (value != null) {
            return value.getFeature(feature);
        }
        return null;
    }

    protected final NullValueProvider findValueNullProvider(DeserializationContext deserializationContext, SettableBeanProperty settableBeanProperty, PropertyMetadata propertyMetadata) throws JsonMappingException {
        if (settableBeanProperty != null) {
            return this._findNullProvider(deserializationContext, settableBeanProperty, propertyMetadata.getValueNulls(), settableBeanProperty.getValueDeserializer());
        }
        return null;
    }

    protected NullValueProvider findContentNullProvider(DeserializationContext deserializationContext, BeanProperty beanProperty, JsonDeserializer<?> jsonDeserializer) throws JsonMappingException {
        Nulls nulls = this.findContentNullStyle(deserializationContext, beanProperty);
        if (nulls == Nulls.SKIP) {
            return NullsConstantProvider.skipper();
        }
        if (nulls == Nulls.FAIL) {
            if (beanProperty == null) {
                JavaType javaType = deserializationContext.constructType(jsonDeserializer.handledType());
                if (javaType.isContainerType()) {
                    javaType = javaType.getContentType();
                }
                return NullsFailProvider.constructForRootValue(javaType);
            }
            return NullsFailProvider.constructForProperty(beanProperty, beanProperty.getType().getContentType());
        }
        NullValueProvider nullValueProvider = this._findNullProvider(deserializationContext, beanProperty, nulls, jsonDeserializer);
        if (nullValueProvider != null) {
            return nullValueProvider;
        }
        return jsonDeserializer;
    }

    protected Nulls findContentNullStyle(DeserializationContext deserializationContext, BeanProperty beanProperty) throws JsonMappingException {
        if (beanProperty != null) {
            return beanProperty.getMetadata().getContentNulls();
        }
        return deserializationContext.getConfig().getDefaultSetterInfo().getContentNulls();
    }

    protected final NullValueProvider _findNullProvider(DeserializationContext deserializationContext, BeanProperty beanProperty, Nulls nulls, JsonDeserializer<?> jsonDeserializer) throws JsonMappingException {
        if (nulls == Nulls.FAIL) {
            if (beanProperty == null) {
                Class clazz = jsonDeserializer == null ? Object.class : jsonDeserializer.handledType();
                return NullsFailProvider.constructForRootValue(deserializationContext.constructType(clazz));
            }
            return NullsFailProvider.constructForProperty(beanProperty);
        }
        if (nulls == Nulls.AS_EMPTY) {
            Object object;
            ValueInstantiator valueInstantiator;
            if (jsonDeserializer == null) {
                return null;
            }
            if (jsonDeserializer instanceof BeanDeserializerBase && !(valueInstantiator = (object = (BeanDeserializerBase)jsonDeserializer).getValueInstantiator()).canCreateUsingDefault()) {
                JavaType javaType = beanProperty == null ? object.getValueType() : beanProperty.getType();
                return (NullValueProvider)deserializationContext.reportBadDefinition(javaType, String.format("Cannot create empty instance of %s, no default Creator", javaType));
            }
            object = jsonDeserializer.getEmptyAccessPattern();
            if (object == AccessPattern.ALWAYS_NULL) {
                return NullsConstantProvider.nuller();
            }
            if (object == AccessPattern.CONSTANT) {
                return NullsConstantProvider.forValue(jsonDeserializer.getEmptyValue(deserializationContext));
            }
            return new NullsAsEmptyProvider(jsonDeserializer);
        }
        if (nulls == Nulls.SKIP) {
            return NullsConstantProvider.skipper();
        }
        return null;
    }

    protected CoercionAction _findCoercionFromEmptyString(DeserializationContext deserializationContext) {
        return deserializationContext.findCoercionAction(this.logicalType(), this.handledType(), CoercionInputShape.EmptyString);
    }

    protected CoercionAction _findCoercionFromEmptyArray(DeserializationContext deserializationContext) {
        return deserializationContext.findCoercionAction(this.logicalType(), this.handledType(), CoercionInputShape.EmptyArray);
    }

    protected CoercionAction _findCoercionFromBlankString(DeserializationContext deserializationContext) {
        return deserializationContext.findCoercionFromBlankString(this.logicalType(), this.handledType(), CoercionAction.Fail);
    }

    protected void handleUnknownProperty(JsonParser jsonParser, DeserializationContext deserializationContext, Object clazz, String string) throws IOException {
        if (clazz == null) {
            clazz = this.handledType();
        }
        if (deserializationContext.handleUnknownProperty(jsonParser, this, clazz, string)) {
            return;
        }
        jsonParser.skipChildren();
    }

    protected void handleMissingEndArrayForSingle(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        deserializationContext.reportWrongTokenException(this, JsonToken.END_ARRAY, "Attempted to unwrap '%s' value from an array (with `DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS`) but it contains more than one value", this.handledType().getName());
    }

    protected Object handleNestedArrayForSingle(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        String string = String.format("Cannot deserialize instance of %s out of %s token: nested Arrays not allowed with %s", new Object[]{ClassUtil.nameOf(this._valueClass), JsonToken.START_ARRAY, "DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS"});
        return deserializationContext.handleUnexpectedToken(this.getValueType(deserializationContext), jsonParser.currentToken(), jsonParser, string, new Object[0]);
    }

    protected void _verifyEndArrayForSingle(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        JsonToken jsonToken = jsonParser.nextToken();
        if (jsonToken != JsonToken.END_ARRAY) {
            this.handleMissingEndArrayForSingle(jsonParser, deserializationContext);
        }
    }

    protected static final boolean _neitherNull(Object object, Object object2) {
        return object != null && object2 != null;
    }

    protected final boolean _byteOverflow(int n2) {
        return n2 < -128 || n2 > 255;
    }

    protected final boolean _shortOverflow(int n2) {
        return n2 < Short.MIN_VALUE || n2 > Short.MAX_VALUE;
    }

    protected final boolean _intOverflow(long l2) {
        return l2 < Integer.MIN_VALUE || l2 > Integer.MAX_VALUE;
    }

    protected Number _nonNullNumber(Number number) {
        if (number == null) {
            number = 0;
        }
        return number;
    }
}

