/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.dev.failsafe.spi;

import com.gradle.scan.plugin.internal.dep.dev.failsafe.ExecutionContext;
import com.gradle.scan.plugin.internal.dep.dev.failsafe.spi.ExecutionInternal;
import com.gradle.scan.plugin.internal.dep.dev.failsafe.spi.ExecutionResult;
import com.gradle.scan.plugin.internal.dep.dev.failsafe.spi.PolicyExecutor;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.function.BiConsumer;

public class FailsafeFuture<R>
extends CompletableFuture<R> {
    private final BiConsumer<ExecutionResult<R>, ExecutionContext<R>> completionHandler;
    private ExecutionInternal<R> newestExecution;
    private Map<Integer, BiConsumer<Boolean, ExecutionResult<R>>> cancelFunctions;
    private boolean cancelledWithInterrupt;

    public FailsafeFuture(BiConsumer<ExecutionResult<R>, ExecutionContext<R>> biConsumer) {
        this.completionHandler = biConsumer;
    }

    @Override
    public synchronized boolean complete(R r2) {
        return this.completeResult(ExecutionResult.success(r2));
    }

    @Override
    public synchronized boolean completeExceptionally(Throwable throwable) {
        return this.completeResult(ExecutionResult.exception(throwable));
    }

    @Override
    public synchronized boolean cancel(boolean bl2) {
        if (this.isDone()) {
            return false;
        }
        this.cancelledWithInterrupt = bl2;
        this.newestExecution.cancel();
        boolean bl3 = super.cancel(bl2);
        this.cancelDependencies(null, bl2, null);
        ExecutionResult executionResult = ExecutionResult.exception(new CancellationException());
        super.completeExceptionally(executionResult.getException());
        this.completionHandler.accept(executionResult, this.newestExecution);
        return bl3;
    }

    public synchronized boolean completeResult(ExecutionResult<R> executionResult) {
        if (this.isDone()) {
            return false;
        }
        Throwable throwable = executionResult.getException();
        boolean bl2 = throwable == null ? super.complete(executionResult.getResult()) : super.completeExceptionally(throwable);
        if (bl2) {
            this.completionHandler.accept(executionResult, this.newestExecution);
        }
        return bl2;
    }

    public synchronized void cancelDependencies(PolicyExecutor<R> policyExecutor, boolean bl2, ExecutionResult<R> executionResult) {
        if (this.cancelFunctions != null) {
            int n2 = policyExecutor == null ? Integer.MAX_VALUE : policyExecutor.getPolicyIndex();
            Iterator<Map.Entry<Integer, BiConsumer<Boolean, ExecutionResult<R>>>> iterator = this.cancelFunctions.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Integer, BiConsumer<Boolean, ExecutionResult<R>>> entry = iterator.next();
                if (n2 <= entry.getKey()) continue;
                try {
                    entry.getValue().accept(bl2, executionResult);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                iterator.remove();
            }
        }
    }

    public synchronized void setExecution(ExecutionInternal<R> executionInternal) {
        this.newestExecution = executionInternal;
    }

    public synchronized void setCancelFn(int n2, BiConsumer<Boolean, ExecutionResult<R>> biConsumer) {
        if (this.cancelFunctions == null) {
            this.cancelFunctions = new TreeMap(Collections.reverseOrder());
        }
        this.cancelFunctions.put(n2, biConsumer);
    }

    public synchronized void setCancelFn(PolicyExecutor<R> policyExecutor, BiConsumer<Boolean, ExecutionResult<R>> biConsumer) {
        this.setCancelFn(policyExecutor.getPolicyIndex(), biConsumer);
    }

    public synchronized void propagateCancellation(Future<R> future) {
        if (this.isCancelled()) {
            future.cancel(this.cancelledWithInterrupt);
        } else {
            this.setCancelFn(-2, (Boolean bl2, ExecutionResult<R> executionResult) -> future.cancel((boolean)bl2));
        }
    }
}

