/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client;

import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.Origin;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.io.ClientConnectionFactory;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.HostPort;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.ssl.SslContextFactory;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class ProxyConfiguration {
    private final List<Proxy> proxies = new ArrayList<Proxy>();

    public List<Proxy> getProxies() {
        return this.proxies;
    }

    public Proxy match(Origin origin) {
        for (Proxy proxy : this.getProxies()) {
            if (!proxy.matches(origin)) continue;
            return proxy;
        }
        return null;
    }

    public static abstract class Proxy {
        private final Set<String> included;
        private final Set<String> excluded;
        private final Origin.Address address;
        private final boolean secure;
        private final SslContextFactory.Client sslContextFactory;

        public Origin.Address getAddress() {
            return this.address;
        }

        public boolean isSecure() {
            return this.secure;
        }

        public SslContextFactory.Client getSslContextFactory() {
            return this.sslContextFactory;
        }

        public URI getURI() {
            return null;
        }

        public boolean matches(Origin origin) {
            if (this.getAddress().equals(origin.getAddress())) {
                return false;
            }
            boolean bl2 = this.included.isEmpty();
            Origin.Address address = origin.getAddress();
            for (String string : this.included) {
                if (!this.matches(address, string)) continue;
                bl2 = true;
                break;
            }
            for (String string : this.excluded) {
                if (!this.matches(address, string)) continue;
                bl2 = false;
                break;
            }
            return bl2;
        }

        private boolean matches(Origin.Address address, String string) {
            HostPort hostPort = new HostPort(string);
            String string2 = hostPort.getHost();
            int n2 = hostPort.getPort();
            return string2.equals(address.getHost()) && (n2 <= 0 || n2 == address.getPort());
        }

        public abstract ClientConnectionFactory newClientConnectionFactory(ClientConnectionFactory var1);

        public String toString() {
            return this.address.toString();
        }
    }
}

