/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.io.ssl;

import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.io.ByteBufferPool;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.io.ClientConnectionFactory;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.io.Connection;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.io.EndPoint;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.io.ssl.SslConnection;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.io.ssl.SslHandshakeListener;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.component.ContainerLifeCycle;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.ssl.SslContextFactory;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;

public class SslClientConnectionFactory
implements ClientConnectionFactory {
    private final SslContextFactory sslContextFactory;
    private final ByteBufferPool byteBufferPool;
    private final Executor executor;
    private final ClientConnectionFactory connectionFactory;
    private boolean _directBuffersForEncryption = true;
    private boolean _directBuffersForDecryption = true;
    private boolean _requireCloseMessage;

    public SslClientConnectionFactory(SslContextFactory sslContextFactory, ByteBufferPool byteBufferPool, Executor executor, ClientConnectionFactory clientConnectionFactory) {
        this.sslContextFactory = Objects.requireNonNull(sslContextFactory, "Missing SslContextFactory");
        this.byteBufferPool = byteBufferPool;
        this.executor = executor;
        this.connectionFactory = clientConnectionFactory;
    }

    public boolean isDirectBuffersForDecryption() {
        return this._directBuffersForDecryption;
    }

    public boolean isDirectBuffersForEncryption() {
        return this._directBuffersForEncryption;
    }

    public boolean isRequireCloseMessage() {
        return this._requireCloseMessage;
    }

    @Override
    public Connection newConnection(EndPoint endPoint, Map<String, Object> map) throws IOException {
        String string = (String)map.get("ssl.peer.host");
        int n2 = (Integer)map.get("ssl.peer.port");
        SSLEngine sSLEngine = this.sslContextFactory instanceof SslEngineFactory ? ((SslEngineFactory)((Object)this.sslContextFactory)).newSslEngine(string, n2, map) : this.sslContextFactory.newSSLEngine(string, n2);
        sSLEngine.setUseClientMode(true);
        map.put("ssl.engine", sSLEngine);
        SslConnection sslConnection = this.newSslConnection(this.byteBufferPool, this.executor, endPoint, sSLEngine);
        SslConnection.DecryptedEndPoint decryptedEndPoint = sslConnection.getDecryptedEndPoint();
        decryptedEndPoint.setConnection(this.connectionFactory.newConnection(decryptedEndPoint, map));
        sslConnection.addHandshakeListener(new HTTPSHandshakeListener(map));
        this.customize(sslConnection, map);
        return sslConnection;
    }

    protected SslConnection newSslConnection(ByteBufferPool byteBufferPool, Executor executor, EndPoint endPoint, SSLEngine sSLEngine) {
        return new SslConnection(byteBufferPool, executor, endPoint, sSLEngine, this.isDirectBuffersForEncryption(), this.isDirectBuffersForDecryption());
    }

    @Override
    public Connection customize(Connection connection, Map<String, Object> map) {
        if (connection instanceof SslConnection) {
            SslConnection sslConnection = (SslConnection)connection;
            sslConnection.setRenegotiationAllowed(this.sslContextFactory.isRenegotiationAllowed());
            sslConnection.setRenegotiationLimit(this.sslContextFactory.getRenegotiationLimit());
            sslConnection.setRequireCloseMessage(this.isRequireCloseMessage());
            ContainerLifeCycle containerLifeCycle = (ContainerLifeCycle)map.get("client.connector");
            containerLifeCycle.getBeans(SslHandshakeListener.class).forEach(sslConnection::addHandshakeListener);
        }
        return ClientConnectionFactory.super.customize(connection, map);
    }

    private class HTTPSHandshakeListener
    implements SslHandshakeListener {
        private final Map<String, Object> context;

        private HTTPSHandshakeListener(Map<String, Object> map) {
            this.context = map;
        }

        @Override
        public void handshakeSucceeded(SslHandshakeListener.Event event) throws SSLException {
            HostnameVerifier hostnameVerifier = SslClientConnectionFactory.this.sslContextFactory.getHostnameVerifier();
            if (hostnameVerifier != null) {
                String string = (String)this.context.get("ssl.peer.host");
                try {
                    if (!hostnameVerifier.verify(string, event.getSSLEngine().getSession())) {
                        throw new SSLPeerUnverifiedException("Host name verification failed for host: " + string);
                    }
                }
                catch (SSLException sSLException) {
                    throw sSLException;
                }
                catch (Throwable throwable) {
                    throw (SSLException)new SSLPeerUnverifiedException("Host name verification failed for host: " + string).initCause(throwable);
                }
            }
        }
    }

    public static interface SslEngineFactory {
        public SSLEngine newSslEngine(String var1, int var2, Map<String, Object> var3);
    }
}

