/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util;

import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.StringUtil;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.log.Log;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.log.Logger;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;

public class TypeUtil {
    private static final Logger LOG;
    public static final Class<?>[] NO_ARGS;
    private static final HashMap<String, Class<?>> name2Class;
    private static final HashMap<Class<?>, String> class2Name;
    private static final HashMap<Class<?>, Method> class2Value;
    private static final List<Function<Class<?>, URI>> LOCATION_METHODS;
    private static final Function<Class<?>, URI> MODULE_LOCATION;

    public static String toClassReference(Class<?> clazz) {
        return TypeUtil.toClassReference(clazz.getName());
    }

    public static String toClassReference(String string) {
        return StringUtil.replace(string, '.', '/').concat(".class");
    }

    public static int parseInt(String string, int n2, int n3, int n4) throws NumberFormatException {
        int n5 = 0;
        if (n3 < 0) {
            n3 = string.length() - n2;
        }
        for (int i2 = 0; i2 < n3; ++i2) {
            char c2 = string.charAt(n2 + i2);
            int n6 = TypeUtil.convertHexDigit((int)c2);
            if (n6 < 0 || n6 >= n4) {
                throw new NumberFormatException(string.substring(n2, n2 + n3));
            }
            n5 = n5 * n4 + n6;
        }
        return n5;
    }

    public static byte convertHexDigit(byte by2) {
        byte by3 = (byte)((by2 & 0x1F) + (by2 >> 6) * 25 - 16);
        if (by3 < 0 || by3 > 15) {
            throw new NumberFormatException("!hex " + by2);
        }
        return by3;
    }

    public static int convertHexDigit(char c2) {
        int n2 = (c2 & 0x1F) + (c2 >> 6) * 25 - 16;
        if (n2 < 0 || n2 > 15) {
            throw new NumberFormatException("!hex " + c2);
        }
        return n2;
    }

    public static int convertHexDigit(int n2) {
        int n3 = (n2 & 0x1F) + (n2 >> 6) * 25 - 16;
        if (n3 < 0 || n3 > 15) {
            throw new NumberFormatException("!hex " + n2);
        }
        return n3;
    }

    public static void toHex(byte by2, Appendable appendable) {
        try {
            int n2 = 0xF & (0xF0 & by2) >> 4;
            appendable.append((char)((n2 > 9 ? 55 : 48) + n2));
            n2 = 0xF & by2;
            appendable.append((char)((n2 > 9 ? 55 : 48) + n2));
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static String toHexString(byte by2) {
        return TypeUtil.toHexString(new byte[]{by2}, 0, 1);
    }

    public static String toHexString(byte[] byArray, int n2, int n3) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = n2; i2 < n2 + n3; ++i2) {
            int n4 = 0xFF & byArray[i2];
            int n5 = 48 + n4 / 16 % 16;
            if (n5 > 57) {
                n5 = 65 + (n5 - 48 - 10);
            }
            stringBuilder.append((char)n5);
            n5 = 48 + n4 % 16;
            if (n5 > 57) {
                n5 = 97 + (n5 - 48 - 10);
            }
            stringBuilder.append((char)n5);
        }
        return stringBuilder.toString();
    }

    public static URI getClassLoaderLocation(Class<?> clazz) {
        return TypeUtil.getClassLoaderLocation(clazz, clazz.getClassLoader());
    }

    public static URI getSystemClassLoaderLocation(Class<?> clazz) {
        return TypeUtil.getClassLoaderLocation(clazz, ClassLoader.getSystemClassLoader());
    }

    public static URI getClassLoaderLocation(Class<?> clazz, ClassLoader classLoader) {
        if (classLoader == null) {
            return null;
        }
        try {
            URL uRL;
            String string = TypeUtil.toClassReference(clazz);
            if (classLoader != null && (uRL = classLoader.getResource(string)) != null) {
                int n2;
                URI uRI = uRL.toURI();
                String string2 = uRI.toASCIIString();
                if (string2.startsWith("jar:file:") && (n2 = (string2 = string2.substring(4)).indexOf("!/")) > 0) {
                    return URI.create(string2.substring(0, n2));
                }
                return uRI;
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return null;
    }

    public static URI getCodeSourceLocation(Class<?> clazz) {
        try {
            URL uRL;
            CodeSource codeSource;
            ProtectionDomain protectionDomain = AccessController.doPrivileged(() -> clazz.getProtectionDomain());
            if (protectionDomain != null && (codeSource = protectionDomain.getCodeSource()) != null && (uRL = codeSource.getLocation()) != null) {
                return uRL.toURI();
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return null;
    }

    public static URI getModuleLocation(Class<?> clazz) {
        if (MODULE_LOCATION != null) {
            return MODULE_LOCATION.apply(clazz);
        }
        return null;
    }

    static {
        Object object;
        LOG = Log.getLogger(TypeUtil.class);
        NO_ARGS = new Class[0];
        name2Class = new HashMap();
        name2Class.put("boolean", Boolean.TYPE);
        name2Class.put("byte", Byte.TYPE);
        name2Class.put("char", Character.TYPE);
        name2Class.put("double", Double.TYPE);
        name2Class.put("float", Float.TYPE);
        name2Class.put("int", Integer.TYPE);
        name2Class.put("long", Long.TYPE);
        name2Class.put("short", Short.TYPE);
        name2Class.put("void", Void.TYPE);
        name2Class.put("java.lang.Boolean.TYPE", Boolean.TYPE);
        name2Class.put("java.lang.Byte.TYPE", Byte.TYPE);
        name2Class.put("java.lang.Character.TYPE", Character.TYPE);
        name2Class.put("java.lang.Double.TYPE", Double.TYPE);
        name2Class.put("java.lang.Float.TYPE", Float.TYPE);
        name2Class.put("java.lang.Integer.TYPE", Integer.TYPE);
        name2Class.put("java.lang.Long.TYPE", Long.TYPE);
        name2Class.put("java.lang.Short.TYPE", Short.TYPE);
        name2Class.put("java.lang.Void.TYPE", Void.TYPE);
        name2Class.put("java.lang.Boolean", Boolean.class);
        name2Class.put("java.lang.Byte", Byte.class);
        name2Class.put("java.lang.Character", Character.class);
        name2Class.put("java.lang.Double", Double.class);
        name2Class.put("java.lang.Float", Float.class);
        name2Class.put("java.lang.Integer", Integer.class);
        name2Class.put("java.lang.Long", Long.class);
        name2Class.put("java.lang.Short", Short.class);
        name2Class.put("Boolean", Boolean.class);
        name2Class.put("Byte", Byte.class);
        name2Class.put("Character", Character.class);
        name2Class.put("Double", Double.class);
        name2Class.put("Float", Float.class);
        name2Class.put("Integer", Integer.class);
        name2Class.put("Long", Long.class);
        name2Class.put("Short", Short.class);
        name2Class.put(null, Void.TYPE);
        name2Class.put("string", String.class);
        name2Class.put("String", String.class);
        name2Class.put("java.lang.String", String.class);
        class2Name = new HashMap();
        class2Name.put(Boolean.TYPE, "boolean");
        class2Name.put(Byte.TYPE, "byte");
        class2Name.put(Character.TYPE, "char");
        class2Name.put(Double.TYPE, "double");
        class2Name.put(Float.TYPE, "float");
        class2Name.put(Integer.TYPE, "int");
        class2Name.put(Long.TYPE, "long");
        class2Name.put(Short.TYPE, "short");
        class2Name.put(Void.TYPE, "void");
        class2Name.put(Boolean.class, "java.lang.Boolean");
        class2Name.put(Byte.class, "java.lang.Byte");
        class2Name.put(Character.class, "java.lang.Character");
        class2Name.put(Double.class, "java.lang.Double");
        class2Name.put(Float.class, "java.lang.Float");
        class2Name.put(Integer.class, "java.lang.Integer");
        class2Name.put(Long.class, "java.lang.Long");
        class2Name.put(Short.class, "java.lang.Short");
        class2Name.put(null, "void");
        class2Name.put(String.class, "java.lang.String");
        class2Value = new HashMap();
        try {
            object = new Class[]{String.class};
            class2Value.put(Boolean.TYPE, Boolean.class.getMethod("valueOf", (Class<?>)object));
            class2Value.put(Byte.TYPE, Byte.class.getMethod("valueOf", (Class<?>)object));
            class2Value.put(Double.TYPE, Double.class.getMethod("valueOf", (Class<?>)object));
            class2Value.put(Float.TYPE, Float.class.getMethod("valueOf", (Class<?>)object));
            class2Value.put(Integer.TYPE, Integer.class.getMethod("valueOf", (Class<?>)object));
            class2Value.put(Long.TYPE, Long.class.getMethod("valueOf", (Class<?>)object));
            class2Value.put(Short.TYPE, Short.class.getMethod("valueOf", (Class<?>)object));
            class2Value.put(Boolean.class, Boolean.class.getMethod("valueOf", (Class<?>)object));
            class2Value.put(Byte.class, Byte.class.getMethod("valueOf", (Class<?>)object));
            class2Value.put(Double.class, Double.class.getMethod("valueOf", (Class<?>)object));
            class2Value.put(Float.class, Float.class.getMethod("valueOf", (Class<?>)object));
            class2Value.put(Integer.class, Integer.class.getMethod("valueOf", (Class<?>)object));
            class2Value.put(Long.class, Long.class.getMethod("valueOf", (Class<?>)object));
            class2Value.put(Short.class, Short.class.getMethod("valueOf", (Class<?>)object));
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
        LOCATION_METHODS = new ArrayList();
        LOCATION_METHODS.add(TypeUtil::getCodeSourceLocation);
        object = null;
        try {
            Class<?> clazz = TypeUtil.class.getClassLoader().loadClass(TypeUtil.class.getPackage().getName() + ".ModuleLocation");
            Object obj = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            if (obj instanceof Function) {
                object = (Function)obj;
                LOCATION_METHODS.add((Function<Class<?>, URI>)object);
            }
        }
        catch (Throwable throwable) {
            LOG.debug("This JVM Runtime does not support Modules, disabling Jetty internal support", new Object[0]);
        }
        MODULE_LOCATION = object;
        LOCATION_METHODS.add(TypeUtil::getClassLoaderLocation);
        LOCATION_METHODS.add(TypeUtil::getSystemClassLoaderLocation);
    }
}

