/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.resource;

import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.StringUtil;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.URIUtil;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.log.Log;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.log.Logger;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.resource.Resource;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;

public class PathResource
extends Resource {
    private static final Logger LOG = Log.getLogger(PathResource.class);
    private static final LinkOption[] NO_FOLLOW_LINKS = new LinkOption[]{LinkOption.NOFOLLOW_LINKS};
    private static final LinkOption[] FOLLOW_LINKS = new LinkOption[0];
    private final Path path;
    private final Path alias;
    private final URI uri;
    private final boolean belongsToDefaultFileSystem;

    private Path checkAliasPath() {
        Path path;
        Path path2 = this.path;
        if (!URIUtil.equalsIgnoreEncodings(this.uri, this.path.toUri())) {
            try {
                return Paths.get(this.uri).toRealPath(FOLLOW_LINKS);
            }
            catch (IOException iOException) {
                LOG.ignore(iOException);
            }
        }
        if (!path2.isAbsolute()) {
            path2 = this.path.toAbsolutePath();
        }
        if (!PathResource.isSameName(path2, path = this.path.normalize())) {
            return path;
        }
        try {
            Path path3;
            if (Files.isSymbolicLink(this.path)) {
                return this.path.getParent().resolve(Files.readSymbolicLink(this.path));
            }
            if (Files.exists(this.path, new LinkOption[0]) && !PathResource.isSameName(path2, path3 = path2.toRealPath(FOLLOW_LINKS))) {
                return path3;
            }
        }
        catch (IOException iOException) {
            LOG.ignore(iOException);
        }
        catch (Exception exception) {
            LOG.warn("bad alias ({} {}) for {}", exception.getClass().getName(), exception.getMessage(), this.path);
        }
        return null;
    }

    public static boolean isSameName(Path path, Path path2) {
        int n2;
        int n3 = path.getNameCount();
        if (n3 != (n2 = path2.getNameCount())) {
            return false;
        }
        int n4 = n2;
        while (n4-- > 0) {
            if (path.getName(n4).toString().equals(path2.getName(n4).toString())) continue;
            return false;
        }
        return true;
    }

    public PathResource(Path path) {
        Path path2;
        block2: {
            path2 = path;
            try {
                path2 = path.toRealPath(NO_FOLLOW_LINKS);
            }
            catch (IOError | IOException throwable) {
                if (!LOG.isDebugEnabled()) break block2;
                LOG.debug("Unable to get real/canonical path for {}", path, throwable);
            }
        }
        this.path = path2;
        this.assertValidPath(path);
        this.uri = this.path.toUri();
        this.alias = this.checkAliasPath();
        this.belongsToDefaultFileSystem = this.path.getFileSystem() == FileSystems.getDefault();
    }

    public PathResource(URI uRI) throws IOException {
        Path path;
        if (!uRI.isAbsolute()) {
            throw new IllegalArgumentException("not an absolute uri");
        }
        if (!uRI.getScheme().equalsIgnoreCase("file")) {
            throw new IllegalArgumentException("not file: scheme");
        }
        try {
            path = Paths.get(uRI);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw illegalArgumentException;
        }
        catch (Exception exception) {
            LOG.ignore(exception);
            throw new IOException("Unable to build Path from: " + uRI, exception);
        }
        this.path = path.toAbsolutePath();
        this.uri = path.toUri();
        this.alias = this.checkAliasPath();
        this.belongsToDefaultFileSystem = this.path.getFileSystem() == FileSystems.getDefault();
    }

    public PathResource(URL uRL) throws IOException, URISyntaxException {
        this(uRL.toURI());
    }

    private void assertValidPath(Path path) {
        String string = path.toString();
        int n2 = StringUtil.indexOfControlChars(string);
        if (n2 >= 0) {
            throw new InvalidPathException(string, "Invalid Character at index " + n2);
        }
    }

    @Override
    public void close() {
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        PathResource pathResource = (PathResource)object;
        if (this.path == null) {
            return pathResource.path == null;
        }
        return this.path.equals(pathResource.path);
    }

    @Override
    public boolean exists() {
        return Files.exists(this.path, NO_FOLLOW_LINKS);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return Files.newInputStream(this.path, StandardOpenOption.READ);
    }

    @Override
    public String getName() {
        return this.path.toAbsolutePath().toString();
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.path == null ? 0 : this.path.hashCode());
        return n3;
    }

    public String toString() {
        return this.uri.toASCIIString();
    }
}

