/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.gradle.testretry.org.objectweb.asm;

import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.org.objectweb.asm.AnnotationVisitor;
import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.org.objectweb.asm.Attribute;
import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.org.objectweb.asm.ConstantDynamic;
import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.org.objectweb.asm.Constants;
import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.org.objectweb.asm.Handle;
import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.org.objectweb.asm.Label;
import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.org.objectweb.asm.Type;
import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.org.objectweb.asm.TypePath;

public abstract class MethodVisitor {
    protected final int api;
    protected MethodVisitor mv;

    protected MethodVisitor(int n2) {
        this(n2, null);
    }

    protected MethodVisitor(int n2, MethodVisitor methodVisitor) {
        if (n2 != 589824 && n2 != 524288 && n2 != 458752 && n2 != 393216 && n2 != 327680 && n2 != 262144 && n2 != 0x10A0000) {
            throw new IllegalArgumentException("Unsupported api " + n2);
        }
        if (n2 == 0x10A0000) {
            Constants.checkAsmExperimental(this);
        }
        this.api = n2;
        this.mv = methodVisitor;
    }

    public void visitParameter(String string, int n2) {
        if (this.api < 327680) {
            throw new UnsupportedOperationException("This feature requires ASM5");
        }
        if (this.mv != null) {
            this.mv.visitParameter(string, n2);
        }
    }

    public AnnotationVisitor visitAnnotationDefault() {
        if (this.mv != null) {
            return this.mv.visitAnnotationDefault();
        }
        return null;
    }

    public AnnotationVisitor visitAnnotation(String string, boolean bl2) {
        if (this.mv != null) {
            return this.mv.visitAnnotation(string, bl2);
        }
        return null;
    }

    public AnnotationVisitor visitTypeAnnotation(int n2, TypePath typePath, String string, boolean bl2) {
        if (this.api < 327680) {
            throw new UnsupportedOperationException("This feature requires ASM5");
        }
        if (this.mv != null) {
            return this.mv.visitTypeAnnotation(n2, typePath, string, bl2);
        }
        return null;
    }

    public void visitAnnotableParameterCount(int n2, boolean bl2) {
        if (this.mv != null) {
            this.mv.visitAnnotableParameterCount(n2, bl2);
        }
    }

    public AnnotationVisitor visitParameterAnnotation(int n2, String string, boolean bl2) {
        if (this.mv != null) {
            return this.mv.visitParameterAnnotation(n2, string, bl2);
        }
        return null;
    }

    public void visitAttribute(Attribute attribute) {
        if (this.mv != null) {
            this.mv.visitAttribute(attribute);
        }
    }

    public void visitCode() {
        if (this.mv != null) {
            this.mv.visitCode();
        }
    }

    public void visitFrame(int n2, int n3, Object[] objectArray, int n4, Object[] objectArray2) {
        if (this.mv != null) {
            this.mv.visitFrame(n2, n3, objectArray, n4, objectArray2);
        }
    }

    public void visitInsn(int n2) {
        if (this.mv != null) {
            this.mv.visitInsn(n2);
        }
    }

    public void visitIntInsn(int n2, int n3) {
        if (this.mv != null) {
            this.mv.visitIntInsn(n2, n3);
        }
    }

    public void visitVarInsn(int n2, int n3) {
        if (this.mv != null) {
            this.mv.visitVarInsn(n2, n3);
        }
    }

    public void visitTypeInsn(int n2, String string) {
        if (this.mv != null) {
            this.mv.visitTypeInsn(n2, string);
        }
    }

    public void visitFieldInsn(int n2, String string, String string2, String string3) {
        if (this.mv != null) {
            this.mv.visitFieldInsn(n2, string, string2, string3);
        }
    }

    @Deprecated
    public void visitMethodInsn(int n2, String string, String string2, String string3) {
        int n3 = n2 | (this.api < 327680 ? 256 : 0);
        this.visitMethodInsn(n3, string, string2, string3, n2 == 185);
    }

    public void visitMethodInsn(int n2, String string, String string2, String string3, boolean bl2) {
        if (this.api < 327680 && (n2 & 0x100) == 0) {
            if (bl2 != (n2 == 185)) {
                throw new UnsupportedOperationException("INVOKESPECIAL/STATIC on interfaces requires ASM5");
            }
            this.visitMethodInsn(n2, string, string2, string3);
            return;
        }
        if (this.mv != null) {
            this.mv.visitMethodInsn(n2 & 0xFFFFFEFF, string, string2, string3, bl2);
        }
    }

    public void visitInvokeDynamicInsn(String string, String string2, Handle handle, Object ... objectArray) {
        if (this.api < 327680) {
            throw new UnsupportedOperationException("This feature requires ASM5");
        }
        if (this.mv != null) {
            this.mv.visitInvokeDynamicInsn(string, string2, handle, objectArray);
        }
    }

    public void visitJumpInsn(int n2, Label label) {
        if (this.mv != null) {
            this.mv.visitJumpInsn(n2, label);
        }
    }

    public void visitLabel(Label label) {
        if (this.mv != null) {
            this.mv.visitLabel(label);
        }
    }

    public void visitLdcInsn(Object object) {
        if (this.api < 327680 && (object instanceof Handle || object instanceof Type && ((Type)object).getSort() == 11)) {
            throw new UnsupportedOperationException("This feature requires ASM5");
        }
        if (this.api < 458752 && object instanceof ConstantDynamic) {
            throw new UnsupportedOperationException("This feature requires ASM7");
        }
        if (this.mv != null) {
            this.mv.visitLdcInsn(object);
        }
    }

    public void visitIincInsn(int n2, int n3) {
        if (this.mv != null) {
            this.mv.visitIincInsn(n2, n3);
        }
    }

    public void visitTableSwitchInsn(int n2, int n3, Label label, Label ... labelArray) {
        if (this.mv != null) {
            this.mv.visitTableSwitchInsn(n2, n3, label, labelArray);
        }
    }

    public void visitLookupSwitchInsn(Label label, int[] nArray, Label[] labelArray) {
        if (this.mv != null) {
            this.mv.visitLookupSwitchInsn(label, nArray, labelArray);
        }
    }

    public void visitMultiANewArrayInsn(String string, int n2) {
        if (this.mv != null) {
            this.mv.visitMultiANewArrayInsn(string, n2);
        }
    }

    public AnnotationVisitor visitInsnAnnotation(int n2, TypePath typePath, String string, boolean bl2) {
        if (this.api < 327680) {
            throw new UnsupportedOperationException("This feature requires ASM5");
        }
        if (this.mv != null) {
            return this.mv.visitInsnAnnotation(n2, typePath, string, bl2);
        }
        return null;
    }

    public void visitTryCatchBlock(Label label, Label label2, Label label3, String string) {
        if (this.mv != null) {
            this.mv.visitTryCatchBlock(label, label2, label3, string);
        }
    }

    public AnnotationVisitor visitTryCatchAnnotation(int n2, TypePath typePath, String string, boolean bl2) {
        if (this.api < 327680) {
            throw new UnsupportedOperationException("This feature requires ASM5");
        }
        if (this.mv != null) {
            return this.mv.visitTryCatchAnnotation(n2, typePath, string, bl2);
        }
        return null;
    }

    public void visitLocalVariable(String string, String string2, String string3, Label label, Label label2, int n2) {
        if (this.mv != null) {
            this.mv.visitLocalVariable(string, string2, string3, label, label2, n2);
        }
    }

    public AnnotationVisitor visitLocalVariableAnnotation(int n2, TypePath typePath, Label[] labelArray, Label[] labelArray2, int[] nArray, String string, boolean bl2) {
        if (this.api < 327680) {
            throw new UnsupportedOperationException("This feature requires ASM5");
        }
        if (this.mv != null) {
            return this.mv.visitLocalVariableAnnotation(n2, typePath, labelArray, labelArray2, nArray, string, bl2);
        }
        return null;
    }

    public void visitLineNumber(int n2, Label label) {
        if (this.mv != null) {
            this.mv.visitLineNumber(n2, label);
        }
    }

    public void visitMaxs(int n2, int n3) {
        if (this.mv != null) {
            this.mv.visitMaxs(n2, n3);
        }
    }

    public void visitEnd() {
        if (this.mv != null) {
            this.mv.visitEnd();
        }
    }
}

