/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.io;

import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.io.CharTypes;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.io.UTF8Writer;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.util.ByteArrayBuilder;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.util.TextBuffer;
import java.util.Arrays;

public final class JsonStringEncoder {
    private static final char[] HC = CharTypes.copyHexChars();
    private static final byte[] HB = CharTypes.copyHexBytes();
    private static final JsonStringEncoder instance = new JsonStringEncoder();

    public static JsonStringEncoder getInstance() {
        return instance;
    }

    public char[] quoteAsString(String string) {
        int n2 = string.length();
        char[] cArray = new char[JsonStringEncoder._initialCharBufSize(n2)];
        int[] nArray = CharTypes.get7BitOutputEscapes();
        int n3 = nArray.length;
        int n4 = 0;
        TextBuffer textBuffer = null;
        int n5 = 0;
        char[] cArray2 = null;
        block0: while (n4 < n2) {
            int n6;
            int n7;
            char c2;
            while ((c2 = string.charAt(n4)) >= n3 || nArray[c2] == 0) {
                if (n5 >= cArray.length) {
                    if (textBuffer == null) {
                        textBuffer = TextBuffer.fromInitial(cArray);
                    }
                    cArray = textBuffer.finishCurrentSegment();
                    n5 = 0;
                }
                cArray[n5++] = c2;
                if (++n4 < n2) continue;
                break block0;
            }
            if (cArray2 == null) {
                cArray2 = this._qbuf();
            }
            int n8 = n7 = (n6 = nArray[c2 = string.charAt(n4++)]) < 0 ? this._appendNumeric(c2, cArray2) : this._appendNamed(n6, cArray2);
            if (n5 + n7 > cArray.length) {
                int n9 = cArray.length - n5;
                if (n9 > 0) {
                    System.arraycopy(cArray2, 0, cArray, n5, n9);
                }
                if (textBuffer == null) {
                    textBuffer = TextBuffer.fromInitial(cArray);
                }
                cArray = textBuffer.finishCurrentSegment();
                int n10 = n7 - n9;
                System.arraycopy(cArray2, n9, cArray, 0, n10);
                n5 = n10;
                continue;
            }
            System.arraycopy(cArray2, 0, cArray, n5, n7);
            n5 += n7;
        }
        if (textBuffer == null) {
            return Arrays.copyOfRange(cArray, 0, n5);
        }
        textBuffer.setCurrentLength(n5);
        return textBuffer.contentsAsArray();
    }

    public byte[] quoteAsUTF8(String string) {
        int n2 = 0;
        int n3 = string.length();
        int n4 = 0;
        byte[] byArray = new byte[JsonStringEncoder._initialByteBufSize(n3)];
        ByteArrayBuilder byteArrayBuilder = null;
        block0: while (n2 < n3) {
            int n5;
            int[] nArray = CharTypes.get7BitOutputEscapes();
            while ((n5 = string.charAt(n2)) <= 127 && nArray[n5] == 0) {
                if (n4 >= byArray.length) {
                    if (byteArrayBuilder == null) {
                        byteArrayBuilder = ByteArrayBuilder.fromInitial(byArray, n4);
                    }
                    byArray = byteArrayBuilder.finishCurrentSegment();
                    n4 = 0;
                }
                byArray[n4++] = (byte)n5;
                if (++n2 < n3) continue;
                break block0;
            }
            if (byteArrayBuilder == null) {
                byteArrayBuilder = ByteArrayBuilder.fromInitial(byArray, n4);
            }
            if (n4 >= byArray.length) {
                byArray = byteArrayBuilder.finishCurrentSegment();
                n4 = 0;
            }
            if ((n5 = string.charAt(n2++)) <= 127) {
                int n6 = nArray[n5];
                n4 = this._appendByte(n5, n6, byteArrayBuilder, n4);
                byArray = byteArrayBuilder.getCurrentSegment();
                continue;
            }
            if (n5 <= 2047) {
                byArray[n4++] = (byte)(0xC0 | n5 >> 6);
                n5 = 0x80 | n5 & 0x3F;
            } else if (n5 < 55296 || n5 > 57343) {
                byArray[n4++] = (byte)(0xE0 | n5 >> 12);
                if (n4 >= byArray.length) {
                    byArray = byteArrayBuilder.finishCurrentSegment();
                    n4 = 0;
                }
                byArray[n4++] = (byte)(0x80 | n5 >> 6 & 0x3F);
                n5 = 0x80 | n5 & 0x3F;
            } else {
                if (n5 > 56319) {
                    JsonStringEncoder._illegal(n5);
                }
                if (n2 >= n3) {
                    JsonStringEncoder._illegal(n5);
                }
                if ((n5 = JsonStringEncoder._convert(n5, string.charAt(n2++))) > 0x10FFFF) {
                    JsonStringEncoder._illegal(n5);
                }
                byArray[n4++] = (byte)(0xF0 | n5 >> 18);
                if (n4 >= byArray.length) {
                    byArray = byteArrayBuilder.finishCurrentSegment();
                    n4 = 0;
                }
                byArray[n4++] = (byte)(0x80 | n5 >> 12 & 0x3F);
                if (n4 >= byArray.length) {
                    byArray = byteArrayBuilder.finishCurrentSegment();
                    n4 = 0;
                }
                byArray[n4++] = (byte)(0x80 | n5 >> 6 & 0x3F);
                n5 = 0x80 | n5 & 0x3F;
            }
            if (n4 >= byArray.length) {
                byArray = byteArrayBuilder.finishCurrentSegment();
                n4 = 0;
            }
            byArray[n4++] = (byte)n5;
        }
        if (byteArrayBuilder == null) {
            return Arrays.copyOfRange(byArray, 0, n4);
        }
        return byteArrayBuilder.completeAndCoalesce(n4);
    }

    public byte[] encodeAsUTF8(String string) {
        int n2 = 0;
        int n3 = string.length();
        int n4 = 0;
        byte[] byArray = new byte[JsonStringEncoder._initialByteBufSize(n3)];
        int n5 = byArray.length;
        ByteArrayBuilder byteArrayBuilder = null;
        block0: while (n2 < n3) {
            int n6 = string.charAt(n2++);
            while (n6 <= 127) {
                if (n4 >= n5) {
                    if (byteArrayBuilder == null) {
                        byteArrayBuilder = ByteArrayBuilder.fromInitial(byArray, n4);
                    }
                    byArray = byteArrayBuilder.finishCurrentSegment();
                    n5 = byArray.length;
                    n4 = 0;
                }
                byArray[n4++] = (byte)n6;
                if (n2 >= n3) break block0;
                n6 = string.charAt(n2++);
            }
            if (byteArrayBuilder == null) {
                byteArrayBuilder = ByteArrayBuilder.fromInitial(byArray, n4);
            }
            if (n4 >= n5) {
                byArray = byteArrayBuilder.finishCurrentSegment();
                n5 = byArray.length;
                n4 = 0;
            }
            if (n6 < 2048) {
                byArray[n4++] = (byte)(0xC0 | n6 >> 6);
            } else if (n6 < 55296 || n6 > 57343) {
                byArray[n4++] = (byte)(0xE0 | n6 >> 12);
                if (n4 >= n5) {
                    byArray = byteArrayBuilder.finishCurrentSegment();
                    n5 = byArray.length;
                    n4 = 0;
                }
                byArray[n4++] = (byte)(0x80 | n6 >> 6 & 0x3F);
            } else {
                if (n6 > 56319) {
                    JsonStringEncoder._illegal(n6);
                }
                if (n2 >= n3) {
                    JsonStringEncoder._illegal(n6);
                }
                if ((n6 = JsonStringEncoder._convert(n6, string.charAt(n2++))) > 0x10FFFF) {
                    JsonStringEncoder._illegal(n6);
                }
                byArray[n4++] = (byte)(0xF0 | n6 >> 18);
                if (n4 >= n5) {
                    byArray = byteArrayBuilder.finishCurrentSegment();
                    n5 = byArray.length;
                    n4 = 0;
                }
                byArray[n4++] = (byte)(0x80 | n6 >> 12 & 0x3F);
                if (n4 >= n5) {
                    byArray = byteArrayBuilder.finishCurrentSegment();
                    n5 = byArray.length;
                    n4 = 0;
                }
                byArray[n4++] = (byte)(0x80 | n6 >> 6 & 0x3F);
            }
            if (n4 >= n5) {
                byArray = byteArrayBuilder.finishCurrentSegment();
                n5 = byArray.length;
                n4 = 0;
            }
            byArray[n4++] = (byte)(0x80 | n6 & 0x3F);
        }
        if (byteArrayBuilder == null) {
            return Arrays.copyOfRange(byArray, 0, n4);
        }
        return byteArrayBuilder.completeAndCoalesce(n4);
    }

    private char[] _qbuf() {
        char[] cArray = new char[6];
        cArray[0] = 92;
        cArray[2] = 48;
        cArray[3] = 48;
        return cArray;
    }

    private int _appendNumeric(int n2, char[] cArray) {
        cArray[1] = 117;
        cArray[4] = HC[n2 >> 4];
        cArray[5] = HC[n2 & 0xF];
        return 6;
    }

    private int _appendNamed(int n2, char[] cArray) {
        cArray[1] = (char)n2;
        return 2;
    }

    private int _appendByte(int n2, int n3, ByteArrayBuilder byteArrayBuilder, int n4) {
        byteArrayBuilder.setCurrentSegmentLength(n4);
        byteArrayBuilder.append(92);
        if (n3 < 0) {
            byteArrayBuilder.append(117);
            if (n2 > 255) {
                int n5 = n2 >> 8;
                byteArrayBuilder.append(HB[n5 >> 4]);
                byteArrayBuilder.append(HB[n5 & 0xF]);
                n2 &= 0xFF;
            } else {
                byteArrayBuilder.append(48);
                byteArrayBuilder.append(48);
            }
            byteArrayBuilder.append(HB[n2 >> 4]);
            byteArrayBuilder.append(HB[n2 & 0xF]);
        } else {
            byteArrayBuilder.append((byte)n3);
        }
        return byteArrayBuilder.getCurrentSegmentLength();
    }

    private static int _convert(int n2, int n3) {
        if (n3 < 56320 || n3 > 57343) {
            throw new IllegalArgumentException("Broken surrogate pair: first char 0x" + Integer.toHexString(n2) + ", second 0x" + Integer.toHexString(n3) + "; illegal combination");
        }
        return 65536 + (n2 - 55296 << 10) + (n3 - 56320);
    }

    private static void _illegal(int n2) {
        throw new IllegalArgumentException(UTF8Writer.illegalSurrogateDesc(n2));
    }

    static int _initialCharBufSize(int n2) {
        int n3 = Math.max(16, n2 + Math.min(6 + (n2 >> 3), 1000));
        return Math.min(n3, 32000);
    }

    static int _initialByteBufSize(int n2) {
        int n3 = Math.max(24, n2 + 6 + (n2 >> 1));
        return Math.min(n3, 32000);
    }
}

