/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.datatype.jsr310.deser;

import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.annotation.JsonFormat;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonParser;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonToken;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.DeserializationContext;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.DeserializationFeature;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.JavaType;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.datatype.jsr310.deser.JSR310DateTimeDeserializerBase;
import java.io.IOException;
import java.time.DateTimeException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

public class LocalDateTimeDeserializer
extends JSR310DateTimeDeserializerBase<LocalDateTime> {
    private static final DateTimeFormatter DEFAULT_FORMATTER = DateTimeFormatter.ISO_LOCAL_DATE_TIME;
    public static final LocalDateTimeDeserializer INSTANCE = new LocalDateTimeDeserializer();

    protected LocalDateTimeDeserializer() {
        this(DEFAULT_FORMATTER);
    }

    public LocalDateTimeDeserializer(DateTimeFormatter dateTimeFormatter) {
        super(LocalDateTime.class, dateTimeFormatter);
    }

    protected LocalDateTimeDeserializer(LocalDateTimeDeserializer localDateTimeDeserializer, Boolean bl2) {
        super(localDateTimeDeserializer, bl2);
    }

    protected LocalDateTimeDeserializer withDateFormat(DateTimeFormatter dateTimeFormatter) {
        return new LocalDateTimeDeserializer(dateTimeFormatter);
    }

    protected LocalDateTimeDeserializer withLeniency(Boolean bl2) {
        return new LocalDateTimeDeserializer(this, bl2);
    }

    protected LocalDateTimeDeserializer withShape(JsonFormat.Shape shape) {
        return this;
    }

    @Override
    public LocalDateTime deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        if (jsonParser.hasTokenId(6)) {
            return this._fromString(jsonParser, deserializationContext, jsonParser.getText());
        }
        if (jsonParser.isExpectedStartObjectToken()) {
            return this._fromString(jsonParser, deserializationContext, deserializationContext.extractScalarFromObject(jsonParser, this, this.handledType()));
        }
        if (jsonParser.isExpectedStartArrayToken()) {
            JsonToken jsonToken = jsonParser.nextToken();
            if (jsonToken == JsonToken.END_ARRAY) {
                return null;
            }
            if ((jsonToken == JsonToken.VALUE_STRING || jsonToken == JsonToken.VALUE_EMBEDDED_OBJECT) && deserializationContext.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
                LocalDateTime localDateTime = this.deserialize(jsonParser, deserializationContext);
                if (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                    this.handleMissingEndArrayForSingle(jsonParser, deserializationContext);
                }
                return localDateTime;
            }
            if (jsonToken == JsonToken.VALUE_NUMBER_INT) {
                LocalDateTime localDateTime;
                int n2 = jsonParser.getIntValue();
                int n3 = jsonParser.nextIntValue(-1);
                int n4 = jsonParser.nextIntValue(-1);
                int n5 = jsonParser.nextIntValue(-1);
                int n6 = jsonParser.nextIntValue(-1);
                jsonToken = jsonParser.nextToken();
                if (jsonToken == JsonToken.END_ARRAY) {
                    localDateTime = LocalDateTime.of(n2, n3, n4, n5, n6);
                } else {
                    int n7 = jsonParser.getIntValue();
                    jsonToken = jsonParser.nextToken();
                    if (jsonToken == JsonToken.END_ARRAY) {
                        localDateTime = LocalDateTime.of(n2, n3, n4, n5, n6, n7);
                    } else {
                        int n8 = jsonParser.getIntValue();
                        if (n8 < 1000 && !deserializationContext.isEnabled(DeserializationFeature.READ_DATE_TIMESTAMPS_AS_NANOSECONDS)) {
                            n8 *= 1000000;
                        }
                        if (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                            throw deserializationContext.wrongTokenException(jsonParser, this.handledType(), JsonToken.END_ARRAY, "Expected array to end");
                        }
                        localDateTime = LocalDateTime.of(n2, n3, n4, n5, n6, n7, n8);
                    }
                }
                return localDateTime;
            }
            deserializationContext.reportInputMismatch(this.handledType(), "Unexpected token (%s) within Array, expected VALUE_NUMBER_INT", new Object[]{jsonToken});
        }
        if (jsonParser.hasToken(JsonToken.VALUE_EMBEDDED_OBJECT)) {
            return (LocalDateTime)jsonParser.getEmbeddedObject();
        }
        if (jsonParser.hasToken(JsonToken.VALUE_NUMBER_INT)) {
            this._throwNoNumericTimestampNeedTimeZone(jsonParser, deserializationContext);
        }
        return (LocalDateTime)this._handleUnexpectedToken(deserializationContext, jsonParser, "Expected array or string.", new Object[0]);
    }

    protected LocalDateTime _fromString(JsonParser jsonParser, DeserializationContext deserializationContext, String string) throws IOException {
        String string2 = string.trim();
        if (string2.length() == 0) {
            return (LocalDateTime)this._fromEmptyString(jsonParser, deserializationContext, string2);
        }
        try {
            if (this._formatter == DEFAULT_FORMATTER && string2.length() > 10 && string2.charAt(10) == 'T' && string2.endsWith("Z")) {
                if (this.isLenient()) {
                    return LocalDateTime.parse(string2.substring(0, string2.length() - 1), this._formatter);
                }
                JavaType javaType = this.getValueType(deserializationContext);
                return (LocalDateTime)deserializationContext.handleWeirdStringValue(javaType.getRawClass(), string2, "Should not contain offset when 'strict' mode set for property or type (enable 'lenient' handling to allow)", new Object[0]);
            }
            return LocalDateTime.parse(string2, this._formatter);
        }
        catch (DateTimeException dateTimeException) {
            return (LocalDateTime)this._handleDateTimeException(deserializationContext, dateTimeException, string2);
        }
    }
}

