/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.google.common.collect;

import com.gradle.scan.plugin.internal.dep.com.google.common.base.Objects;
import com.gradle.scan.plugin.internal.dep.com.google.common.base.Preconditions;
import com.gradle.scan.plugin.internal.dep.com.google.common.collect.Iterators;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;
import javax.annotation.CheckForNull;

public final class Lists {
    static boolean equalsImpl(List<?> list, @CheckForNull Object object) {
        if (object == Preconditions.checkNotNull(list)) {
            return true;
        }
        if (!(object instanceof List)) {
            return false;
        }
        List list2 = (List)object;
        int n2 = list.size();
        if (n2 != list2.size()) {
            return false;
        }
        if (list instanceof RandomAccess && list2 instanceof RandomAccess) {
            for (int i2 = 0; i2 < n2; ++i2) {
                if (Objects.equal(list.get(i2), list2.get(i2))) continue;
                return false;
            }
            return true;
        }
        return Iterators.elementsEqual(list.iterator(), list2.iterator());
    }

    static int indexOfImpl(List<?> list, @CheckForNull Object object) {
        if (list instanceof RandomAccess) {
            return Lists.indexOfRandomAccess(list, object);
        }
        ListIterator<?> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            if (!Objects.equal(object, listIterator.next())) continue;
            return listIterator.previousIndex();
        }
        return -1;
    }

    private static int indexOfRandomAccess(List<?> list, @CheckForNull Object object) {
        int n2 = list.size();
        if (object == null) {
            for (int i2 = 0; i2 < n2; ++i2) {
                if (list.get(i2) != null) continue;
                return i2;
            }
        } else {
            for (int i3 = 0; i3 < n2; ++i3) {
                if (!object.equals(list.get(i3))) continue;
                return i3;
            }
        }
        return -1;
    }

    static int lastIndexOfImpl(List<?> list, @CheckForNull Object object) {
        if (list instanceof RandomAccess) {
            return Lists.lastIndexOfRandomAccess(list, object);
        }
        ListIterator<?> listIterator = list.listIterator(list.size());
        while (listIterator.hasPrevious()) {
            if (!Objects.equal(object, listIterator.previous())) continue;
            return listIterator.nextIndex();
        }
        return -1;
    }

    private static int lastIndexOfRandomAccess(List<?> list, @CheckForNull Object object) {
        if (object == null) {
            for (int i2 = list.size() - 1; i2 >= 0; --i2) {
                if (list.get(i2) != null) continue;
                return i2;
            }
        } else {
            for (int i3 = list.size() - 1; i3 >= 0; --i3) {
                if (!object.equals(list.get(i3))) continue;
                return i3;
            }
        }
        return -1;
    }
}

