/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.google.common.hash;

import java.io.Serializable;
import javax.annotation.CheckForNull;

public abstract class HashCode {
    private static final char[] hexDigits = "0123456789abcdef".toCharArray();

    HashCode() {
    }

    public abstract int bits();

    public abstract int asInt();

    public abstract long asLong();

    public abstract byte[] asBytes();

    byte[] getBytesInternal() {
        return this.asBytes();
    }

    abstract boolean equalsSameBits(HashCode var1);

    public static HashCode fromLong(long l2) {
        return new LongHashCode(l2);
    }

    public final boolean equals(@CheckForNull Object object) {
        if (object instanceof HashCode) {
            HashCode hashCode = (HashCode)object;
            return this.bits() == hashCode.bits() && this.equalsSameBits(hashCode);
        }
        return false;
    }

    public final int hashCode() {
        if (this.bits() >= 32) {
            return this.asInt();
        }
        byte[] byArray = this.getBytesInternal();
        int n2 = byArray[0] & 0xFF;
        for (int i2 = 1; i2 < byArray.length; ++i2) {
            n2 |= (byArray[i2] & 0xFF) << i2 * 8;
        }
        return n2;
    }

    public final String toString() {
        byte[] byArray = this.getBytesInternal();
        StringBuilder stringBuilder = new StringBuilder(2 * byArray.length);
        for (byte by2 : byArray) {
            stringBuilder.append(hexDigits[by2 >> 4 & 0xF]).append(hexDigits[by2 & 0xF]);
        }
        return stringBuilder.toString();
    }

    private static final class LongHashCode
    extends HashCode
    implements Serializable {
        final long hash;

        LongHashCode(long l2) {
            this.hash = l2;
        }

        @Override
        public int bits() {
            return 64;
        }

        @Override
        public byte[] asBytes() {
            return new byte[]{(byte)this.hash, (byte)(this.hash >> 8), (byte)(this.hash >> 16), (byte)(this.hash >> 24), (byte)(this.hash >> 32), (byte)(this.hash >> 40), (byte)(this.hash >> 48), (byte)(this.hash >> 56)};
        }

        @Override
        public int asInt() {
            return (int)this.hash;
        }

        @Override
        public long asLong() {
            return this.hash;
        }

        @Override
        boolean equalsSameBits(HashCode hashCode) {
            return this.hash == hashCode.asLong();
        }
    }
}

