/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.apache.commons.compress.utils;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class CountingInputStream
extends FilterInputStream {
    private long bytesRead;

    public CountingInputStream(InputStream inputStream) {
        super(inputStream);
    }

    @Override
    public int read() throws IOException {
        int n2 = this.in.read();
        if (n2 >= 0) {
            this.count(1L);
        }
        return n2;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        if (n3 == 0) {
            return 0;
        }
        int n4 = this.in.read(byArray, n2, n3);
        if (n4 >= 0) {
            this.count(n4);
        }
        return n4;
    }

    protected final void count(long l2) {
        if (l2 != -1L) {
            this.bytesRead += l2;
        }
    }
}

