/*
 * Decompiled with CFR 0.152.
 */
package graphql.validation.constraints.standard;

import graphql.GraphQLError;
import graphql.Scalars;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLScalarType;
import graphql.validation.constraints.AbstractDirectiveConstraint;
import graphql.validation.rules.ValidationEnvironment;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

abstract class AbstractPositiveNegativeConstraint
extends AbstractDirectiveConstraint {
    public AbstractPositiveNegativeConstraint(String name) {
        super(name);
    }

    @Override
    public boolean appliesToType(GraphQLInputType inputType) {
        return this.isOneOfTheseTypes(inputType, Scalars.GraphQLByte, Scalars.GraphQLShort, Scalars.GraphQLInt, Scalars.GraphQLLong, Scalars.GraphQLBigDecimal, Scalars.GraphQLBigInteger, Scalars.GraphQLFloat);
    }

    public List<String> getApplicableTypeNames() {
        return Stream.of(Scalars.GraphQLByte, Scalars.GraphQLShort, Scalars.GraphQLInt, Scalars.GraphQLLong, Scalars.GraphQLBigDecimal, Scalars.GraphQLBigInteger, Scalars.GraphQLFloat).map(GraphQLScalarType::getName).collect(Collectors.toList());
    }

    @Override
    protected List<GraphQLError> runConstraint(ValidationEnvironment validationEnvironment) {
        boolean isOK;
        Object validatedValue = validationEnvironment.getValidatedValue();
        if (validatedValue == null) {
            return Collections.emptyList();
        }
        GraphQLDirective directive = validationEnvironment.getContextObject(GraphQLDirective.class, new Object[0]);
        try {
            BigDecimal bigDecimal = this.asBigDecimal(validatedValue);
            isOK = this.isOK(bigDecimal);
        }
        catch (NumberFormatException nfe) {
            isOK = false;
        }
        if (!isOK) {
            return this.mkError(validationEnvironment, directive, this.mkMessageParams(validatedValue, validationEnvironment, new Object[0]));
        }
        return Collections.emptyList();
    }

    protected abstract boolean isOK(BigDecimal var1);
}

