/*
 * Decompiled with CFR 0.152.
 */
package graphql.validation.el;

import graphql.Internal;
import graphql.validation.el.BetterMapELResolver;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ELManager;
import javax.el.ELResolver;
import javax.el.ExpressionFactory;
import javax.el.StandardELContext;
import javax.el.ValueExpression;
import org.hibernate.validator.internal.engine.messageinterpolation.FormatterWrapper;

@Internal
public class ELSupport {
    private static final ExpressionFactory expressionFactory = ELSupport.loadExpressionSupport();
    private final StandardELContext elContext = new StandardELContext(expressionFactory);

    public ELSupport(Locale locale) {
        this.elContext.setLocale(locale);
        this.elContext.addELResolver((ELResolver)new BetterMapELResolver());
        this.bindVariable((ELContext)this.elContext, "formatter", new FormatterWrapper(locale));
    }

    private static ExpressionFactory loadExpressionSupport() {
        return ELManager.getExpressionFactory();
    }

    private void bindMethod(String bindName, String methodName, Class<?> ... args) {
        this.elContext.getFunctionMapper().mapFunction("", bindName, this.loadMethod(methodName, args));
    }

    private Method loadMethod(String name, Class<?> ... args) {
        try {
            return ELSupport.class.getMethod(name, args);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
    }

    private ValueExpression bindVariable(ELContext elContext, String variableName, Object variableValue) {
        ValueExpression valueExpression = expressionFactory.createValueExpression(variableValue, Object.class);
        return elContext.getVariableMapper().setVariable(variableName, valueExpression);
    }

    public boolean evaluateBoolean(String expression, Map<String, Object> variables) {
        return this.evaluateImpl(expression, variables, Boolean.class);
    }

    public Object evaluate(String expression, Map<String, Object> variables) {
        return this.evaluateImpl(expression, variables, Object.class);
    }

    private <T> T evaluateImpl(String expression, Map<String, Object> variables, Class<T> expectedResultClass) {
        StandardELContext context = new StandardELContext((ELContext)this.elContext);
        for (Map.Entry<String, Object> entry : variables.entrySet()) {
            this.bindVariable((ELContext)context, entry.getKey(), entry.getValue());
        }
        ValueExpression result = expressionFactory.createValueExpression((ELContext)context, expression, expectedResultClass);
        Object value = result.getValue((ELContext)context);
        return (T)value;
    }
}

