/*
 * Decompiled with CFR 0.152.
 */
package graphql.validation.rules;

import graphql.Assert;
import graphql.GraphQLError;
import graphql.PublicApi;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.GraphQLObjectType;
import graphql.validation.constraints.DirectiveConstraints;
import graphql.validation.interpolation.MessageInterpolator;
import graphql.validation.interpolation.ResourceBundleMessageInterpolator;
import graphql.validation.rules.OnValidationErrorStrategy;
import graphql.validation.rules.TargetedValidationRules;
import graphql.validation.rules.ValidationCoordinates;
import graphql.validation.rules.ValidationRule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;

@PublicApi
public class ValidationRules {
    private final OnValidationErrorStrategy onValidationErrorStrategy;
    private final List<ValidationRule> rules;
    private final MessageInterpolator messageInterpolator;
    private final Locale locale;

    private ValidationRules(Builder builder) {
        this.rules = Collections.unmodifiableList(builder.rules);
        this.messageInterpolator = builder.messageInterpolator;
        this.onValidationErrorStrategy = builder.onValidationErrorStrategy;
        this.locale = builder.locale;
    }

    public MessageInterpolator getMessageInterpolator() {
        return this.messageInterpolator;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public List<ValidationRule> getRules() {
        return this.rules;
    }

    public OnValidationErrorStrategy getOnValidationErrorStrategy() {
        return this.onValidationErrorStrategy;
    }

    public TargetedValidationRules buildRulesFor(GraphQLFieldDefinition fieldDefinition, GraphQLFieldsContainer fieldsContainer) {
        TargetedValidationRules.Builder rulesBuilder = TargetedValidationRules.newValidationRules();
        ValidationCoordinates fieldCoordinates = ValidationCoordinates.newCoordinates(fieldsContainer, fieldDefinition);
        List<ValidationRule> fieldRules = this.getRulesFor(fieldDefinition, fieldsContainer);
        rulesBuilder.addRules(fieldCoordinates, fieldRules);
        for (GraphQLArgument fieldArg : fieldDefinition.getArguments()) {
            ValidationCoordinates validationCoordinates = ValidationCoordinates.newCoordinates(fieldsContainer, fieldDefinition, fieldArg);
            List<ValidationRule> rules = this.getRulesFor(fieldArg, fieldDefinition, fieldsContainer);
            rulesBuilder.addRules(validationCoordinates, rules);
        }
        return rulesBuilder.build();
    }

    public List<ValidationRule> getRulesFor(GraphQLArgument fieldArg, GraphQLFieldDefinition fieldDefinition, GraphQLFieldsContainer fieldsContainer) {
        return this.rules.stream().filter(rule -> rule.appliesTo(fieldArg, fieldDefinition, fieldsContainer)).collect(Collectors.toList());
    }

    public List<ValidationRule> getRulesFor(GraphQLFieldDefinition fieldDefinition, GraphQLFieldsContainer fieldsContainer) {
        return this.rules.stream().filter(rule -> rule.appliesTo(fieldDefinition, fieldsContainer)).collect(Collectors.toList());
    }

    public List<GraphQLError> runValidationRules(DataFetchingEnvironment env) {
        GraphQLObjectType fieldsContainer = env.getExecutionStepInfo().getFieldContainer();
        GraphQLFieldDefinition fieldDefinition = env.getFieldDefinition();
        MessageInterpolator messageInterpolator = this.getMessageInterpolator();
        TargetedValidationRules rules = this.buildRulesFor(fieldDefinition, (GraphQLFieldsContainer)fieldsContainer);
        return rules.runValidationRules(env, messageInterpolator, this.getLocale());
    }

    public static Builder newValidationRules() {
        return new Builder();
    }

    public static class Builder {
        private Locale locale;
        private OnValidationErrorStrategy onValidationErrorStrategy = OnValidationErrorStrategy.RETURN_NULL;
        private MessageInterpolator messageInterpolator = new ResourceBundleMessageInterpolator();
        private List<ValidationRule> rules = new ArrayList<ValidationRule>();

        public Builder() {
            this.addRules(DirectiveConstraints.STANDARD_CONSTRAINTS);
        }

        public Builder addRule(ValidationRule rule) {
            this.rules.add((ValidationRule)Assert.assertNotNull((Object)rule));
            return this;
        }

        public Builder addRules(Collection<? extends ValidationRule> rules) {
            rules.forEach(this::addRule);
            return this;
        }

        public Builder addRules(ValidationRule ... rules) {
            return this.addRules(Arrays.asList(rules));
        }

        public Builder clearRules() {
            this.rules.clear();
            return this;
        }

        public Builder messageInterpolator(MessageInterpolator messageInterpolator) {
            this.messageInterpolator = (MessageInterpolator)Assert.assertNotNull((Object)messageInterpolator);
            return this;
        }

        public Builder locale(Locale locale) {
            this.locale = locale;
            return this;
        }

        public Builder onValidationErrorStrategy(OnValidationErrorStrategy onValidationErrorStrategy) {
            this.onValidationErrorStrategy = (OnValidationErrorStrategy)Assert.assertNotNull((Object)onValidationErrorStrategy);
            return this;
        }

        public ValidationRules build() {
            return new ValidationRules(this);
        }
    }
}

