/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.metrics.metricsets;

import com.hazelcast.internal.metrics.MetricsRegistry;
import com.hazelcast.internal.metrics.ProbeLevel;
import com.hazelcast.internal.util.Preconditions;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;

public final class ThreadMetricSet {
    private ThreadMetricSet() {
    }

    public static void register(MetricsRegistry metricsRegistry) {
        Preconditions.checkNotNull(metricsRegistry, "metricsRegistry");
        ThreadMXBean mxBean = ManagementFactory.getThreadMXBean();
        metricsRegistry.registerStaticProbe(mxBean, "thread.threadCount", ProbeLevel.MANDATORY, ThreadMXBean::getThreadCount);
        metricsRegistry.registerStaticProbe(mxBean, "thread.peakThreadCount", ProbeLevel.MANDATORY, ThreadMXBean::getPeakThreadCount);
        metricsRegistry.registerStaticProbe(mxBean, "thread.daemonThreadCount", ProbeLevel.MANDATORY, ThreadMXBean::getDaemonThreadCount);
        metricsRegistry.registerStaticProbe(mxBean, "thread.totalStartedThreadCount", ProbeLevel.MANDATORY, ThreadMXBean::getTotalStartedThreadCount);
    }
}

