/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.util;

import java.security.SecureRandom;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;

public final class ThreadLocalRandomProvider {
    private static final ThreadLocal<SecureRandom> THREAD_LOCAL_SECURE_RANDOM = new ThreadLocal();

    private ThreadLocalRandomProvider() {
    }

    public static Random get() {
        return ThreadLocalRandom.current();
    }

    public static SecureRandom getSecure() {
        SecureRandom random = THREAD_LOCAL_SECURE_RANDOM.get();
        if (random == null) {
            random = new SecureRandom();
            THREAD_LOCAL_SECURE_RANDOM.set(random);
        }
        return random;
    }
}

