/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.serialization;

import com.hazelcast.internal.serialization.impl.portable.PortableGenericRecordBuilder;
import com.hazelcast.nio.serialization.ClassDefinition;
import com.hazelcast.nio.serialization.GenericRecord;
import com.hazelcast.spi.annotation.Beta;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@Beta
public interface GenericRecordBuilder {
    @Nonnull
    public static GenericRecordBuilder portable(@Nonnull ClassDefinition classDefinition) {
        return new PortableGenericRecordBuilder(classDefinition);
    }

    @Nonnull
    public GenericRecord build();

    @Nonnull
    public GenericRecordBuilder setBoolean(@Nonnull String var1, boolean var2);

    @Nonnull
    public GenericRecordBuilder setByte(@Nonnull String var1, byte var2);

    @Nonnull
    public GenericRecordBuilder setChar(@Nonnull String var1, char var2);

    @Nonnull
    public GenericRecordBuilder setDouble(@Nonnull String var1, double var2);

    @Nonnull
    public GenericRecordBuilder setFloat(@Nonnull String var1, float var2);

    @Nonnull
    public GenericRecordBuilder setInt(@Nonnull String var1, int var2);

    @Nonnull
    public GenericRecordBuilder setLong(@Nonnull String var1, long var2);

    @Nonnull
    public GenericRecordBuilder setShort(@Nonnull String var1, short var2);

    @Nonnull
    public GenericRecordBuilder setString(@Nonnull String var1, @Nullable String var2);

    @Nonnull
    public GenericRecordBuilder setGenericRecord(@Nonnull String var1, @Nullable GenericRecord var2);

    @Nonnull
    public GenericRecordBuilder setDecimal(@Nonnull String var1, @Nullable BigDecimal var2);

    @Nonnull
    public GenericRecordBuilder setTime(@Nonnull String var1, @Nullable LocalTime var2);

    @Nonnull
    public GenericRecordBuilder setDate(@Nonnull String var1, @Nullable LocalDate var2);

    @Nonnull
    public GenericRecordBuilder setTimestamp(@Nonnull String var1, @Nullable LocalDateTime var2);

    @Nonnull
    public GenericRecordBuilder setTimestampWithTimezone(@Nonnull String var1, @Nullable OffsetDateTime var2);

    @Nonnull
    public GenericRecordBuilder setBooleanArray(@Nonnull String var1, @Nullable boolean[] var2);

    @Nonnull
    public GenericRecordBuilder setByteArray(@Nonnull String var1, @Nullable byte[] var2);

    @Nonnull
    public GenericRecordBuilder setCharArray(@Nonnull String var1, @Nullable char[] var2);

    @Nonnull
    public GenericRecordBuilder setFloatArray(@Nonnull String var1, @Nullable float[] var2);

    @Nonnull
    public GenericRecordBuilder setIntArray(@Nonnull String var1, @Nullable int[] var2);

    @Nonnull
    public GenericRecordBuilder setDoubleArray(@Nonnull String var1, @Nullable double[] var2);

    @Nonnull
    public GenericRecordBuilder setLongArray(@Nonnull String var1, @Nullable long[] var2);

    @Nonnull
    public GenericRecordBuilder setShortArray(@Nonnull String var1, @Nullable short[] var2);

    @Nonnull
    public GenericRecordBuilder setStringArray(@Nonnull String var1, @Nullable String[] var2);

    @Nonnull
    public GenericRecordBuilder setDecimalArray(@Nonnull String var1, @Nullable BigDecimal[] var2);

    @Nonnull
    public GenericRecordBuilder setTimeArray(@Nonnull String var1, @Nullable LocalTime[] var2);

    @Nonnull
    public GenericRecordBuilder setDateArray(@Nonnull String var1, @Nullable LocalDate[] var2);

    @Nonnull
    public GenericRecordBuilder setTimestampArray(@Nonnull String var1, @Nullable LocalDateTime[] var2);

    @Nonnull
    public GenericRecordBuilder setTimestampWithTimezoneArray(@Nonnull String var1, @Nullable OffsetDateTime[] var2);

    @Nonnull
    public GenericRecordBuilder setGenericRecordArray(@Nonnull String var1, @Nullable GenericRecord[] var2);
}

