/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.rel.rules;

import com.hazelcast.org.apache.calcite.plan.Contexts;
import com.hazelcast.org.apache.calcite.plan.RelOptRule;
import com.hazelcast.org.apache.calcite.plan.RelOptRuleCall;
import com.hazelcast.org.apache.calcite.plan.RelOptUtil;
import com.hazelcast.org.apache.calcite.rel.RelNode;
import com.hazelcast.org.apache.calcite.rel.core.Join;
import com.hazelcast.org.apache.calcite.rel.core.JoinRelType;
import com.hazelcast.org.apache.calcite.rel.core.RelFactories;
import com.hazelcast.org.apache.calcite.rel.logical.LogicalJoin;
import com.hazelcast.org.apache.calcite.rel.rules.TransformationRule;
import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.rel.type.RelDataTypeField;
import com.hazelcast.org.apache.calcite.rex.RexBuilder;
import com.hazelcast.org.apache.calcite.rex.RexInputRef;
import com.hazelcast.org.apache.calcite.rex.RexNode;
import com.hazelcast.org.apache.calcite.rex.RexShuttle;
import com.hazelcast.org.apache.calcite.tools.RelBuilder;
import com.hazelcast.org.apache.calcite.tools.RelBuilderFactory;
import java.util.List;

public class JoinCommuteRule
extends RelOptRule
implements TransformationRule {
    public static final JoinCommuteRule INSTANCE = new JoinCommuteRule(false);
    public static final JoinCommuteRule SWAP_OUTER = new JoinCommuteRule(true);
    private final boolean swapOuter;

    public JoinCommuteRule(Class<? extends Join> clazz, RelBuilderFactory relBuilderFactory, boolean swapOuter) {
        super(JoinCommuteRule.operandJ(clazz, null, j -> j.getLeft().getId() != j.getRight().getId() && j.getSystemFieldList().isEmpty(), JoinCommuteRule.any()), relBuilderFactory, null);
        this.swapOuter = swapOuter;
    }

    private JoinCommuteRule(boolean swapOuter) {
        this(LogicalJoin.class, RelFactories.LOGICAL_BUILDER, swapOuter);
    }

    @Deprecated
    public JoinCommuteRule(Class<? extends Join> clazz, RelFactories.ProjectFactory projectFactory) {
        this(clazz, RelBuilder.proto(Contexts.of((Object)projectFactory)), false);
    }

    @Deprecated
    public JoinCommuteRule(Class<? extends Join> clazz, RelFactories.ProjectFactory projectFactory, boolean swapOuter) {
        this(clazz, RelBuilder.proto(Contexts.of((Object)projectFactory)), swapOuter);
    }

    @Deprecated
    public static RelNode swap(Join join) {
        return JoinCommuteRule.swap(join, false, RelFactories.LOGICAL_BUILDER.create(join.getCluster(), null));
    }

    @Deprecated
    public static RelNode swap(Join join, boolean swapOuterJoins) {
        return JoinCommuteRule.swap(join, swapOuterJoins, RelFactories.LOGICAL_BUILDER.create(join.getCluster(), null));
    }

    public static RelNode swap(Join join, boolean swapOuterJoins, RelBuilder relBuilder) {
        JoinRelType joinType = join.getJoinType();
        if (!swapOuterJoins && joinType != JoinRelType.INNER) {
            return null;
        }
        RexBuilder rexBuilder = join.getCluster().getRexBuilder();
        RelDataType leftRowType = join.getLeft().getRowType();
        RelDataType rightRowType = join.getRight().getRowType();
        VariableReplacer variableReplacer = new VariableReplacer(rexBuilder, leftRowType, rightRowType);
        RexNode oldCondition = join.getCondition();
        RexNode condition = variableReplacer.apply(oldCondition);
        Join newJoin = join.copy(join.getTraitSet(), condition, join.getRight(), join.getLeft(), joinType.swap(), join.isSemiJoinDone());
        List<RexNode> exps = RelOptUtil.createSwappedJoinExprs(newJoin, join, true);
        return relBuilder.push(newJoin).project(exps, join.getRowType().getFieldNames()).build();
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Join join = (Join)call.rel(0);
        RelNode swapped = JoinCommuteRule.swap(join, this.swapOuter, call.builder());
        if (swapped == null) {
            return;
        }
        Join newJoin = swapped instanceof Join ? (Join)swapped : (Join)swapped.getInput(0);
        call.transformTo(swapped);
        RelBuilder relBuilder = call.builder();
        List<RexNode> exps = RelOptUtil.createSwappedJoinExprs(newJoin, join, false);
        relBuilder.push(swapped).project(exps, newJoin.getRowType().getFieldNames());
        call.getPlanner().ensureRegistered(relBuilder.build(), newJoin);
    }

    private static class VariableReplacer
    extends RexShuttle {
        private final RexBuilder rexBuilder;
        private final List<RelDataTypeField> leftFields;
        private final List<RelDataTypeField> rightFields;

        VariableReplacer(RexBuilder rexBuilder, RelDataType leftType, RelDataType rightType) {
            this.rexBuilder = rexBuilder;
            this.leftFields = leftType.getFieldList();
            this.rightFields = rightType.getFieldList();
        }

        @Override
        public RexNode visitInputRef(RexInputRef inputRef) {
            int index = inputRef.getIndex();
            if (index < this.leftFields.size()) {
                return this.rexBuilder.makeInputRef(this.leftFields.get(index).getType(), this.rightFields.size() + index);
            }
            if ((index -= this.leftFields.size()) < this.rightFields.size()) {
                return this.rexBuilder.makeInputRef(this.rightFields.get(index).getType(), index);
            }
            throw new AssertionError((Object)("Bad field offset: index=" + inputRef.getIndex() + ", leftFieldCount=" + this.leftFields.size() + ", rightFieldCount=" + this.rightFields.size()));
        }
    }
}

