/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.sql;

import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.sql.SqlCall;
import com.hazelcast.org.apache.calcite.sql.SqlCallBinding;
import com.hazelcast.org.apache.calcite.sql.SqlKind;
import com.hazelcast.org.apache.calcite.sql.SqlNode;
import com.hazelcast.org.apache.calcite.sql.SqlOperandCountRange;
import com.hazelcast.org.apache.calcite.sql.SqlWindowTableFunction;
import com.hazelcast.org.apache.calcite.sql.type.SqlOperandCountRanges;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeUtil;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidator;

public class SqlHopTableFunction
extends SqlWindowTableFunction {
    public SqlHopTableFunction() {
        super(SqlKind.HOP.name());
    }

    @Override
    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.of(4);
    }

    @Override
    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        SqlNode operand0 = callBinding.operand(0);
        SqlValidator validator = callBinding.getValidator();
        RelDataType type = validator.getValidatedNodeType(operand0);
        if (type.getSqlTypeName() != SqlTypeName.ROW) {
            return this.throwValidationSignatureErrorOrReturnFalse(callBinding, throwOnFailure);
        }
        SqlNode operand1 = callBinding.operand(1);
        if (operand1.getKind() != SqlKind.DESCRIPTOR) {
            return this.throwValidationSignatureErrorOrReturnFalse(callBinding, throwOnFailure);
        }
        this.validateColumnNames(validator, type.getFieldNames(), ((SqlCall)operand1).getOperandList());
        RelDataType type2 = validator.getValidatedNodeType(callBinding.operand(2));
        if (!SqlTypeUtil.isInterval(type2)) {
            return this.throwValidationSignatureErrorOrReturnFalse(callBinding, throwOnFailure);
        }
        RelDataType type3 = validator.getValidatedNodeType(callBinding.operand(3));
        if (!SqlTypeUtil.isInterval(type3)) {
            return this.throwValidationSignatureErrorOrReturnFalse(callBinding, throwOnFailure);
        }
        return true;
    }

    @Override
    public String getAllowedSignatures(String opNameToUse) {
        return this.getName() + "(TABLE table_name, DESCRIPTOR(col), datetime interval, datetime interval)";
    }
}

