/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.hibernate;

import com.hazelcast.hibernate.HazelcastStorageAccess;
import com.hazelcast.hibernate.RegionCache;
import com.hazelcast.logging.Logger;
import java.util.function.Consumer;
import java.util.function.Function;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.engine.spi.SharedSessionContractImplementor;

public class HazelcastStorageAccessImpl
implements HazelcastStorageAccess {
    private final RegionCache delegate;
    private final boolean fallback;

    HazelcastStorageAccessImpl(RegionCache delegate, boolean fallback) {
        this.delegate = delegate;
        this.fallback = fallback;
    }

    @Override
    public void afterUpdate(Object key, Object newValue, Object newVersion) {
        this.tryWithFallback(cache -> cache.afterUpdate(key, newValue, newVersion));
    }

    public boolean contains(Object key) {
        return this.tryWithFallback(cache -> cache.contains(key), false);
    }

    public void evictData() throws CacheException {
        this.tryWithFallback(RegionCache::evictData);
    }

    public void evictData(Object key) throws CacheException {
        this.tryWithFallback(cache -> cache.evictData(key));
    }

    public Object getFromCache(Object key, SharedSessionContractImplementor session) throws CacheException {
        return this.tryWithFallback(cache -> cache.get(key, this.delegate.nextTimestamp()), null);
    }

    public void putIntoCache(Object key, Object value, SharedSessionContractImplementor session) throws CacheException {
        this.tryWithFallback(cache -> cache.put(key, value, this.delegate.nextTimestamp(), null));
    }

    public void release() {
        this.delegate.destroy();
    }

    @Override
    public void unlockItem(Object key, SoftLock lock) {
        this.tryWithFallback(cache -> cache.unlockItem(key, lock));
    }

    RegionCache getDelegate() {
        return this.delegate;
    }

    private void tryWithFallback(Consumer<RegionCache> action) {
        this.tryWithFallback(cache -> {
            action.accept((RegionCache)cache);
            return null;
        }, null);
    }

    private <T> T tryWithFallback(Function<RegionCache, T> action, T fallbackValue) {
        try {
            return action.apply(this.delegate);
        }
        catch (Exception e) {
            if (this.fallback) {
                Logger.getLogger(HazelcastStorageAccessImpl.class).finest(e.getMessage(), e);
                return fallbackValue;
            }
            if (e instanceof CacheException) {
                throw e;
            }
            throw new CacheException((Throwable)e);
        }
    }
}

