/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.rel.rules;

import com.hazelcast.org.apache.calcite.plan.RelOptRule;
import com.hazelcast.org.apache.calcite.plan.RelOptRuleCall;
import com.hazelcast.org.apache.calcite.plan.RelOptRuleOperand;
import com.hazelcast.org.apache.calcite.plan.hep.HepRelVertex;
import com.hazelcast.org.apache.calcite.plan.volcano.RelSubset;
import com.hazelcast.org.apache.calcite.rel.RelNode;
import com.hazelcast.org.apache.calcite.rel.RelShuttleImpl;
import com.hazelcast.org.apache.calcite.rel.core.Correlate;
import com.hazelcast.org.apache.calcite.rel.core.CorrelationId;
import com.hazelcast.org.apache.calcite.rel.core.Project;
import com.hazelcast.org.apache.calcite.rel.core.RelFactories;
import com.hazelcast.org.apache.calcite.rel.rules.PushProjector;
import com.hazelcast.org.apache.calcite.rel.rules.TransformationRule;
import com.hazelcast.org.apache.calcite.rex.RexBuilder;
import com.hazelcast.org.apache.calcite.rex.RexCorrelVariable;
import com.hazelcast.org.apache.calcite.rex.RexFieldAccess;
import com.hazelcast.org.apache.calcite.rex.RexNode;
import com.hazelcast.org.apache.calcite.rex.RexOver;
import com.hazelcast.org.apache.calcite.rex.RexShuttle;
import com.hazelcast.org.apache.calcite.tools.RelBuilderFactory;
import com.hazelcast.org.apache.calcite.util.BitSets;
import com.hazelcast.org.apache.calcite.util.ImmutableBitSet;
import com.hazelcast.org.apache.calcite.util.Util;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;

public class ProjectCorrelateTransposeRule
extends RelOptRule
implements TransformationRule {
    public static final ProjectCorrelateTransposeRule INSTANCE = new ProjectCorrelateTransposeRule(expr -> !(expr instanceof RexOver), RelFactories.LOGICAL_BUILDER);
    private final PushProjector.ExprCondition preserveExprCondition;

    public ProjectCorrelateTransposeRule(PushProjector.ExprCondition preserveExprCondition, RelBuilderFactory relFactory) {
        super(ProjectCorrelateTransposeRule.operand(Project.class, ProjectCorrelateTransposeRule.operand(Correlate.class, ProjectCorrelateTransposeRule.any()), new RelOptRuleOperand[0]), relFactory, null);
        this.preserveExprCondition = preserveExprCondition;
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Project origProj = (Project)call.rel(0);
        Correlate corr = (Correlate)call.rel(1);
        PushProjector pushProject = new PushProjector(origProj, call.builder().literal(true), corr, this.preserveExprCondition, call.builder());
        if (pushProject.locateAllRefs()) {
            return;
        }
        Project leftProjRel = pushProject.createProjectRefsAndExprs(corr.getLeft(), true, false);
        RelNode rightProjRel = pushProject.createProjectRefsAndExprs(corr.getRight(), true, true);
        HashMap<Integer, Integer> requiredColsMap = new HashMap<Integer, Integer>();
        int[] adjustments = pushProject.getAdjustments();
        BitSet updatedBits = new BitSet();
        for (Integer col : corr.getRequiredColumns()) {
            int newCol = col + adjustments[col];
            updatedBits.set(newCol);
            requiredColsMap.put(col, newCol);
        }
        RexBuilder rexBuilder = call.builder().getRexBuilder();
        CorrelationId correlationId = corr.getCluster().createCorrel();
        RexCorrelVariable rexCorrel = (RexCorrelVariable)rexBuilder.makeCorrel(leftProjRel.getRowType(), correlationId);
        rightProjRel = rightProjRel.accept(new RelNodesExprsHandler(new RexFieldAccessReplacer(corr.getCorrelationId(), rexCorrel, rexBuilder, requiredColsMap)));
        Correlate newCorrRel = corr.copy(corr.getTraitSet(), leftProjRel, rightProjRel, correlationId, ImmutableBitSet.of(BitSets.toIter(updatedBits)), corr.getJoinType());
        RelNode topProject = pushProject.createNewProject(newCorrRel, adjustments);
        call.transformTo(topProject);
    }

    public static class RelNodesExprsHandler
    extends RelShuttleImpl {
        private final RexShuttle rexVisitor;

        public RelNodesExprsHandler(RexShuttle rexVisitor) {
            this.rexVisitor = rexVisitor;
        }

        @Override
        protected RelNode visitChild(RelNode parent, int i, RelNode child) {
            if (child instanceof HepRelVertex) {
                child = ((HepRelVertex)child).getCurrentRel();
            } else if (child instanceof RelSubset) {
                RelSubset subset = (RelSubset)child;
                child = Util.first(subset.getBest(), subset.getOriginal());
            }
            return super.visitChild(parent, i, child).accept(this.rexVisitor);
        }
    }

    public static class RexFieldAccessReplacer
    extends RexShuttle {
        private final RexBuilder builder;
        private final CorrelationId rexCorrelVariableToReplace;
        private final RexCorrelVariable rexCorrelVariable;
        private final Map<Integer, Integer> requiredColsMap;

        public RexFieldAccessReplacer(CorrelationId rexCorrelVariableToReplace, RexCorrelVariable rexCorrelVariable, RexBuilder builder, Map<Integer, Integer> requiredColsMap) {
            this.rexCorrelVariableToReplace = rexCorrelVariableToReplace;
            this.rexCorrelVariable = rexCorrelVariable;
            this.builder = builder;
            this.requiredColsMap = requiredColsMap;
        }

        @Override
        public RexNode visitCorrelVariable(RexCorrelVariable variable) {
            if (variable.id.equals(this.rexCorrelVariableToReplace)) {
                return this.rexCorrelVariable;
            }
            return variable;
        }

        @Override
        public RexNode visitFieldAccess(RexFieldAccess fieldAccess) {
            RexNode refExpr = fieldAccess.getReferenceExpr().accept(this);
            if (refExpr == this.rexCorrelVariable) {
                return this.builder.makeFieldAccess(refExpr, this.requiredColsMap.get(fieldAccess.getField().getIndex()));
            }
            return super.visitFieldAccess(fieldAccess);
        }
    }
}

