/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.runtime;

import com.hazelcast.org.apache.calcite.runtime.SocketFactoryImpl;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class TrustAllSslSocketFactory
extends SocketFactoryImpl {
    private static final TrustAllSslSocketFactory DEFAULT = new TrustAllSslSocketFactory();
    private final SSLSocketFactory sslSocketFactory;

    protected TrustAllSslSocketFactory() {
        TrustManager[] trustAllCerts = new TrustManager[]{new DummyTrustManager()};
        SSLSocketFactory factory = null;
        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            factory = sc.getSocketFactory();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.sslSocketFactory = factory;
    }

    @Override
    public Socket createSocket() throws IOException {
        return this.applySettings(this.sslSocketFactory.createSocket());
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        return this.applySettings(this.sslSocketFactory.createSocket(host, port));
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        return this.applySettings(this.sslSocketFactory.createSocket(address, port, localAddress, localPort));
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        return this.applySettings(this.sslSocketFactory.createSocket(host, port));
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
        return this.applySettings(this.sslSocketFactory.createSocket(host, port, localHost, localPort));
    }

    public static TrustAllSslSocketFactory getDefault() {
        return DEFAULT;
    }

    public static SSLSocketFactory getDefaultSSLSocketFactory() {
        return TrustAllSslSocketFactory.DEFAULT.sslSocketFactory;
    }

    public static SSLSocketFactory createSSLSocketFactory() {
        SSLSocketFactory sslsocketfactory = null;
        TrustManager[] trustAllCerts = new TrustManager[]{new DummyTrustManager()};
        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            sslsocketfactory = sc.getSocketFactory();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sslsocketfactory;
    }

    private static class DummyTrustManager
    implements X509TrustManager {
        private DummyTrustManager() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) {
        }
    }
}

