/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.kubernetes;

import com.hazelcast.kubernetes.HazelcastKubernetesDiscoveryStrategy;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.discovery.DiscoveryNode;
import com.hazelcast.spi.discovery.SimpleDiscoveryNode;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.xbill.DNS.Address;
import org.xbill.DNS.ExtendedResolver;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Record;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.SRVRecord;
import org.xbill.DNS.TextParseException;

final class DnsEndpointResolver
extends HazelcastKubernetesDiscoveryStrategy.EndpointResolver {
    private final String serviceDns;
    private final int serviceDnsTimeout;

    DnsEndpointResolver(ILogger logger, String serviceDns, int serviceDnsTimeout) {
        super(logger);
        this.serviceDns = serviceDns;
        this.serviceDnsTimeout = serviceDnsTimeout;
    }

    @Override
    List<DiscoveryNode> resolve() {
        try {
            Lookup lookup = this.buildLookup();
            Record[] records = lookup.run();
            if (lookup.getResult() != 0) {
                this.logger.warning("DNS lookup for serviceDns '" + this.serviceDns + "' failed");
                return Collections.emptyList();
            }
            HashSet<com.hazelcast.nio.Address> addresses = new HashSet<com.hazelcast.nio.Address>();
            for (Record record : records) {
                SRVRecord srv = (SRVRecord)record;
                InetAddress[] inetAddress = this.getAllAddresses(srv);
                int port = this.getHazelcastPort(srv.getPort());
                for (InetAddress i : inetAddress) {
                    com.hazelcast.nio.Address address = new com.hazelcast.nio.Address(i, port);
                    if (!addresses.add(address) || !this.logger.isFinestEnabled()) continue;
                    this.logger.finest("Found node service with address: " + address);
                }
            }
            if (addresses.size() == 0) {
                this.logger.warning("Could not find any service for serviceDns '" + this.serviceDns + "'");
                return Collections.emptyList();
            }
            return this.asDiscoveredNodes(addresses);
        }
        catch (TextParseException e) {
            throw new RuntimeException("Could not resolve services via DNS", e);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("Could not resolve services via DNS", e);
        }
    }

    private Lookup buildLookup() throws TextParseException, UnknownHostException {
        ExtendedResolver resolver = new ExtendedResolver();
        resolver.setTimeout(this.serviceDnsTimeout);
        Lookup lookup = new Lookup(this.serviceDns, 33);
        lookup.setResolver((Resolver)resolver);
        lookup.setCache(null);
        return lookup;
    }

    private List<DiscoveryNode> asDiscoveredNodes(Set<com.hazelcast.nio.Address> addresses) {
        ArrayList<DiscoveryNode> discoveryNodes = new ArrayList<DiscoveryNode>();
        for (com.hazelcast.nio.Address address : addresses) {
            discoveryNodes.add((DiscoveryNode)new SimpleDiscoveryNode(address));
        }
        return discoveryNodes;
    }

    private int getHazelcastPort(int port) {
        if (port > 0) {
            return port;
        }
        return 5701;
    }

    private InetAddress[] getAllAddresses(SRVRecord srv) throws UnknownHostException {
        try {
            return Address.getAllByName((String)srv.getTarget().canonicalize().toString(true));
        }
        catch (UnknownHostException e) {
            this.logger.severe("Parsing DNS records failed", (Throwable)e);
            throw e;
        }
    }
}

