/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.kubernetes;

import com.hazelcast.kubernetes.HazelcastKubernetesDiscoveryStrategy;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.spi.discovery.DiscoveryNode;
import com.hazelcast.spi.discovery.SimpleDiscoveryNode;
import com.hazelcast.util.StringUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.fabric8.kubernetes.api.model.EndpointAddress;
import io.fabric8.kubernetes.api.model.EndpointSubset;
import io.fabric8.kubernetes.api.model.Endpoints;
import io.fabric8.kubernetes.api.model.EndpointsList;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.EditableConfig;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.ClientNonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ClientResource;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

class ServiceEndpointResolver
extends HazelcastKubernetesDiscoveryStrategy.EndpointResolver {
    private final String serviceName;
    private final String serviceLabel;
    private final String serviceLabelValue;
    private final String namespace;
    private final KubernetesClient client;

    ServiceEndpointResolver(ILogger logger, String serviceName, String serviceLabel, String serviceLabelValue, String namespace, String kubernetesMaster, String apiToken) {
        super(logger);
        this.serviceName = serviceName;
        this.namespace = namespace;
        this.serviceLabel = serviceLabel;
        this.serviceLabelValue = serviceLabelValue;
        this.client = this.buildKubernetesClient(apiToken, kubernetesMaster);
    }

    private KubernetesClient buildKubernetesClient(String apiToken, String kubernetesMaster) {
        String oauthToken = apiToken;
        if (StringUtil.isNullOrEmpty((String)oauthToken)) {
            oauthToken = this.getAccountToken();
        }
        this.logger.info("Kubernetes Discovery: Bearer Token { " + apiToken + " }");
        EditableConfig config = ((ConfigBuilder)((ConfigBuilder)new ConfigBuilder().withOauthToken(oauthToken)).withMasterUrl(kubernetesMaster)).build();
        return new DefaultKubernetesClient((Config)config);
    }

    @Override
    List<DiscoveryNode> resolve() {
        List<Object> result = Collections.emptyList();
        if (this.serviceName != null && !this.serviceName.isEmpty()) {
            result = this.getSimpleDiscoveryNodes((Endpoints)((ClientResource)((ClientNonNamespaceOperation)this.client.endpoints().inNamespace(this.namespace)).withName(this.serviceName)).get());
        }
        if (result.isEmpty() && this.serviceLabel != null && !this.serviceLabel.isEmpty()) {
            result = this.getDiscoveryNodes((EndpointsList)((FilterWatchListDeletable)((ClientNonNamespaceOperation)this.client.endpoints().inNamespace(this.namespace)).withLabel(this.serviceLabel, this.serviceLabelValue)).list());
        }
        return result.isEmpty() ? this.getNodesByNamespace() : result;
    }

    private List<DiscoveryNode> getNodesByNamespace() {
        EndpointsList endpointsInNamespace = (EndpointsList)((ClientNonNamespaceOperation)this.client.endpoints().inNamespace(this.namespace)).list();
        if (endpointsInNamespace == null) {
            return Collections.emptyList();
        }
        return this.getDiscoveryNodes(endpointsInNamespace);
    }

    private List<DiscoveryNode> getDiscoveryNodes(EndpointsList endpointsInNamespace) {
        if (endpointsInNamespace == null) {
            return Collections.emptyList();
        }
        ArrayList<DiscoveryNode> discoveredNodes = new ArrayList<DiscoveryNode>();
        for (Endpoints endpoints : endpointsInNamespace.getItems()) {
            discoveredNodes.addAll(this.getSimpleDiscoveryNodes(endpoints));
        }
        return discoveredNodes;
    }

    private List<DiscoveryNode> getSimpleDiscoveryNodes(Endpoints endpoints) {
        if (endpoints == null) {
            return Collections.emptyList();
        }
        ArrayList<DiscoveryNode> discoveredNodes = new ArrayList<DiscoveryNode>();
        for (EndpointSubset endpointSubset : endpoints.getSubsets()) {
            for (EndpointAddress endpointAddress : endpointSubset.getAddresses()) {
                Map properties = endpointAddress.getAdditionalProperties();
                String ip = endpointAddress.getIp();
                InetAddress inetAddress = this.mapAddress(ip);
                int port = this.getServicePort(properties);
                Address address = new Address(inetAddress, port);
                discoveredNodes.add((DiscoveryNode)new SimpleDiscoveryNode(address, properties));
            }
        }
        return discoveredNodes;
    }

    @Override
    void destroy() {
        this.client.close();
    }

    @SuppressFBWarnings(value={"DMI_HARDCODED_ABSOLUTE_FILENAME"})
    private String getAccountToken() {
        String string;
        FileInputStream is = null;
        try {
            String tokenFile = "/var/run/secrets/kubernetes.io/serviceaccount/token";
            File file = new File(tokenFile);
            byte[] data = new byte[(int)file.length()];
            is = new FileInputStream(file);
            ((InputStream)is).read(data);
            string = new String(data, "UTF-8");
        }
        catch (IOException e) {
            try {
                throw new RuntimeException("Could not get token file", e);
            }
            catch (Throwable throwable) {
                IOUtil.closeResource(is);
                throw throwable;
            }
        }
        IOUtil.closeResource((Closeable)is);
        return string;
    }
}

